/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.abac;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An attribute is a simple matcher for policies. A Attribute is created from a JsonPointer to the  object
 * and a logical operator:
 *
 * <ul>
 *   <li>{@link io.vertx.reactivex.ext.auth.abac.Attribute#has} - the value must be in the JsonArray or JsonObject</li>
 *   <li>{@link io.vertx.reactivex.ext.auth.abac.Attribute#eq} - the value must be equals to the pointed location</li>
 *   <li>{@link io.vertx.reactivex.ext.auth.abac.Attribute#ne} - the value must not be equals to the pointed location</li>
 * </ul>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.abac.Attribute original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.abac.Attribute.class)
public class Attribute implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Attribute that = (Attribute) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Attribute> __TYPE_ARG = new TypeArg<>(    obj -> new Attribute((io.vertx.ext.auth.abac.Attribute) obj),
    Attribute::getDelegate
  );

  private final io.vertx.ext.auth.abac.Attribute delegate;
  
  public Attribute(io.vertx.ext.auth.abac.Attribute delegate) {
    this.delegate = delegate;
  }

  public Attribute(Object delegate) {
    this.delegate = (io.vertx.ext.auth.abac.Attribute)delegate;
  }

  @Override 
  public io.vertx.ext.auth.abac.Attribute getDelegate() {
    return delegate;
  }

  /**
   * Verifies whether the attribute matches the specified. The value must be in the JsonArray or JsonObject
   * referenced by the json pointer.
   * @param pointer 
   * @param value 
   * @return 
   */
  public static io.vertx.reactivex.ext.auth.abac.Attribute has(java.lang.String pointer, java.lang.Object value) { 
    io.vertx.reactivex.ext.auth.abac.Attribute ret = io.vertx.reactivex.ext.auth.abac.Attribute.newInstance((io.vertx.ext.auth.abac.Attribute)io.vertx.ext.auth.abac.Attribute.has(pointer, value));
    return ret;
  }

  /**
   * Verifies whether the attribute matches the specified. The value must be equal to the value
   * referenced by the json pointer.
   * @param pointer 
   * @param value 
   * @return 
   */
  public static io.vertx.reactivex.ext.auth.abac.Attribute eq(java.lang.String pointer, java.lang.Object value) { 
    io.vertx.reactivex.ext.auth.abac.Attribute ret = io.vertx.reactivex.ext.auth.abac.Attribute.newInstance((io.vertx.ext.auth.abac.Attribute)io.vertx.ext.auth.abac.Attribute.eq(pointer, value));
    return ret;
  }

  /**
   * Verifies whether the attribute matches the specified. The value must not be equal to the value
   * referenced by the json pointer.
   * @param pointer 
   * @param value 
   * @return 
   */
  public static io.vertx.reactivex.ext.auth.abac.Attribute ne(java.lang.String pointer, java.lang.Object value) { 
    io.vertx.reactivex.ext.auth.abac.Attribute ret = io.vertx.reactivex.ext.auth.abac.Attribute.newInstance((io.vertx.ext.auth.abac.Attribute)io.vertx.ext.auth.abac.Attribute.ne(pointer, value));
    return ret;
  }

  /**
   * A custom function to be used during matching.
   * @param function 
   * @return 
   */
  public static io.vertx.reactivex.ext.auth.abac.Attribute create(java.util.function.Function<io.vertx.reactivex.ext.auth.User,java.lang.Boolean> function) { 
    io.vertx.reactivex.ext.auth.abac.Attribute ret = io.vertx.reactivex.ext.auth.abac.Attribute.newInstance((io.vertx.ext.auth.abac.Attribute)io.vertx.ext.auth.abac.Attribute.create(new Function<io.vertx.ext.auth.User,java.lang.Boolean>() {
      public java.lang.Boolean apply(io.vertx.ext.auth.User arg) {
        java.lang.Boolean ret = function.apply(io.vertx.reactivex.ext.auth.User.newInstance((io.vertx.ext.auth.User)arg));
        return ret;
      }
    }));
    return ret;
  }

  /**
   * Verifies whether the attribute matches the specified
   * user.
   * @param user the user.
   * @return true if there's a match
   */
  public boolean match(io.vertx.reactivex.ext.auth.User user) { 
    boolean ret = delegate.match(user.getDelegate());
    return ret;
  }

  public io.vertx.core.json.JsonObject toJson() { 
    io.vertx.core.json.JsonObject ret = delegate.toJson();
    return ret;
  }

  public static Attribute newInstance(io.vertx.ext.auth.abac.Attribute arg) {
    return arg != null ? new Attribute(arg) : null;
  }

}
