/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents an authenticates User and contains operations to authorise the user.
 * <p>
 * Please consult the documentation for a detailed explanation.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.User original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.User.class)
public class User implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    User that = (User) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<User> __TYPE_ARG = new TypeArg<>(    obj -> new User((io.vertx.ext.auth.User) obj),
    User::getDelegate
  );

  private final io.vertx.ext.auth.User delegate;
  
  public User(io.vertx.ext.auth.User delegate) {
    this.delegate = delegate;
  }

  public User(Object delegate) {
    this.delegate = (io.vertx.ext.auth.User)delegate;
  }

  @Override 
  public io.vertx.ext.auth.User getDelegate() {
    return delegate;
  }

  /**
   * Factory for user instances that are single string. The credentials will be added to the principal
   * of this instance. As nothing can be said about the credentials no validation will be done.
   * <p>
   * Will create a principal with a property <code>"username"</code> with the name as value.
   * @param username the value for this user
   * @return user instance
   */
  public static io.vertx.reactivex.ext.auth.User fromName(java.lang.String username) { 
    io.vertx.reactivex.ext.auth.User ret = io.vertx.reactivex.ext.auth.User.newInstance((io.vertx.ext.auth.User)io.vertx.ext.auth.User.fromName(username));
    return ret;
  }

  /**
   * Factory for user instances that are single string. The credentials will be added to the principal
   * of this instance. As nothing can be said about the credentials no validation will be done.
   * <p>
   * Will create a principal with a property <code>"access_token"</code> with the name as value.
   * @param token the value for this user
   * @return user instance
   */
  public static io.vertx.reactivex.ext.auth.User fromToken(java.lang.String token) { 
    io.vertx.reactivex.ext.auth.User ret = io.vertx.reactivex.ext.auth.User.newInstance((io.vertx.ext.auth.User)io.vertx.ext.auth.User.fromToken(token));
    return ret;
  }

  /**
   * Factory for user instances that are free form. The credentials will be added to the principal
   * of this instance. As nothing can be said about the credentials no validation will be done.
   * @param principal the free form json principal
   * @return user instance
   */
  public static io.vertx.reactivex.ext.auth.User create(io.vertx.core.json.JsonObject principal) { 
    io.vertx.reactivex.ext.auth.User ret = io.vertx.reactivex.ext.auth.User.newInstance((io.vertx.ext.auth.User)io.vertx.ext.auth.User.create(principal));
    return ret;
  }

  /**
   * Factory for user instances that are free form. The credentials will be added to the principal
   * of this instance. As nothing can be said about the credentials no validation will be done.
   * @param principal the free form json principal
   * @param attributes the free form json attributes that further describe the principal
   * @return user instance
   */
  public static io.vertx.reactivex.ext.auth.User create(io.vertx.core.json.JsonObject principal, io.vertx.core.json.JsonObject attributes) { 
    io.vertx.reactivex.ext.auth.User ret = io.vertx.reactivex.ext.auth.User.newInstance((io.vertx.ext.auth.User)io.vertx.ext.auth.User.create(principal, attributes));
    return ret;
  }

  /**
   * The user subject. Usually a human representation that identifies this user.
   * <p>
   * The lookup for this information will take place in several places in the following order:
   *
   * <ol>
   *   <li><code>principal.username</code> - Usually for username/password or webauthn authentication</li>
   *   <li><code>principal.userHandle</code> - Optional field for webauthn</li>
   *   <li><code>attributes.idToken.sub</code> - For OpenID Connect ID Tokens</li>
   *   <li><code>attributes.[rootClaim?]accessToken.sub</code> - For OpenID Connect/OAuth2 Access Tokens</li>
   * </ol>
   * @return the subject for this user or <code>null</code>.
   */
  public java.lang.String subject() { 
    java.lang.String ret = delegate.subject();
    return ret;
  }

  /**
   * Gets extra attributes of the user. Attributes contain any attributes related
   * to the outcome of authenticating a user (e.g.: issued date, metadata, etc...)
   * @return a json object with any relevant attribute.
   */
  public io.vertx.core.json.JsonObject attributes() { 
    io.vertx.core.json.JsonObject ret = delegate.attributes();
    return ret;
  }

  /**
   * Flags this user object to be expired. A User is considered expired if it contains an expiration time and
   * the current clock time is post the expiration date.
   * @return <code>true</code> if expired
   */
  public boolean expired() { 
    boolean ret = delegate.expired();
    return ret;
  }

  /**
   * Flags this user object to be expired. Expiration takes 3 values in account:
   *
   * <ol>
   *   <li><code>exp</code> "expiration" timestamp in seconds.</li>
   *   <li><code>iat</code> "issued at" in seconds.</li>
   *   <li><code>nbf</code> "not before" in seconds.</li>
   * </ol>
   * A User is considered expired if it contains any of the above and
   * the current clock time does not agree with the parameter value. If the {@link io.vertx.reactivex.ext.auth.User#attributes} do not contain a key
   * then {@link io.vertx.reactivex.ext.auth.User#principal} properties are checked.
   * <p>
   * If all of the properties are not available the user will not expire.
   * <p>
   * Implementations of this interface might relax this rule to account for a leeway to safeguard against
   * clock drifting.
   * @param leeway a greater than zero leeway value.
   * @return <code>true</code> if expired
   */
  public boolean expired(int leeway) { 
    boolean ret = delegate.expired(leeway);
    return ret;
  }

  /**
   * Get a value from the user object. This method will perform lookups on several places before returning a value.
   * <ol>
   *   <li>If there is a <code>rootClaim</code> the look up will happen in the <code>attributes[rootClaim]</code></li>
   *   <li>If exists the value will be returned from the {@link io.vertx.reactivex.ext.auth.User#attributes}</li>
   *   <li>If exists the value will be returned from the {@link io.vertx.reactivex.ext.auth.User#principal}</li>
   *   <li>Otherwise it will be <code>null</code></li>
   * </ol>
   * @param key the key to look up
   * @return the value or null if missing
   */
  public <T> T get(java.lang.String key) { 
    T ret = (T) delegate.get(key);
    return ret;
  }

  /**
   * Get a value from the user object. This method will perform lookups on several places before returning a value.
   * <ol>
   *   <li>If there is a <code>rootClaim</code> the look up will happen in the <code>attributes[rootClaim]</code></li>
   *   <li>If exists the value will be returned from the {@link io.vertx.reactivex.ext.auth.User#attributes}</li>
   *   <li>If exists the value will be returned from the {@link io.vertx.reactivex.ext.auth.User#principal}</li>
   *   <li>Otherwise it will be <code>null</code></li>
   * </ol>
   * @param key the key to look up
   * @param defaultValue default value to return if missing
   * @return the value or null if missing
   */
  public <T> T getOrDefault(java.lang.String key, T defaultValue) { 
    T ret = (T) delegate.getOrDefault(key, defaultValue);
    return ret;
  }

  /**
   * Checks if a value exists on the user object. This method will perform lookups on several places before returning.
   * <ol>
   *   <li>If there is a <code>rootClaim</code> the look up will happen in the <code>attributes[rootClaim]</code></li>
   *   <li>If exists the value will be returned from the {@link io.vertx.reactivex.ext.auth.User#attributes}</li>
   *   <li>If exists the value will be returned from the {@link io.vertx.reactivex.ext.auth.User#principal}</li>
   *   <li>Otherwise it will be <code>null</code></li>
   * </ol>
   * @param key the key to look up
   * @return the value or null if missing
   */
  public boolean containsKey(java.lang.String key) { 
    boolean ret = delegate.containsKey(key);
    return ret;
  }

  /**
   * Returns user's authorizations that have been previously loaded by the providers.
   * @return authorizations holder for the user.
   */
  public io.vertx.reactivex.ext.auth.authorization.Authorizations authorizations() { 
    io.vertx.reactivex.ext.auth.authorization.Authorizations ret = io.vertx.reactivex.ext.auth.authorization.Authorizations.newInstance((io.vertx.ext.auth.authorization.Authorizations)delegate.authorizations());
    return ret;
  }

  /**
   * Get the underlying principal for the User. What this actually returns depends on the implementation.
   * For a simple user/password based auth, it's likely to contain a JSON object with the following structure:
   * <pre>
   *   {
   *     "username", "tim"
   *   }
   * </pre>
   * @return JSON representation of the Principal
   */
  public io.vertx.core.json.JsonObject principal() { 
    io.vertx.core.json.JsonObject ret = delegate.principal();
    return ret;
  }

  /**
   * Merge the principal and attributes of a second user into this object properties.
   * <p>
   * It is important to notice that the principal merges by replacing existing keys with the new values, while the
   * attributes (as they represent decoded data) are accumulated at the root level.
   * <p>
   * This means that given:
   *
   * <pre><code>userA = {
   attributes: {
     roles: [ 'read' ]</code>
   * }
   *
   * userB = {
   *   attributes: {
   *     roles: [ 'write' ]
   *   }
   * }
   * }</pre>
   * <p>
   * When performing a merge of <code>userA</code> with <code>userB</code>, you will get:
   *
   * <pre><code>userA.merge(userB);
 // results in
 {
   attributes: {
     roles: [ 'read', 'write' ]</code>
   * }
   * }</pre>
   * @param other the other user to merge
   * @return fluent self
   */
  public io.vertx.reactivex.ext.auth.User merge(io.vertx.reactivex.ext.auth.User other) { 
    delegate.merge(other.getDelegate());
    return this;
  }

  /**
   * The "amr" (Authentication Methods References) returns a unique list of claims as defined and
   * registered in the IANA "JSON Web Token Claims" registry. The values in this collection are based
   * on <a href="https://datatracker.ietf.org/doc/html/rfc8176">RFC8176</a>. This information can be used
   * to filter authenticated users by their authentication mechanism.
   * @param value 
   * @return <code>true</code> if claim is present in the principal.
   */
  public boolean hasAmr(java.lang.String value) { 
    boolean ret = delegate.hasAmr(value);
    return ret;
  }

  public static User newInstance(io.vertx.ext.auth.User arg) {
    return arg != null ? new User(arg) : null;
  }

}
