/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.db2client;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A connection to DB2 server.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.db2client.DB2Connection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.db2client.DB2Connection.class)
public class DB2Connection extends io.vertx.reactivex.sqlclient.SqlConnection implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DB2Connection that = (DB2Connection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<DB2Connection> __TYPE_ARG = new TypeArg<>(    obj -> new DB2Connection((io.vertx.db2client.DB2Connection) obj),
    DB2Connection::getDelegate
  );

  private final io.vertx.db2client.DB2Connection delegate;
  
  public DB2Connection(io.vertx.db2client.DB2Connection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public DB2Connection(Object delegate) {
    super((io.vertx.db2client.DB2Connection)delegate);
    this.delegate = (io.vertx.db2client.DB2Connection)delegate;
  }

  @Override 
  public io.vertx.db2client.DB2Connection getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.db2client.DB2Connection> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.db2client.DB2Connection>(o1 -> io.vertx.reactivex.db2client.DB2Connection.newInstance((io.vertx.db2client.DB2Connection)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.db2client.DB2Connection> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.db2client.DB2Connection>(o1 -> io.vertx.reactivex.db2client.DB2Connection.newInstance((io.vertx.db2client.DB2Connection)o1), o1 -> o1.getDelegate());

  /**
   * Create a connection to DB2 server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return a future notified with the connection or the failure
   */
  public static io.vertx.core.Future<io.vertx.reactivex.db2client.DB2Connection> connect(io.vertx.reactivex.core.Vertx vertx, io.vertx.db2client.DB2ConnectOptions connectOptions) { 
    io.vertx.core.Future<io.vertx.reactivex.db2client.DB2Connection> ret = io.vertx.db2client.DB2Connection.connect(vertx.getDelegate(), connectOptions).map(val -> io.vertx.reactivex.db2client.DB2Connection.newInstance((io.vertx.db2client.DB2Connection)val));
    return ret;
  }

  /**
   * Create a connection to DB2 server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return a future notified with the connection or the failure
   */
  public static io.reactivex.Single<io.vertx.reactivex.db2client.DB2Connection> rxConnect(io.vertx.reactivex.core.Vertx vertx, io.vertx.db2client.DB2ConnectOptions connectOptions) { 
    return AsyncResultSingle.toSingle($handler -> {
      io.vertx.reactivex.db2client.DB2Connection.connect(vertx, connectOptions).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.db2client.DB2Connection#connect} with options build
   * from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.core.Future<io.vertx.reactivex.db2client.DB2Connection> connect(io.vertx.reactivex.core.Vertx vertx, java.lang.String connectionUri) { 
    io.vertx.core.Future<io.vertx.reactivex.db2client.DB2Connection> ret = io.vertx.db2client.DB2Connection.connect(vertx.getDelegate(), connectionUri).map(val -> io.vertx.reactivex.db2client.DB2Connection.newInstance((io.vertx.db2client.DB2Connection)val));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.db2client.DB2Connection#connect} with options build
   * from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.db2client.DB2Connection> rxConnect(io.vertx.reactivex.core.Vertx vertx, java.lang.String connectionUri) { 
    return AsyncResultSingle.toSingle($handler -> {
      io.vertx.reactivex.db2client.DB2Connection.connect(vertx, connectionUri).onComplete($handler);
    });
  }

  public io.vertx.reactivex.db2client.DB2Connection exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.db2client.DB2Connection closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Send a PING command to check if the server is alive.
   * @return a future notified with the server response
   */
  public io.vertx.core.Future<java.lang.Void> ping() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.ping().map(val -> val);
    return ret;
  }

  /**
   * Send a PING command to check if the server is alive.
   * @return a future notified with the server response
   */
  public io.reactivex.Completable rxPing() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.ping().onComplete($handler);
    });
  }

  /**
   * Send a DEBUG command to dump debug information to the server's stdout.
   * @return a future notified with the execution result
   */
  public io.vertx.core.Future<java.lang.Void> debug() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.debug().map(val -> val);
    return ret;
  }

  /**
   * Send a DEBUG command to dump debug information to the server's stdout.
   * @return a future notified with the execution result
   */
  public io.reactivex.Completable rxDebug() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.debug().onComplete($handler);
    });
  }

  /**
   * Cast a  to {@link io.vertx.reactivex.db2client.DB2Connection}.
   *
   * This is mostly useful for Vert.x generated APIs like RxJava/Mutiny.
   * @param sqlConnection the connection to cast
   * @return a {@link io.vertx.reactivex.db2client.DB2Connection instance}
   */
  public static io.vertx.reactivex.db2client.DB2Connection cast(io.vertx.reactivex.sqlclient.SqlConnection sqlConnection) { 
    io.vertx.reactivex.db2client.DB2Connection ret = io.vertx.reactivex.db2client.DB2Connection.newInstance((io.vertx.db2client.DB2Connection)io.vertx.db2client.DB2Connection.cast(sqlConnection.getDelegate()));
    return ret;
  }

  public static DB2Connection newInstance(io.vertx.db2client.DB2Connection arg) {
    return arg != null ? new DB2Connection(arg) : null;
  }

}
