/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.shareddata;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Shared data allows you to share data safely between different parts of your application in a safe way.
 * <p>
 * Shared data provides:
 * <ul>
 *   <li>synchronous shared maps (local)</li>
 *   <li>asynchronous maps (local or cluster-wide)</li>
 *   <li>asynchronous locks (local or cluster-wide)</li>
 *   <li>asynchronous counters (local or cluster-wide)</li>
 * </ul>
 * <p>
 * <p>
 *   <strong>WARNING</strong>: In clustered mode, asynchronous maps/locks/counters rely on distributed data structures provided by the cluster manager.
 *   Beware that the latency relative to asynchronous maps/locks/counters operations can be much higher in clustered than in local mode.
 * </p>
 * Please see the documentation for more information.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.SharedData original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.shareddata.SharedData.class)
public class SharedData implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SharedData that = (SharedData) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SharedData> __TYPE_ARG = new TypeArg<>(    obj -> new SharedData((io.vertx.core.shareddata.SharedData) obj),
    SharedData::getDelegate
  );

  private final io.vertx.core.shareddata.SharedData delegate;
  
  public SharedData(io.vertx.core.shareddata.SharedData delegate) {
    this.delegate = delegate;
  }

  public SharedData(Object delegate) {
    this.delegate = (io.vertx.core.shareddata.SharedData)delegate;
  }

  @Override 
  public io.vertx.core.shareddata.SharedData getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.core.shareddata.Lock> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.shareddata.Lock>(o1 -> io.vertx.reactivex.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.shareddata.Lock> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.core.shareddata.Lock>(o1 -> io.vertx.reactivex.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.shareddata.Lock> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.core.shareddata.Lock>(o1 -> io.vertx.reactivex.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.shareddata.Lock> TYPE_ARG_3 = new TypeArg<io.vertx.reactivex.core.shareddata.Lock>(o1 -> io.vertx.reactivex.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.shareddata.Counter> TYPE_ARG_4 = new TypeArg<io.vertx.reactivex.core.shareddata.Counter>(o1 -> io.vertx.reactivex.core.shareddata.Counter.newInstance((io.vertx.core.shareddata.Counter)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.shareddata.Counter> TYPE_ARG_5 = new TypeArg<io.vertx.reactivex.core.shareddata.Counter>(o1 -> io.vertx.reactivex.core.shareddata.Counter.newInstance((io.vertx.core.shareddata.Counter)o1), o1 -> o1.getDelegate());

  /**
   * Get the cluster wide map with the specified name. The map is accessible to all nodes in the cluster and data
   * put into the map from any node is visible to to any other node.
   * @param name the name of the map
   * @return a future notified with the map
   */
  public <K, V> io.vertx.core.Future<io.vertx.reactivex.core.shareddata.AsyncMap<K,V>> getClusterWideMap(java.lang.String name) { 
    io.vertx.core.Future<io.vertx.reactivex.core.shareddata.AsyncMap<K,V>> ret = delegate.getClusterWideMap(name).map(val -> io.vertx.reactivex.core.shareddata.AsyncMap.newInstance((io.vertx.core.shareddata.AsyncMap)val, TypeArg.unknown(), TypeArg.unknown()));
    return ret;
  }

  /**
   * Get the cluster wide map with the specified name. The map is accessible to all nodes in the cluster and data
   * put into the map from any node is visible to to any other node.
   * @param name the name of the map
   * @return a future notified with the map
   */
  public <K, V> io.reactivex.Single<io.vertx.reactivex.core.shareddata.AsyncMap<K,V>> rxGetClusterWideMap(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.<K, V>getClusterWideMap(name).onComplete($handler);
    });
  }

  /**
   * Get the {@link io.vertx.reactivex.core.shareddata.AsyncMap} with the specified name. When clustered, the map is accessible to all nodes in the cluster
   * and data put into the map from any node is visible to to any other node.
   * <p>
   *   <strong>WARNING</strong>: In clustered mode, asynchronous shared maps rely on distributed data structures provided by the cluster manager.
   *   Beware that the latency relative to asynchronous shared maps operations can be much higher in clustered than in local mode.
   * </p>
   * @param name the name of the map
   * @return a future notified with the map
   */
  public <K, V> io.vertx.core.Future<io.vertx.reactivex.core.shareddata.AsyncMap<K,V>> getAsyncMap(java.lang.String name) { 
    io.vertx.core.Future<io.vertx.reactivex.core.shareddata.AsyncMap<K,V>> ret = delegate.getAsyncMap(name).map(val -> io.vertx.reactivex.core.shareddata.AsyncMap.newInstance((io.vertx.core.shareddata.AsyncMap)val, TypeArg.unknown(), TypeArg.unknown()));
    return ret;
  }

  /**
   * Get the {@link io.vertx.reactivex.core.shareddata.AsyncMap} with the specified name. When clustered, the map is accessible to all nodes in the cluster
   * and data put into the map from any node is visible to to any other node.
   * <p>
   *   <strong>WARNING</strong>: In clustered mode, asynchronous shared maps rely on distributed data structures provided by the cluster manager.
   *   Beware that the latency relative to asynchronous shared maps operations can be much higher in clustered than in local mode.
   * </p>
   * @param name the name of the map
   * @return a future notified with the map
   */
  public <K, V> io.reactivex.Single<io.vertx.reactivex.core.shareddata.AsyncMap<K,V>> rxGetAsyncMap(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.<K, V>getAsyncMap(name).onComplete($handler);
    });
  }

  /**
   * Get the {@link io.vertx.reactivex.core.shareddata.AsyncMap} with the specified name.
   * <p>
   * When clustered, the map is <b>NOT</b> accessible to all nodes in the cluster.
   * Only the instance which created the map can put and retrieve data from this map.
   * @param name the name of the map
   * @return a future notified with the map
   */
  public <K, V> io.vertx.core.Future<io.vertx.reactivex.core.shareddata.AsyncMap<K,V>> getLocalAsyncMap(java.lang.String name) { 
    io.vertx.core.Future<io.vertx.reactivex.core.shareddata.AsyncMap<K,V>> ret = delegate.getLocalAsyncMap(name).map(val -> io.vertx.reactivex.core.shareddata.AsyncMap.newInstance((io.vertx.core.shareddata.AsyncMap)val, TypeArg.unknown(), TypeArg.unknown()));
    return ret;
  }

  /**
   * Get the {@link io.vertx.reactivex.core.shareddata.AsyncMap} with the specified name.
   * <p>
   * When clustered, the map is <b>NOT</b> accessible to all nodes in the cluster.
   * Only the instance which created the map can put and retrieve data from this map.
   * @param name the name of the map
   * @return a future notified with the map
   */
  public <K, V> io.reactivex.Single<io.vertx.reactivex.core.shareddata.AsyncMap<K,V>> rxGetLocalAsyncMap(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.<K, V>getLocalAsyncMap(name).onComplete($handler);
    });
  }

  /**
   * Get an asynchronous lock with the specified name. The returned future will be completed with the lock when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @return a future notified with the lock
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.shareddata.Lock> getLock(java.lang.String name) { 
    io.vertx.core.Future<io.vertx.reactivex.core.shareddata.Lock> ret = delegate.getLock(name).map(val -> io.vertx.reactivex.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)val));
    return ret;
  }

  /**
   * Get an asynchronous lock with the specified name. The returned future will be completed with the lock when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @return a future notified with the lock
   */
  public io.reactivex.Single<io.vertx.reactivex.core.shareddata.Lock> rxGetLock(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getLock(name).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.SharedData#getLock} but specifying a timeout. If the lock is not obtained within the timeout the returned
   * future is failed.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return a future notified with the lock
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.shareddata.Lock> getLockWithTimeout(java.lang.String name, long timeout) { 
    io.vertx.core.Future<io.vertx.reactivex.core.shareddata.Lock> ret = delegate.getLockWithTimeout(name, timeout).map(val -> io.vertx.reactivex.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)val));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.SharedData#getLock} but specifying a timeout. If the lock is not obtained within the timeout the returned
   * future is failed.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return a future notified with the lock
   */
  public io.reactivex.Single<io.vertx.reactivex.core.shareddata.Lock> rxGetLockWithTimeout(java.lang.String name, long timeout) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getLockWithTimeout(name, timeout).onComplete($handler);
    });
  }

  /**
   * Get an asynchronous lock with the specified name.
   *
   * <p>When the <code>block</code> is called, the lock is already acquired, it will be released when the
   * <code>Future<T></code> returned by the block completes.
   *
   * <p>When the <code>block</code> fails, the lock is released and the returned future is failed with the cause of the failure.
   *
   * <p>In general lock acquision is unordered, so that sequential attempts to acquire a lock, even from a single thread,
   * can happen in non-sequential order.
   * @param name the name of the lock
   * @param block 
   * @return the future returned by the <code>block</code>
   */
  public <T> io.vertx.core.Future<T> withLock(java.lang.String name, java.util.function.Supplier<io.vertx.core.Future<T>> block) { 
    io.vertx.core.Future<T> ret = delegate.withLock(name, new Supplier<io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> get() {
        io.vertx.core.Future<T> ret = block.get();
        return ret.map(val -> val);
      }
    }).map(val -> (T) val);
    return ret;
  }

  /**
   * Get an asynchronous lock with the specified name.
   *
   * <p>When the <code>block</code> is called, the lock is already acquired, it will be released when the
   * <code>Future<T></code> returned by the block completes.
   *
   * <p>When the <code>block</code> fails, the lock is released and the returned future is failed with the cause of the failure.
   *
   * <p>In general lock acquision is unordered, so that sequential attempts to acquire a lock, even from a single thread,
   * can happen in non-sequential order.
   * @param name the name of the lock
   * @param block 
   * @return the future returned by the <code>block</code>
   */
  public <T> io.reactivex.Single<T> rxWithLock(java.lang.String name, java.util.function.Supplier<io.vertx.core.Future<T>> block) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.<T>withLock(name, block).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.SharedData#withLock} but specifying a timeout. If the lock is not obtained within the timeout
   * the returned future is failed.
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @param block the code block called after lock acquisition
   * @return the future returned by the <code>block</code>
   */
  public <T> io.vertx.core.Future<T> withLock(java.lang.String name, long timeout, java.util.function.Supplier<io.vertx.core.Future<T>> block) { 
    io.vertx.core.Future<T> ret = delegate.withLock(name, timeout, new Supplier<io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> get() {
        io.vertx.core.Future<T> ret = block.get();
        return ret.map(val -> val);
      }
    }).map(val -> (T) val);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.SharedData#withLock} but specifying a timeout. If the lock is not obtained within the timeout
   * the returned future is failed.
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @param block the code block called after lock acquisition
   * @return the future returned by the <code>block</code>
   */
  public <T> io.reactivex.Single<T> rxWithLock(java.lang.String name, long timeout, java.util.function.Supplier<io.vertx.core.Future<T>> block) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.<T>withLock(name, timeout, block).onComplete($handler);
    });
  }

  /**
   * Get an asynchronous local lock with the specified name. The returned future will be completed with the lock when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @return a future notified with the lock
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.shareddata.Lock> getLocalLock(java.lang.String name) { 
    io.vertx.core.Future<io.vertx.reactivex.core.shareddata.Lock> ret = delegate.getLocalLock(name).map(val -> io.vertx.reactivex.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)val));
    return ret;
  }

  /**
   * Get an asynchronous local lock with the specified name. The returned future will be completed with the lock when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @return a future notified with the lock
   */
  public io.reactivex.Single<io.vertx.reactivex.core.shareddata.Lock> rxGetLocalLock(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getLocalLock(name).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.SharedData#getLocalLock} but specifying a timeout.  If the lock is not obtained within the timeout the returned
   * future is failed.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return a future notified with the lock
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.shareddata.Lock> getLocalLockWithTimeout(java.lang.String name, long timeout) { 
    io.vertx.core.Future<io.vertx.reactivex.core.shareddata.Lock> ret = delegate.getLocalLockWithTimeout(name, timeout).map(val -> io.vertx.reactivex.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)val));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.SharedData#getLocalLock} but specifying a timeout.  If the lock is not obtained within the timeout the returned
   * future is failed.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return a future notified with the lock
   */
  public io.reactivex.Single<io.vertx.reactivex.core.shareddata.Lock> rxGetLocalLockWithTimeout(java.lang.String name, long timeout) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getLocalLockWithTimeout(name, timeout).onComplete($handler);
    });
  }

  /**
   * Get an asynchronous local lock with the specified name.
   *
   * <p>When the <code>block</code> is called, the lock is already acquired, it will be released when the
   * <code>Future<T></code> returned by the block completes.
   *
   * <p>When the <code>block</code> fails, the lock is released and the returned future is failed with the cause of the failure.
   *
   * <p>In general lock acquision is unordered, so that sequential attempts to acquire a lock, even from a single thread,
   * can happen in non-sequential order.
   * @param name the name of the lock
   * @param block 
   * @return the future returned by the <code>block</code>
   */
  public <T> io.vertx.core.Future<T> withLocalLock(java.lang.String name, java.util.function.Supplier<io.vertx.core.Future<T>> block) { 
    io.vertx.core.Future<T> ret = delegate.withLocalLock(name, new Supplier<io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> get() {
        io.vertx.core.Future<T> ret = block.get();
        return ret.map(val -> val);
      }
    }).map(val -> (T) val);
    return ret;
  }

  /**
   * Get an asynchronous local lock with the specified name.
   *
   * <p>When the <code>block</code> is called, the lock is already acquired, it will be released when the
   * <code>Future<T></code> returned by the block completes.
   *
   * <p>When the <code>block</code> fails, the lock is released and the returned future is failed with the cause of the failure.
   *
   * <p>In general lock acquision is unordered, so that sequential attempts to acquire a lock, even from a single thread,
   * can happen in non-sequential order.
   * @param name the name of the lock
   * @param block 
   * @return the future returned by the <code>block</code>
   */
  public <T> io.reactivex.Single<T> rxWithLocalLock(java.lang.String name, java.util.function.Supplier<io.vertx.core.Future<T>> block) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.<T>withLocalLock(name, block).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.SharedData#withLocalLock} but specifying a timeout. If the lock is not obtained within the timeout
   * the returned future is failed.
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @param block the code block called after lock acquisition
   * @return the future returned by the <code>block</code>
   */
  public <T> io.vertx.core.Future<T> withLocalLock(java.lang.String name, long timeout, java.util.function.Supplier<io.vertx.core.Future<T>> block) { 
    io.vertx.core.Future<T> ret = delegate.withLocalLock(name, timeout, new Supplier<io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> get() {
        io.vertx.core.Future<T> ret = block.get();
        return ret.map(val -> val);
      }
    }).map(val -> (T) val);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.SharedData#withLocalLock} but specifying a timeout. If the lock is not obtained within the timeout
   * the returned future is failed.
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @param block the code block called after lock acquisition
   * @return the future returned by the <code>block</code>
   */
  public <T> io.reactivex.Single<T> rxWithLocalLock(java.lang.String name, long timeout, java.util.function.Supplier<io.vertx.core.Future<T>> block) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.<T>withLocalLock(name, timeout, block).onComplete($handler);
    });
  }

  /**
   * Get an asynchronous counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   * @return a future notified with the counter
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.shareddata.Counter> getCounter(java.lang.String name) { 
    io.vertx.core.Future<io.vertx.reactivex.core.shareddata.Counter> ret = delegate.getCounter(name).map(val -> io.vertx.reactivex.core.shareddata.Counter.newInstance((io.vertx.core.shareddata.Counter)val));
    return ret;
  }

  /**
   * Get an asynchronous counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   * @return a future notified with the counter
   */
  public io.reactivex.Single<io.vertx.reactivex.core.shareddata.Counter> rxGetCounter(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getCounter(name).onComplete($handler);
    });
  }

  /**
   * Get an asynchronous local counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   * @return a future notified with the counter
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.shareddata.Counter> getLocalCounter(java.lang.String name) { 
    io.vertx.core.Future<io.vertx.reactivex.core.shareddata.Counter> ret = delegate.getLocalCounter(name).map(val -> io.vertx.reactivex.core.shareddata.Counter.newInstance((io.vertx.core.shareddata.Counter)val));
    return ret;
  }

  /**
   * Get an asynchronous local counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   * @return a future notified with the counter
   */
  public io.reactivex.Single<io.vertx.reactivex.core.shareddata.Counter> rxGetLocalCounter(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getLocalCounter(name).onComplete($handler);
    });
  }

  /**
   * Return a <code>LocalMap</code> with the specific <code>name</code>.
   * @param name the name of the map
   * @return the map
   */
  public <K, V> io.vertx.reactivex.core.shareddata.LocalMap<K,V> getLocalMap(java.lang.String name) { 
    io.vertx.reactivex.core.shareddata.LocalMap<K,V> ret = io.vertx.reactivex.core.shareddata.LocalMap.newInstance((io.vertx.core.shareddata.LocalMap)delegate.getLocalMap(name), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  public static SharedData newInstance(io.vertx.core.shareddata.SharedData arg) {
    return arg != null ? new SharedData(arg) : null;
  }

}
