/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.shareddata;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An asynchronous counter that can be used to across the cluster to maintain a consistent count.
 * <p>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.Counter original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.shareddata.Counter.class)
public class Counter implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Counter that = (Counter) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Counter> __TYPE_ARG = new TypeArg<>(    obj -> new Counter((io.vertx.core.shareddata.Counter) obj),
    Counter::getDelegate
  );

  private final io.vertx.core.shareddata.Counter delegate;
  
  public Counter(io.vertx.core.shareddata.Counter delegate) {
    this.delegate = delegate;
  }

  public Counter(Object delegate) {
    this.delegate = (io.vertx.core.shareddata.Counter)delegate;
  }

  @Override 
  public io.vertx.core.shareddata.Counter getDelegate() {
    return delegate;
  }


  /**
   * Get the current value of the counter
   * @return a future notified with the value
   */
  public io.vertx.core.Future<java.lang.Long> get() { 
    io.vertx.core.Future<java.lang.Long> ret = delegate.get().map(val -> val);
    return ret;
  }

  /**
   * Get the current value of the counter
   * @return a future notified with the value
   */
  public io.reactivex.Single<java.lang.Long> rxGet() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.get().onComplete($handler);
    });
  }

  /**
   * Increment the counter atomically and return the new count
   * @return a future notified with the value
   */
  public io.vertx.core.Future<java.lang.Long> incrementAndGet() { 
    io.vertx.core.Future<java.lang.Long> ret = delegate.incrementAndGet().map(val -> val);
    return ret;
  }

  /**
   * Increment the counter atomically and return the new count
   * @return a future notified with the value
   */
  public io.reactivex.Single<java.lang.Long> rxIncrementAndGet() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.incrementAndGet().onComplete($handler);
    });
  }

  /**
   * Increment the counter atomically and return the value before the increment.
   * @return a future notified with the value
   */
  public io.vertx.core.Future<java.lang.Long> getAndIncrement() { 
    io.vertx.core.Future<java.lang.Long> ret = delegate.getAndIncrement().map(val -> val);
    return ret;
  }

  /**
   * Increment the counter atomically and return the value before the increment.
   * @return a future notified with the value
   */
  public io.reactivex.Single<java.lang.Long> rxGetAndIncrement() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getAndIncrement().onComplete($handler);
    });
  }

  /**
   * Decrement the counter atomically and return the new count
   * @return a future notified with the value
   */
  public io.vertx.core.Future<java.lang.Long> decrementAndGet() { 
    io.vertx.core.Future<java.lang.Long> ret = delegate.decrementAndGet().map(val -> val);
    return ret;
  }

  /**
   * Decrement the counter atomically and return the new count
   * @return a future notified with the value
   */
  public io.reactivex.Single<java.lang.Long> rxDecrementAndGet() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.decrementAndGet().onComplete($handler);
    });
  }

  /**
   * Add the value to the counter atomically and return the new count
   * @param value the value to add
   * @return a future notified with the value
   */
  public io.vertx.core.Future<java.lang.Long> addAndGet(long value) { 
    io.vertx.core.Future<java.lang.Long> ret = delegate.addAndGet(value).map(val -> val);
    return ret;
  }

  /**
   * Add the value to the counter atomically and return the new count
   * @param value the value to add
   * @return a future notified with the value
   */
  public io.reactivex.Single<java.lang.Long> rxAddAndGet(long value) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.addAndGet(value).onComplete($handler);
    });
  }

  /**
   * Add the value to the counter atomically and return the value before the add
   * @param value the value to add
   * @return a future notified with the value
   */
  public io.vertx.core.Future<java.lang.Long> getAndAdd(long value) { 
    io.vertx.core.Future<java.lang.Long> ret = delegate.getAndAdd(value).map(val -> val);
    return ret;
  }

  /**
   * Add the value to the counter atomically and return the value before the add
   * @param value the value to add
   * @return a future notified with the value
   */
  public io.reactivex.Single<java.lang.Long> rxGetAndAdd(long value) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getAndAdd(value).onComplete($handler);
    });
  }

  /**
   * Set the counter to the specified value only if the current value is the expectec value. This happens
   * atomically.
   * @param expected the expected value
   * @param value the new value
   * @return a future notified with <code>true</code> on success
   */
  public io.vertx.core.Future<java.lang.Boolean> compareAndSet(long expected, long value) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.compareAndSet(expected, value).map(val -> val);
    return ret;
  }

  /**
   * Set the counter to the specified value only if the current value is the expectec value. This happens
   * atomically.
   * @param expected the expected value
   * @param value the new value
   * @return a future notified with <code>true</code> on success
   */
  public io.reactivex.Single<java.lang.Boolean> rxCompareAndSet(long expected, long value) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.compareAndSet(expected, value).onComplete($handler);
    });
  }

  public static Counter newInstance(io.vertx.core.shareddata.Counter arg) {
    return arg != null ? new Counter(arg) : null;
  }

}
