/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.shareddata;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An asynchronous map.
 * <p>
 * {@link io.vertx.reactivex.core.shareddata.AsyncMap} does <em>not</em> allow <code>null</code> to be used as a key or value.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.AsyncMap original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.shareddata.AsyncMap.class)
public class AsyncMap<K,V> implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AsyncMap that = (AsyncMap) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AsyncMap> __TYPE_ARG = new TypeArg<>(    obj -> new AsyncMap((io.vertx.core.shareddata.AsyncMap) obj),
    AsyncMap::getDelegate
  );

  private final io.vertx.core.shareddata.AsyncMap<K,V> delegate;
  public final TypeArg<K> __typeArg_0;
  public final TypeArg<V> __typeArg_1;
  
  public AsyncMap(io.vertx.core.shareddata.AsyncMap delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public AsyncMap(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
    this.delegate = (io.vertx.core.shareddata.AsyncMap)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  @Override 
  public io.vertx.core.shareddata.AsyncMap getDelegate() {
    return delegate;
  }


  /**
   * Get a value from the map, asynchronously.
   * @param k the key
   * @return a future notified some time later with the async result.
   */
  public io.vertx.core.Future<V> get(K k) { 
    io.vertx.core.Future<V> ret = delegate.get(__typeArg_0.<K>unwrap(k)).map(val -> (V)__typeArg_1.wrap(val));
    return ret;
  }

  /**
   * Get a value from the map, asynchronously.
   * @param k the key
   * @return a future notified some time later with the async result.
   */
  public io.reactivex.Maybe<V> rxGet(K k) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.get(k).onComplete($handler);
    });
  }

  /**
   * Put a value in the map, asynchronously.
   * @param k the key
   * @param v the value
   * @return a future notified some time later with the async result.
   */
  public io.vertx.core.Future<java.lang.Void> put(K k, V v) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.put(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v)).map(val -> val);
    return ret;
  }

  /**
   * Put a value in the map, asynchronously.
   * @param k the key
   * @param v the value
   * @return a future notified some time later with the async result.
   */
  public io.reactivex.Completable rxPut(K k, V v) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.put(k, v).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.AsyncMap#put} but specifying a time to live for the entry. Entry will expire and get evicted after the
   * ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return a future notified some time later with the async result.
   */
  public io.vertx.core.Future<java.lang.Void> put(K k, V v, long ttl) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.put(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), ttl).map(val -> val);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.shareddata.AsyncMap#put} but specifying a time to live for the entry. Entry will expire and get evicted after the
   * ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return a future notified some time later with the async result.
   */
  public io.reactivex.Completable rxPut(K k, V v, long ttl) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.put(k, v, ttl).onComplete($handler);
    });
  }

  /**
   * Put the entry only if there is no entry with the key already present. If key already present then the existing
   * value will be returned to the handler, otherwise null.
   * @param k the key
   * @param v the value
   * @return a future notified some time later with the async result.
   */
  public io.vertx.core.Future<V> putIfAbsent(K k, V v) { 
    io.vertx.core.Future<V> ret = delegate.putIfAbsent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v)).map(val -> (V)__typeArg_1.wrap(val));
    return ret;
  }

  /**
   * Put the entry only if there is no entry with the key already present. If key already present then the existing
   * value will be returned to the handler, otherwise null.
   * @param k the key
   * @param v the value
   * @return a future notified some time later with the async result.
   */
  public io.reactivex.Maybe<V> rxPutIfAbsent(K k, V v) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.putIfAbsent(k, v).onComplete($handler);
    });
  }

  /**
   * Link {@link io.vertx.reactivex.core.shareddata.AsyncMap#putIfAbsent} but specifying a time to live for the entry. Entry will expire and get evicted
   * after the ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return a future notified some time later with the async result.
   */
  public io.vertx.core.Future<V> putIfAbsent(K k, V v, long ttl) { 
    io.vertx.core.Future<V> ret = delegate.putIfAbsent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), ttl).map(val -> (V)__typeArg_1.wrap(val));
    return ret;
  }

  /**
   * Link {@link io.vertx.reactivex.core.shareddata.AsyncMap#putIfAbsent} but specifying a time to live for the entry. Entry will expire and get evicted
   * after the ttl.
   * @param k the key
   * @param v the value
   * @param ttl The time to live (in ms) for the entry
   * @return a future notified some time later with the async result.
   */
  public io.reactivex.Maybe<V> rxPutIfAbsent(K k, V v, long ttl) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.putIfAbsent(k, v, ttl).onComplete($handler);
    });
  }

  /**
   * Remove a value from the map, asynchronously.
   * @param k the key
   * @return a future notified some time later with the async result.
   */
  public io.vertx.core.Future<V> remove(K k) { 
    io.vertx.core.Future<V> ret = delegate.remove(__typeArg_0.<K>unwrap(k)).map(val -> (V)__typeArg_1.wrap(val));
    return ret;
  }

  /**
   * Remove a value from the map, asynchronously.
   * @param k the key
   * @return a future notified some time later with the async result.
   */
  public io.reactivex.Maybe<V> rxRemove(K k) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.remove(k).onComplete($handler);
    });
  }

  /**
   * Remove a value from the map, only if entry already exists with same value.
   * @param k the key
   * @param v the value
   * @return a future notified some time later with the async result.
   */
  public io.vertx.core.Future<java.lang.Boolean> removeIfPresent(K k, V v) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.removeIfPresent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v)).map(val -> val);
    return ret;
  }

  /**
   * Remove a value from the map, only if entry already exists with same value.
   * @param k the key
   * @param v the value
   * @return a future notified some time later with the async result.
   */
  public io.reactivex.Single<java.lang.Boolean> rxRemoveIfPresent(K k, V v) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.removeIfPresent(k, v).onComplete($handler);
    });
  }

  /**
   * Replace the entry only if it is currently mapped to some value
   * @param k the key
   * @param v the new value
   * @return a future notified some time later with the async result.
   */
  public io.vertx.core.Future<V> replace(K k, V v) { 
    io.vertx.core.Future<V> ret = delegate.replace(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v)).map(val -> (V)__typeArg_1.wrap(val));
    return ret;
  }

  /**
   * Replace the entry only if it is currently mapped to some value
   * @param k the key
   * @param v the new value
   * @return a future notified some time later with the async result.
   */
  public io.reactivex.Maybe<V> rxReplace(K k, V v) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.replace(k, v).onComplete($handler);
    });
  }

  /**
   * Replace the entry only if it is currently mapped to some value
   * @param k the key
   * @param v the new value
   * @param ttl The time to live (in ms) for the entry
   * @return a future notified some time later with the previous value
   */
  public io.vertx.core.Future<V> replace(K k, V v, long ttl) { 
    io.vertx.core.Future<V> ret = delegate.replace(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(v), ttl).map(val -> (V)__typeArg_1.wrap(val));
    return ret;
  }

  /**
   * Replace the entry only if it is currently mapped to some value
   * @param k the key
   * @param v the new value
   * @param ttl The time to live (in ms) for the entry
   * @return a future notified some time later with the previous value
   */
  public io.reactivex.Maybe<V> rxReplace(K k, V v, long ttl) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.replace(k, v, ttl).onComplete($handler);
    });
  }

  /**
   * Replace the entry only if it is currently mapped to a specific value
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @return a future notified some time later with the async result.
   */
  public io.vertx.core.Future<java.lang.Boolean> replaceIfPresent(K k, V oldValue, V newValue) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.replaceIfPresent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(oldValue), __typeArg_1.<V>unwrap(newValue)).map(val -> val);
    return ret;
  }

  /**
   * Replace the entry only if it is currently mapped to a specific value
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @return a future notified some time later with the async result.
   */
  public io.reactivex.Single<java.lang.Boolean> rxReplaceIfPresent(K k, V oldValue, V newValue) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.replaceIfPresent(k, oldValue, newValue).onComplete($handler);
    });
  }

  /**
   * Replace the entry only if it is currently mapped to a specific value
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @param ttl The time to live (in ms) for the entry
   * @return a future notified some time later with the async result.
   */
  public io.vertx.core.Future<java.lang.Boolean> replaceIfPresent(K k, V oldValue, V newValue, long ttl) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.replaceIfPresent(__typeArg_0.<K>unwrap(k), __typeArg_1.<V>unwrap(oldValue), __typeArg_1.<V>unwrap(newValue), ttl).map(val -> val);
    return ret;
  }

  /**
   * Replace the entry only if it is currently mapped to a specific value
   * @param k the key
   * @param oldValue the existing value
   * @param newValue the new value
   * @param ttl The time to live (in ms) for the entry
   * @return a future notified some time later with the async result.
   */
  public io.reactivex.Single<java.lang.Boolean> rxReplaceIfPresent(K k, V oldValue, V newValue, long ttl) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.replaceIfPresent(k, oldValue, newValue, ttl).onComplete($handler);
    });
  }

  /**
   * Clear all entries in the map
   * @return a future notified some time later with the async result.
   */
  public io.vertx.core.Future<java.lang.Void> clear() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.clear().map(val -> val);
    return ret;
  }

  /**
   * Clear all entries in the map
   * @return a future notified some time later with the async result.
   */
  public io.reactivex.Completable rxClear() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.clear().onComplete($handler);
    });
  }

  /**
   * Provide the number of entries in the map
   * @return a future notified some time later with the async result.
   */
  public io.vertx.core.Future<java.lang.Integer> size() { 
    io.vertx.core.Future<java.lang.Integer> ret = delegate.size().map(val -> val);
    return ret;
  }

  /**
   * Provide the number of entries in the map
   * @return a future notified some time later with the async result.
   */
  public io.reactivex.Single<java.lang.Integer> rxSize() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.size().onComplete($handler);
    });
  }

  /**
   * Get the keys of the map, asynchronously.
   * <p>
   * Use this method with care as the map may contain a large number of keys,
   * which may not fit entirely in memory of a single node.
   * In this case, the invocation will result in an {@link java.lang.OutOfMemoryError}.
   * @return a future notified some time later with the async result.
   */
  public io.vertx.core.Future<java.util.Set<K>> keys() { 
    io.vertx.core.Future<java.util.Set<K>> ret = delegate.keys().map(val -> val.stream().map(elt -> (K)__typeArg_0.wrap(elt)).collect(Collectors.toSet()));
    return ret;
  }

  /**
   * Get the keys of the map, asynchronously.
   * <p>
   * Use this method with care as the map may contain a large number of keys,
   * which may not fit entirely in memory of a single node.
   * In this case, the invocation will result in an {@link java.lang.OutOfMemoryError}.
   * @return a future notified some time later with the async result.
   */
  public io.reactivex.Single<java.util.Set<K>> rxKeys() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.keys().onComplete($handler);
    });
  }

  /**
   * Get the values of the map, asynchronously.
   * <p>
   * Use this method with care as the map may contain a large number of values,
   * which may not fit entirely in memory of a single node.
   * In this case, the invocation will result in an {@link java.lang.OutOfMemoryError}.
   * @return a future notified some time later with the async result.
   */
  public io.vertx.core.Future<java.util.List<V>> values() { 
    io.vertx.core.Future<java.util.List<V>> ret = delegate.values().map(val -> val.stream().map(elt -> (V)__typeArg_1.wrap(elt)).collect(Collectors.toList()));
    return ret;
  }

  /**
   * Get the values of the map, asynchronously.
   * <p>
   * Use this method with care as the map may contain a large number of values,
   * which may not fit entirely in memory of a single node.
   * In this case, the invocation will result in an {@link java.lang.OutOfMemoryError}.
   * @return a future notified some time later with the async result.
   */
  public io.reactivex.Single<java.util.List<V>> rxValues() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.values().onComplete($handler);
    });
  }

  public static <K,V> AsyncMap<K,V> newInstance(io.vertx.core.shareddata.AsyncMap arg) {
    return arg != null ? new AsyncMap<K,V>(arg) : null;
  }

  public static <K,V> AsyncMap<K,V> newInstance(io.vertx.core.shareddata.AsyncMap arg, TypeArg<K> __typeArg_K, TypeArg<V> __typeArg_V) {
    return arg != null ? new AsyncMap<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
