/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.parsetools;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A parser class which allows to incrementally parse json elements and emit json parse events instead of parsing a json
 * element fully. This parser is convenient for parsing large json structures.
 * <p/>
 * The parser also parses concatenated json streams or line delimited json streams.
 * <p/>
 * The parser can also parse entire object or array when it is convenient, for instance a very large array
 * of small objects can be parsed efficiently by handling array <i>start</i>/<i>end</i> and <i>object</i>
 * events.
 * <p/>
 * Whenever the parser fails to parse or process the stream, the {@link io.vertx.reactivex.core.parsetools.JsonParser#exceptionHandler} is called with
 * the cause of the failure and the current handling stops. After such event, the parser should not handle data
 * anymore.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.parsetools.JsonParser original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.parsetools.JsonParser.class)
public class JsonParser implements RxDelegate, io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.parsetools.JsonEvent>, Handler<io.vertx.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JsonParser that = (JsonParser) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<JsonParser> __TYPE_ARG = new TypeArg<>(    obj -> new JsonParser((io.vertx.core.parsetools.JsonParser) obj),
    JsonParser::getDelegate
  );

  private final io.vertx.core.parsetools.JsonParser delegate;
  
  public JsonParser(io.vertx.core.parsetools.JsonParser delegate) {
    this.delegate = delegate;
  }

  public JsonParser(Object delegate) {
    this.delegate = (io.vertx.core.parsetools.JsonParser)delegate;
  }

  @Override 
  public io.vertx.core.parsetools.JsonParser getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<io.vertx.core.parsetools.JsonEvent> observable;
  private io.reactivex.Flowable<io.vertx.core.parsetools.JsonEvent> flowable;

  public synchronized io.reactivex.Observable<io.vertx.core.parsetools.JsonEvent> toObservable() {
    if (observable == null) {
      observable = ObservableHelper.toObservable(this.getDelegate());
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<io.vertx.core.parsetools.JsonEvent> toFlowable() {
    if (flowable == null) {
      flowable = FlowableHelper.toFlowable(this.getDelegate());
    }
    return flowable;
  }


  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.core.buffer.Buffer event) { 
    delegate.handle(event);
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<io.vertx.core.parsetools.JsonEvent> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.core.parsetools.JsonEvent> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TypeArg.unknown());
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.vertx.core.Future<java.lang.Void> pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.parsetools.JsonEvent> dst) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.pipeTo(dst.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.reactivex.Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.parsetools.JsonEvent> dst) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.pipeTo(dst).onComplete($handler);
    });
  }

  /**
   * Create a new <code>JsonParser</code> instance.
   * @return 
   */
  public static io.vertx.reactivex.core.parsetools.JsonParser newParser() { 
    io.vertx.reactivex.core.parsetools.JsonParser ret = io.vertx.reactivex.core.parsetools.JsonParser.newInstance((io.vertx.core.parsetools.JsonParser)io.vertx.core.parsetools.JsonParser.newParser());
    return ret;
  }

  /**
   * Create a new <code>JsonParser</code> instance.
   * @param stream 
   * @return 
   */
  public static io.vertx.reactivex.core.parsetools.JsonParser newParser(io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.buffer.Buffer> stream) { 
    io.vertx.reactivex.core.parsetools.JsonParser ret = io.vertx.reactivex.core.parsetools.JsonParser.newInstance((io.vertx.core.parsetools.JsonParser)io.vertx.core.parsetools.JsonParser.newParser(stream.getDelegate()));
    return ret;
  }

  /**
   * Create a new <code>JsonParser</code> instance.
   * @param stream 
   * @return 
   */
  public static io.vertx.reactivex.core.parsetools.JsonParser newParser(io.reactivex.Flowable<io.vertx.core.buffer.Buffer> stream) { 
    io.vertx.reactivex.core.parsetools.JsonParser ret = io.vertx.reactivex.core.parsetools.JsonParser.newInstance((io.vertx.core.parsetools.JsonParser)io.vertx.core.parsetools.JsonParser.newParser(io.vertx.reactivex.impl.ReadStreamSubscriber.asReadStream(stream, obj -> obj).resume()));
    return ret;
  }

  /**
   * Handle a <code>Buffer</code>, pretty much like calling {@link io.vertx.core.Handler}.
   * @param buffer 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.parsetools.JsonParser write(io.vertx.core.buffer.Buffer buffer) { 
    delegate.write(buffer);
    return this;
  }

  /**
   * End the stream, this must be called after all the json stream has been processed.
   */
  public void end() { 
    delegate.end();
  }

  /**
   * Flip the parser to emit a stream of events for each new json object.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.parsetools.JsonParser objectEventMode() { 
    delegate.objectEventMode();
    return this;
  }

  /**
   * Flip the parser to emit a single value event for each new json object.
   * </p>
   * Json object currently streamed won't be affected.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.parsetools.JsonParser objectValueMode() { 
    delegate.objectValueMode();
    return this;
  }

  /**
   * Flip the parser to emit a stream of events for each new json array.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.parsetools.JsonParser arrayEventMode() { 
    delegate.arrayEventMode();
    return this;
  }

  /**
   * Flip the parser to emit a single value event for each new json array.
   * </p>
   * Json array currently streamed won't be affected.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.parsetools.JsonParser arrayValueMode() { 
    delegate.arrayValueMode();
    return this;
  }

  public io.vertx.reactivex.core.parsetools.JsonParser pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.core.parsetools.JsonParser resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.core.parsetools.JsonParser fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.reactivex.core.parsetools.JsonParser endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.reactivex.core.parsetools.JsonParser handler(io.vertx.core.Handler<io.vertx.core.parsetools.JsonEvent> handler) { 
    delegate.handler(handler);
    return this;
  }

  public io.vertx.reactivex.core.parsetools.JsonParser exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public static JsonParser newInstance(io.vertx.core.parsetools.JsonParser arg) {
    return arg != null ? new JsonParser(arg) : null;
  }

}
