/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.net.endpoint;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Request interaction with an endpoint, mostly callbacks to gather statistics.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.endpoint.ServerInteraction original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.net.endpoint.ServerInteraction.class)
public class ServerInteraction implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServerInteraction that = (ServerInteraction) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ServerInteraction> __TYPE_ARG = new TypeArg<>(    obj -> new ServerInteraction((io.vertx.core.net.endpoint.ServerInteraction) obj),
    ServerInteraction::getDelegate
  );

  private final io.vertx.core.net.endpoint.ServerInteraction delegate;
  
  public ServerInteraction(io.vertx.core.net.endpoint.ServerInteraction delegate) {
    this.delegate = delegate;
  }

  public ServerInteraction(Object delegate) {
    this.delegate = (io.vertx.core.net.endpoint.ServerInteraction)delegate;
  }

  @Override 
  public io.vertx.core.net.endpoint.ServerInteraction getDelegate() {
    return delegate;
  }

  /**
   * Report a failure.
   * @param failure the failure to report
   */
  public void reportFailure(java.lang.Throwable failure) { 
    delegate.reportFailure(failure);
  }

  /**
   * The request has begun.
   */
  public void reportRequestBegin() { 
    delegate.reportRequestBegin();
  }

  /**
   * The request has ended.
   */
  public void reportRequestEnd() { 
    delegate.reportRequestEnd();
  }

  /**
   * The response has begun.
   */
  public void reportResponseBegin() { 
    delegate.reportResponseBegin();
  }

  /**
   * The request has ended.
   */
  public void reportResponseEnd() { 
    delegate.reportResponseEnd();
  }

  public static ServerInteraction newInstance(io.vertx.core.net.endpoint.ServerInteraction arg) {
    return arg != null ? new ServerInteraction(arg) : null;
  }

}
