/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.net.endpoint;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A physical server of an endpoint.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.endpoint.ServerEndpoint original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.net.endpoint.ServerEndpoint.class)
public class ServerEndpoint implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServerEndpoint that = (ServerEndpoint) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ServerEndpoint> __TYPE_ARG = new TypeArg<>(    obj -> new ServerEndpoint((io.vertx.core.net.endpoint.ServerEndpoint) obj),
    ServerEndpoint::getDelegate
  );

  private final io.vertx.core.net.endpoint.ServerEndpoint delegate;
  
  public ServerEndpoint(io.vertx.core.net.endpoint.ServerEndpoint delegate) {
    this.delegate = delegate;
  }

  public ServerEndpoint(Object delegate) {
    this.delegate = (io.vertx.core.net.endpoint.ServerEndpoint)delegate;
  }

  @Override 
  public io.vertx.core.net.endpoint.ServerEndpoint getDelegate() {
    return delegate;
  }

  /**
   * @return the node key for hashing strategies
   */
  public java.lang.String key() { 
    java.lang.String ret = delegate.key();
    return ret;
  }

  /**
   * @return the server socket address
   */
  public io.vertx.core.net.SocketAddress address() { 
    io.vertx.core.net.SocketAddress ret = delegate.address();
    return ret;
  }

  /**
   * Initiate a request/response interaction with the endpoint represented by this node, the returned interaction gathers statistics.
   * @return the request
   */
  public io.vertx.reactivex.core.net.endpoint.ServerInteraction newInteraction() { 
    io.vertx.reactivex.core.net.endpoint.ServerInteraction ret = io.vertx.reactivex.core.net.endpoint.ServerInteraction.newInstance((io.vertx.core.net.endpoint.ServerInteraction)delegate.newInteraction());
    return ret;
  }

  public static ServerEndpoint newInstance(io.vertx.core.net.endpoint.ServerEndpoint arg) {
    return arg != null ? new ServerEndpoint(arg) : null;
  }

}
