/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.net.endpoint;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *  A resolver for endpoints.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.endpoint.EndpointResolver original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.net.endpoint.EndpointResolver.class)
public class EndpointResolver implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EndpointResolver that = (EndpointResolver) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<EndpointResolver> __TYPE_ARG = new TypeArg<>(    obj -> new EndpointResolver((io.vertx.core.net.endpoint.EndpointResolver) obj),
    EndpointResolver::getDelegate
  );

  private final io.vertx.core.net.endpoint.EndpointResolver delegate;
  
  public EndpointResolver(io.vertx.core.net.endpoint.EndpointResolver delegate) {
    this.delegate = delegate;
  }

  public EndpointResolver(Object delegate) {
    this.delegate = (io.vertx.core.net.endpoint.EndpointResolver)delegate;
  }

  @Override 
  public io.vertx.core.net.endpoint.EndpointResolver getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.core.net.endpoint.Endpoint> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.net.endpoint.Endpoint>(o1 -> io.vertx.reactivex.core.net.endpoint.Endpoint.newInstance((io.vertx.core.net.endpoint.Endpoint)o1), o1 -> o1.getDelegate());

  /**
   * Resolver an endpoint for the specified <code>address</code>
   * @param address the address to lookup
   * @return the endpoint lookup result
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.net.endpoint.Endpoint> resolveEndpoint(io.vertx.core.net.Address address) { 
    io.vertx.core.Future<io.vertx.reactivex.core.net.endpoint.Endpoint> ret = delegate.resolveEndpoint(address).map(val -> io.vertx.reactivex.core.net.endpoint.Endpoint.newInstance((io.vertx.core.net.endpoint.Endpoint)val));
    return ret;
  }

  /**
   * Resolver an endpoint for the specified <code>address</code>
   * @param address the address to lookup
   * @return the endpoint lookup result
   */
  public io.reactivex.Single<io.vertx.reactivex.core.net.endpoint.Endpoint> rxResolveEndpoint(io.vertx.core.net.Address address) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.resolveEndpoint(address).onComplete($handler);
    });
  }

  public static EndpointResolver newInstance(io.vertx.core.net.endpoint.EndpointResolver arg) {
    return arg != null ? new EndpointResolver(arg) : null;
  }

}
