/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.net.endpoint;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.core.net.endpoint.Endpoint.class)
public class Endpoint implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Endpoint that = (Endpoint) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Endpoint> __TYPE_ARG = new TypeArg<>(    obj -> new Endpoint((io.vertx.core.net.endpoint.Endpoint) obj),
    Endpoint::getDelegate
  );

  private final io.vertx.core.net.endpoint.Endpoint delegate;
  
  public Endpoint(io.vertx.core.net.endpoint.Endpoint delegate) {
    this.delegate = delegate;
  }

  public Endpoint(Object delegate) {
    this.delegate = (io.vertx.core.net.endpoint.Endpoint)delegate;
  }

  @Override 
  public io.vertx.core.net.endpoint.Endpoint getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.core.net.endpoint.ServerEndpoint> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.net.endpoint.ServerEndpoint>(o1 -> io.vertx.reactivex.core.net.endpoint.ServerEndpoint.newInstance((io.vertx.core.net.endpoint.ServerEndpoint)o1), o1 -> o1.getDelegate());

  /**
   * The servers capable of serving requests for this endpoint.
   * @return 
   */
  public java.util.List<io.vertx.reactivex.core.net.endpoint.ServerEndpoint> servers() { 
    java.util.List<io.vertx.reactivex.core.net.endpoint.ServerEndpoint> ret = delegate.servers().stream().map(elt -> io.vertx.reactivex.core.net.endpoint.ServerEndpoint.newInstance((io.vertx.core.net.endpoint.ServerEndpoint)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * Select a server.
   * @return the selected server
   */
  public io.vertx.reactivex.core.net.endpoint.ServerEndpoint selectServer() { 
    io.vertx.reactivex.core.net.endpoint.ServerEndpoint ret = io.vertx.reactivex.core.net.endpoint.ServerEndpoint.newInstance((io.vertx.core.net.endpoint.ServerEndpoint)delegate.selectServer());
    return ret;
  }

  /**
   * Select a node, using a routing <code>key</code>
   * @param key the routing key
   * @return the selected server
   */
  public io.vertx.reactivex.core.net.endpoint.ServerEndpoint selectServer(java.lang.String key) { 
    io.vertx.reactivex.core.net.endpoint.ServerEndpoint ret = io.vertx.reactivex.core.net.endpoint.ServerEndpoint.newInstance((io.vertx.core.net.endpoint.ServerEndpoint)delegate.selectServer(key));
    return ret;
  }

  public static Endpoint newInstance(io.vertx.core.net.endpoint.Endpoint arg) {
    return arg != null ? new Endpoint(arg) : null;
  }

}
