/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.net;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a socket-like interface to a TCP connection on either the
 * client or the server side.
 * <p>
 * Instances of this class are created on the client side by an {@link io.vertx.reactivex.core.net.NetClient}
 * when a connection to a server is made, or on the server side by a {@link io.vertx.reactivex.core.net.NetServer}
 * when a server accepts a connection.
 * <p>
 * It implements both  and  so it can be used with
 * {@link io.vertx.reactivex.core.streams.Pipe} to pipe data with flow control.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetSocket original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.net.NetSocket.class)
public class NetSocket implements RxDelegate, io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.buffer.Buffer>, io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetSocket that = (NetSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<NetSocket> __TYPE_ARG = new TypeArg<>(    obj -> new NetSocket((io.vertx.core.net.NetSocket) obj),
    NetSocket::getDelegate
  );

  private final io.vertx.core.net.NetSocket delegate;
  
  public NetSocket(io.vertx.core.net.NetSocket delegate) {
    this.delegate = delegate;
  }

  public NetSocket(Object delegate) {
    this.delegate = (io.vertx.core.net.NetSocket)delegate;
  }

  @Override 
  public io.vertx.core.net.NetSocket getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<io.vertx.core.buffer.Buffer> observable;
  private io.reactivex.Flowable<io.vertx.core.buffer.Buffer> flowable;

  public synchronized io.reactivex.Observable<io.vertx.core.buffer.Buffer> toObservable() {
    if (observable == null) {
      observable = ObservableHelper.toObservable(this.getDelegate());
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<io.vertx.core.buffer.Buffer> toFlowable() {
    if (flowable == null) {
      flowable = FlowableHelper.toFlowable(this.getDelegate());
    }
    return flowable;
  }

  private WriteStreamObserver<io.vertx.core.buffer.Buffer> observer;
  private WriteStreamSubscriber<io.vertx.core.buffer.Buffer> subscriber;

  public synchronized WriteStreamObserver<io.vertx.core.buffer.Buffer> toObserver() {
    if (observer == null) {
      observer = RxHelper.toObserver(getDelegate());
    }
    return observer;
  }

  public synchronized WriteStreamSubscriber<io.vertx.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      subscriber = RxHelper.toSubscriber(getDelegate());
    }
    return subscriber;
  }


  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<io.vertx.core.buffer.Buffer> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TypeArg.unknown());
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.vertx.core.Future<java.lang.Void> pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.buffer.Buffer> dst) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.pipeTo(dst.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.reactivex.Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.buffer.Buffer> dst) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.pipeTo(dst).onComplete($handler);
    });
  }

  /**
   * Write some data to the stream.
   *
   * <p> The data is usually put on an internal write queue, and the write actually happens
   * asynchronously. To avoid running out of memory by putting too much on the write queue,
   * check the {@link io.vertx.reactivex.core.streams.WriteStream#writeQueueFull} method before writing. This is done automatically if
   * using a .
   *
   * <p> When the <code>data</code> is moved from the queue to the actual medium, the returned
   *  will be completed with the write result, e.g the future is succeeded
   * when a server HTTP response buffer is written to the socket and failed if the remote
   * client has closed the socket while the data was still pending for write.
   * @param data the data to write
   * @return a future completed with the write result
   */
  public io.vertx.core.Future<java.lang.Void> write(io.vertx.core.buffer.Buffer data) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.write(data).map(val -> val);
    return ret;
  }

  /**
   * Write some data to the stream.
   *
   * <p> The data is usually put on an internal write queue, and the write actually happens
   * asynchronously. To avoid running out of memory by putting too much on the write queue,
   * check the {@link io.vertx.reactivex.core.streams.WriteStream#writeQueueFull} method before writing. This is done automatically if
   * using a .
   *
   * <p> When the <code>data</code> is moved from the queue to the actual medium, the returned
   *  will be completed with the write result, e.g the future is succeeded
   * when a server HTTP response buffer is written to the socket and failed if the remote
   * client has closed the socket while the data was still pending for write.
   * @param data the data to write
   * @return a future completed with the write result
   */
  public io.reactivex.Completable rxWrite(io.vertx.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.write(data).onComplete($handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.net.NetSocket#end} but writes some data to the stream before ending.
   * @param data the data to write
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> end(io.vertx.core.buffer.Buffer data) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.end(data).map(val -> val);
    return ret;
  }

  /**
   * Same as {@link io.vertx.reactivex.core.net.NetSocket#end} but writes some data to the stream before ending.
   * @param data the data to write
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxEnd(io.vertx.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.end(data).onComplete($handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.reactivex.core.net.NetSocket#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  public io.vertx.reactivex.core.net.NetSocket exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.core.net.NetSocket handler(io.vertx.core.Handler<io.vertx.core.buffer.Buffer> handler) { 
    delegate.handler(handler);
    return this;
  }

  public io.vertx.reactivex.core.net.NetSocket pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.core.net.NetSocket resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.core.net.NetSocket fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * 
   * <p>
   * This handler might be called after the close handler when the socket is paused and there are still
   * buffers to deliver.
   * @param endHandler 
   * @return 
   */
  public io.vertx.reactivex.core.net.NetSocket endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.reactivex.core.net.NetSocket setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public io.vertx.reactivex.core.net.NetSocket drainHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * When a <code>NetSocket</code> is created, it may register an event handler with the event bus, the ID of that
   * handler is given by <code>writeHandlerID</code>.
   * <p>
   * By default, no handler is registered, the feature must be enabled via {@link io.vertx.core.net.NetClientOptions} or {@link io.vertx.core.net.NetServerOptions}.
   * <p>
   * Given this ID, a different event loop can send a buffer to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other connections which are owned by different event loops.
   * @return the write handler ID
   */
  public java.lang.String writeHandlerID() { 
    java.lang.String ret = delegate.writeHandlerID();
    return ret;
  }

  /**
   * Write a {@link java.lang.String} to the connection, encoded in UTF-8.
   * @param str the string to write
   * @return a future result of the write
   */
  public io.vertx.core.Future<java.lang.Void> write(java.lang.String str) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.write(str).map(val -> val);
    return ret;
  }

  /**
   * Write a {@link java.lang.String} to the connection, encoded in UTF-8.
   * @param str the string to write
   * @return a future result of the write
   */
  public io.reactivex.Completable rxWrite(java.lang.String str) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.write(str).onComplete($handler);
    });
  }

  /**
   * Write a {@link java.lang.String} to the connection, encoded using the encoding <code>enc</code>.
   * @param str the string to write
   * @param enc the encoding to use
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> write(java.lang.String str, java.lang.String enc) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.write(str, enc).map(val -> val);
    return ret;
  }

  /**
   * Write a {@link java.lang.String} to the connection, encoded using the encoding <code>enc</code>.
   * @param str the string to write
   * @param enc the encoding to use
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxWrite(java.lang.String str, java.lang.String enc) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.write(str, enc).onComplete($handler);
    });
  }

  /**
   * Tell the operating system to stream a file as specified by <code>filename</code> directly from disk to the outgoing connection,
   * bypassing userspace altogether (where supported by the underlying operating system. This is a very efficient way to stream files.
   * @param filename file name of the file to send
   * @return a future result of the send operation
   */
  public io.vertx.core.Future<java.lang.Void> sendFile(java.lang.String filename) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.sendFile(filename).map(val -> val);
    return ret;
  }

  /**
   * Tell the operating system to stream a file as specified by <code>filename</code> directly from disk to the outgoing connection,
   * bypassing userspace altogether (where supported by the underlying operating system. This is a very efficient way to stream files.
   * @param filename file name of the file to send
   * @return a future result of the send operation
   */
  public io.reactivex.Completable rxSendFile(java.lang.String filename) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.sendFile(filename).onComplete($handler);
    });
  }

  /**
   * Tell the operating system to stream a file as specified by <code>filename</code> directly from disk to the outgoing connection,
   * bypassing userspace altogether (where supported by the underlying operating system. This is a very efficient way to stream files.
   * @param filename file name of the file to send
   * @param offset offset
   * @return a future result of the send operation
   */
  public io.vertx.core.Future<java.lang.Void> sendFile(java.lang.String filename, long offset) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.sendFile(filename, offset).map(val -> val);
    return ret;
  }

  /**
   * Tell the operating system to stream a file as specified by <code>filename</code> directly from disk to the outgoing connection,
   * bypassing userspace altogether (where supported by the underlying operating system. This is a very efficient way to stream files.
   * @param filename file name of the file to send
   * @param offset offset
   * @return a future result of the send operation
   */
  public io.reactivex.Completable rxSendFile(java.lang.String filename, long offset) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.sendFile(filename, offset).onComplete($handler);
    });
  }

  /**
   * Tell the operating system to stream a file as specified by <code>filename</code> directly from disk to the outgoing connection,
   * bypassing userspace altogether (where supported by the underlying operating system. This is a very efficient way to stream files.
   * @param filename file name of the file to send
   * @param offset offset
   * @param length length
   * @return a future result of the send operation
   */
  public io.vertx.core.Future<java.lang.Void> sendFile(java.lang.String filename, long offset, long length) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.sendFile(filename, offset, length).map(val -> val);
    return ret;
  }

  /**
   * Tell the operating system to stream a file as specified by <code>filename</code> directly from disk to the outgoing connection,
   * bypassing userspace altogether (where supported by the underlying operating system. This is a very efficient way to stream files.
   * @param filename file name of the file to send
   * @param offset offset
   * @param length length
   * @return a future result of the send operation
   */
  public io.reactivex.Completable rxSendFile(java.lang.String filename, long offset, long length) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.sendFile(filename, offset, length).onComplete($handler);
    });
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket). If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the actual connecting client.
   */
  public io.vertx.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.core.net.SocketAddress ret = delegate.remoteAddress();
    cached_0 = ret;
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetSocket#remoteAddress} but returns the proxy remote address when <code>real</code> is <code>true</code>
   * @param real 
   * @return 
   */
  public io.vertx.core.net.SocketAddress remoteAddress(boolean real) { 
    io.vertx.core.net.SocketAddress ret = delegate.remoteAddress(real);
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket) If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the proxy.
   */
  public io.vertx.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.core.net.SocketAddress ret = delegate.localAddress();
    cached_1 = ret;
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetSocket#localAddress} ()} but returns the server local address when <code>real</code> is <code>true</code>
   * @param real 
   * @return 
   */
  public io.vertx.core.net.SocketAddress localAddress(boolean real) { 
    io.vertx.core.net.SocketAddress ret = delegate.localAddress(real);
    return ret;
  }

  /**
   * Calls {@link io.vertx.reactivex.core.net.NetSocket#close}
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> end() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.end().map(val -> val);
    return ret;
  }

  /**
   * Calls {@link io.vertx.reactivex.core.net.NetSocket#close}
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxEnd() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.end().onComplete($handler);
    });
  }

  /**
   * Close the socket
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Close the socket
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * Set a <code>handler</code> notified when the socket is closed
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetSocket closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Set a <code>handler</code> notified when the socket is shutdown: the client or server will close the connection
   * within a certain amount of time. This gives the opportunity to the <code>handler</code> to close the socket gracefully before
   * the socket is closed.
   * @param handler the handler notified
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetSocket shutdownHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.shutdownHandler(handler);
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetSocket#upgradeToSsl} with the default SSL options, without indicating a server name,
   * without an upgrade message.
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> upgradeToSsl() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.upgradeToSsl().map(val -> val);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetSocket#upgradeToSsl} with the default SSL options, without indicating a server name,
   * without an upgrade message.
   * @return 
   */
  public io.reactivex.Completable rxUpgradeToSsl() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.upgradeToSsl().onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetSocket#upgradeToSsl} with the default SSL options and without indicating a server name.
   * @param msg 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> upgradeToSsl(io.vertx.core.buffer.Buffer msg) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.upgradeToSsl(msg).map(val -> val);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetSocket#upgradeToSsl} with the default SSL options and without indicating a server name.
   * @param msg 
   * @return 
   */
  public io.reactivex.Completable rxUpgradeToSsl(io.vertx.core.buffer.Buffer msg) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.upgradeToSsl(msg).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetSocket#upgradeToSsl} with the default SSL options and without an update message.
   * @param serverName 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> upgradeToSsl(java.lang.String serverName) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.upgradeToSsl(serverName).map(val -> val);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetSocket#upgradeToSsl} with the default SSL options and without an update message.
   * @param serverName 
   * @return 
   */
  public io.reactivex.Completable rxUpgradeToSsl(java.lang.String serverName) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.upgradeToSsl(serverName).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetSocket#upgradeToSsl} with the default SSL options.
   * @param serverName 
   * @param msg 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> upgradeToSsl(java.lang.String serverName, io.vertx.core.buffer.Buffer msg) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.upgradeToSsl(serverName, msg).map(val -> val);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetSocket#upgradeToSsl} with the default SSL options.
   * @param serverName 
   * @param msg 
   * @return 
   */
  public io.reactivex.Completable rxUpgradeToSsl(java.lang.String serverName, io.vertx.core.buffer.Buffer msg) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.upgradeToSsl(serverName, msg).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetSocket#upgradeToSsl} without an upgrade message.
   * @param sslOptions 
   * @param serverName 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> upgradeToSsl(io.vertx.core.net.SSLOptions sslOptions, java.lang.String serverName) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.upgradeToSsl(sslOptions, serverName).map(val -> val);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetSocket#upgradeToSsl} without an upgrade message.
   * @param sslOptions 
   * @param serverName 
   * @return 
   */
  public io.reactivex.Completable rxUpgradeToSsl(io.vertx.core.net.SSLOptions sslOptions, java.lang.String serverName) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.upgradeToSsl(sslOptions, serverName).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetSocket#upgradeToSsl} without indicating a server name
   * @param sslOptions 
   * @param msg 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> upgradeToSsl(io.vertx.core.net.SSLOptions sslOptions, io.vertx.core.buffer.Buffer msg) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.upgradeToSsl(sslOptions, msg).map(val -> val);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.net.NetSocket#upgradeToSsl} without indicating a server name
   * @param sslOptions 
   * @param msg 
   * @return 
   */
  public io.reactivex.Completable rxUpgradeToSsl(io.vertx.core.net.SSLOptions sslOptions, io.vertx.core.buffer.Buffer msg) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.upgradeToSsl(sslOptions, msg).onComplete($handler);
    });
  }

  /**
   * <p>Upgrade the channel to use SSL/TLS, in other words proceeds to the TLS handshake.</p>
   *
   * <p>The <code>upgrade</code> message will be sent after the socket is ready to proceed to the TLS handshake in
   * order to avoid data races. In practice is usually send by a server when it sends a message to the client
   * to proceed to the handshake, e.g. <code>250 STARTTLS</code> for an SMTP server, it should
   * be <code>null</code> on a client</p>
   *
   * <p>The server name is sent in the client handshake, it should be <code>null</code> on a server.</p>
   *
   * <p>Be aware that for this to work SSL must be configured.</p>
   * @param sslOptions the SSL options
   * @param serverName the server name
   * @param upgrade the upgrade message to send
   * @return a future completed when the connection has been upgraded to SSL
   */
  public io.vertx.core.Future<java.lang.Void> upgradeToSsl(io.vertx.core.net.SSLOptions sslOptions, java.lang.String serverName, io.vertx.core.buffer.Buffer upgrade) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.upgradeToSsl(sslOptions, serverName, upgrade).map(val -> val);
    return ret;
  }

  /**
   * <p>Upgrade the channel to use SSL/TLS, in other words proceeds to the TLS handshake.</p>
   *
   * <p>The <code>upgrade</code> message will be sent after the socket is ready to proceed to the TLS handshake in
   * order to avoid data races. In practice is usually send by a server when it sends a message to the client
   * to proceed to the handshake, e.g. <code>250 STARTTLS</code> for an SMTP server, it should
   * be <code>null</code> on a client</p>
   *
   * <p>The server name is sent in the client handshake, it should be <code>null</code> on a server.</p>
   *
   * <p>Be aware that for this to work SSL must be configured.</p>
   * @param sslOptions the SSL options
   * @param serverName the server name
   * @param upgrade the upgrade message to send
   * @return a future completed when the connection has been upgraded to SSL
   */
  public io.reactivex.Completable rxUpgradeToSsl(io.vertx.core.net.SSLOptions sslOptions, java.lang.String serverName, io.vertx.core.buffer.Buffer upgrade) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.upgradeToSsl(sslOptions, serverName, upgrade).onComplete($handler);
    });
  }

  /**
   * Upgrade channel to use SSL/TLS. Be aware that for this to work SSL must be configured.
   * @param sslOptions the SSL options
   * @return a future completed when the connection has been upgraded to SSL
   */
  public io.vertx.core.Future<java.lang.Void> upgradeToSsl(io.vertx.core.net.SSLOptions sslOptions) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.upgradeToSsl(sslOptions).map(val -> val);
    return ret;
  }

  /**
   * Upgrade channel to use SSL/TLS. Be aware that for this to work SSL must be configured.
   * @param sslOptions the SSL options
   * @return a future completed when the connection has been upgraded to SSL
   */
  public io.reactivex.Completable rxUpgradeToSsl(io.vertx.core.net.SSLOptions sslOptions) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.upgradeToSsl(sslOptions).onComplete($handler);
    });
  }

  /**
   * @return true if this {@link io.vertx.reactivex.core.net.NetSocket} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * Returns the SNI server name presented during the SSL handshake by the client.
   * @return the indicated server name
   */
  public java.lang.String indicatedServerName() { 
    java.lang.String ret = delegate.indicatedServerName();
    return ret;
  }

  /**
   * @return the application-level protocol negotiated during the TLS handshake
   */
  public java.lang.String applicationLayerProtocol() { 
    java.lang.String ret = delegate.applicationLayerProtocol();
    return ret;
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public javax.net.ssl.SSLSession sslSession() { 
    javax.net.ssl.SSLSession ret = delegate.sslSession();
    return ret;
  }

  private io.vertx.core.net.SocketAddress cached_0;
  private io.vertx.core.net.SocketAddress cached_1;
  public static NetSocket newInstance(io.vertx.core.net.NetSocket arg) {
    return arg != null ? new NetSocket(arg) : null;
  }

}
