/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.net;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a TCP server
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetServer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.net.NetServer.class)
public class NetServer implements RxDelegate, io.vertx.reactivex.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetServer that = (NetServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<NetServer> __TYPE_ARG = new TypeArg<>(    obj -> new NetServer((io.vertx.core.net.NetServer) obj),
    NetServer::getDelegate
  );

  private final io.vertx.core.net.NetServer delegate;
  
  public NetServer(io.vertx.core.net.NetServer delegate) {
    this.delegate = delegate;
  }

  public NetServer(Object delegate) {
    this.delegate = (io.vertx.core.net.NetServer)delegate;
  }

  @Override 
  public io.vertx.core.net.NetServer getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.core.net.NetServer> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.net.NetServer>(o1 -> io.vertx.reactivex.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.net.NetServer> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.core.net.NetServer>(o1 -> io.vertx.reactivex.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.net.NetServer> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.core.net.NetServer>(o1 -> io.vertx.reactivex.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.net.NetServer> TYPE_ARG_3 = new TypeArg<io.vertx.reactivex.core.net.NetServer>(o1 -> io.vertx.reactivex.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)o1), o1 -> o1.getDelegate());

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Supply a connect handler for this server. The server can only have at most one connect handler at any one time.
   * As the server accepts TCP or SSL connections it creates an instance of {@link io.vertx.reactivex.core.net.NetSocket} and passes it to the
   * connect handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.net.NetServer connectHandler(io.vertx.core.Handler<io.vertx.reactivex.core.net.NetSocket> handler) { 
    io.vertx.reactivex.core.net.NetServer ret = io.vertx.reactivex.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)delegate.connectHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)event))));
    return ret;
  }

  /**
   * Start listening on the port and host as configured in the {@link io.vertx.core.net.NetServerOptions} used when
   * creating the server.
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @return a future completed with the listen operation result
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.net.NetServer> listen() { 
    io.vertx.core.Future<io.vertx.reactivex.core.net.NetServer> ret = delegate.listen().map(val -> io.vertx.reactivex.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)val));
    return ret;
  }

  /**
   * Start listening on the port and host as configured in the {@link io.vertx.core.net.NetServerOptions} used when
   * creating the server.
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @return a future completed with the listen operation result
   */
  public io.reactivex.Single<io.vertx.reactivex.core.net.NetServer> rxListen() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listen().onComplete($handler);
    });
  }

  /**
   * Start listening on the specified port and host, ignoring port and host configured in the {@link io.vertx.core.net.NetServerOptions} used when
   * creating the server.
   * <p>
   * Port <code>0</code> can be specified meaning "choose an random port".
   * <p>
   * Host <code>0.0.0.0</code> can be specified meaning "listen on all available interfaces".
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @param port 
   * @param host 
   * @return a future completed with the listen operation result
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.net.NetServer> listen(int port, java.lang.String host) { 
    io.vertx.core.Future<io.vertx.reactivex.core.net.NetServer> ret = delegate.listen(port, host).map(val -> io.vertx.reactivex.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)val));
    return ret;
  }

  /**
   * Start listening on the specified port and host, ignoring port and host configured in the {@link io.vertx.core.net.NetServerOptions} used when
   * creating the server.
   * <p>
   * Port <code>0</code> can be specified meaning "choose an random port".
   * <p>
   * Host <code>0.0.0.0</code> can be specified meaning "listen on all available interfaces".
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @param port 
   * @param host 
   * @return a future completed with the listen operation result
   */
  public io.reactivex.Single<io.vertx.reactivex.core.net.NetServer> rxListen(int port, java.lang.String host) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listen(port, host).onComplete($handler);
    });
  }

  /**
   * Start listening on the specified port and host "0.0.0.0", ignoring port and host configured in the
   * {@link io.vertx.core.net.NetServerOptions} used when creating the server.
   * <p>
   * Port <code>0</code> can be specified meaning "choose an random port".
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @param port 
   * @return a future completed with the listen operation result
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.net.NetServer> listen(int port) { 
    io.vertx.core.Future<io.vertx.reactivex.core.net.NetServer> ret = delegate.listen(port).map(val -> io.vertx.reactivex.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)val));
    return ret;
  }

  /**
   * Start listening on the specified port and host "0.0.0.0", ignoring port and host configured in the
   * {@link io.vertx.core.net.NetServerOptions} used when creating the server.
   * <p>
   * Port <code>0</code> can be specified meaning "choose an random port".
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @param port 
   * @return a future completed with the listen operation result
   */
  public io.reactivex.Single<io.vertx.reactivex.core.net.NetServer> rxListen(int port) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listen(port).onComplete($handler);
    });
  }

  /**
   * Start listening on the specified local address, ignoring port and host configured in the {@link io.vertx.core.net.NetServerOptions} used when
   * creating the server.
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @param localAddress the local address to listen on
   * @return a future completed with the listen operation result
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.net.NetServer> listen(io.vertx.core.net.SocketAddress localAddress) { 
    io.vertx.core.Future<io.vertx.reactivex.core.net.NetServer> ret = delegate.listen(localAddress).map(val -> io.vertx.reactivex.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)val));
    return ret;
  }

  /**
   * Start listening on the specified local address, ignoring port and host configured in the {@link io.vertx.core.net.NetServerOptions} used when
   * creating the server.
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @param localAddress the local address to listen on
   * @return a future completed with the listen operation result
   */
  public io.reactivex.Single<io.vertx.reactivex.core.net.NetServer> rxListen(io.vertx.core.net.SocketAddress localAddress) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listen(localAddress).onComplete($handler);
    });
  }

  /**
   * Close the server. This will close any currently open connections. The close may not complete until after this
   * method has returned.
   * @return a future completed with the listen operation result
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Close the server. This will close any currently open connections. The close may not complete until after this
   * method has returned.
   * @return a future completed with the listen operation result
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * Shutdown with a 30 seconds timeout (<code>shutdown(30, TimeUnit.SECONDS)</code>).
   * @return a future completed when shutdown has completed
   */
  public io.vertx.core.Future<java.lang.Void> shutdown() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown().map(val -> val);
    return ret;
  }

  /**
   * Shutdown with a 30 seconds timeout (<code>shutdown(30, TimeUnit.SECONDS)</code>).
   * @return a future completed when shutdown has completed
   */
  public io.reactivex.Completable rxShutdown() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown().onComplete($handler);
    });
  }

  /**
   * Initiate the server shutdown sequence.
   * <p>
   * Connections are taken out of service and notified the close sequence has started through {@link io.vertx.reactivex.core.net.NetSocket#shutdownHandler}.
   * When all connections are closed the client is closed. When the <code>timeout</code> expires, all unclosed connections are immediately closed.
   * @param timeout the amount of time after which all resources are forcibly closed
   * @param unit the of the timeout
   * @return a future notified when the client is closed
   */
  public io.vertx.core.Future<java.lang.Void> shutdown(long timeout, java.util.concurrent.TimeUnit unit) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown(timeout, unit).map(val -> val);
    return ret;
  }

  /**
   * Initiate the server shutdown sequence.
   * <p>
   * Connections are taken out of service and notified the close sequence has started through {@link io.vertx.reactivex.core.net.NetSocket#shutdownHandler}.
   * When all connections are closed the client is closed. When the <code>timeout</code> expires, all unclosed connections are immediately closed.
   * @param timeout the amount of time after which all resources are forcibly closed
   * @param unit the of the timeout
   * @return a future notified when the client is closed
   */
  public io.reactivex.Completable rxShutdown(long timeout, java.util.concurrent.TimeUnit unit) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown(timeout, unit).onComplete($handler);
    });
  }

  /**
   * The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
   * signifying an ephemeral port
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  /**
   * <p>Update the server with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @return a future signaling the update success
   */
  public io.vertx.core.Future<java.lang.Boolean> updateSSLOptions(io.vertx.core.net.ServerSSLOptions options) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.updateSSLOptions(options).map(val -> val);
    return ret;
  }

  /**
   * <p>Update the server with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @return a future signaling the update success
   */
  public io.reactivex.Single<java.lang.Boolean> rxUpdateSSLOptions(io.vertx.core.net.ServerSSLOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.updateSSLOptions(options).onComplete($handler);
    });
  }

  /**
   * <p>Update the server with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The <code>options</code> object is compared using its <code>equals</code> method against the existing options to prevent
   * an update when the objects are equals since loading options can be costly, this can happen for share TCP servers.
   * When object are equals, setting <code>force</code> to <code>true</code> forces the update.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return a future signaling the update success
   */
  public io.vertx.core.Future<java.lang.Boolean> updateSSLOptions(io.vertx.core.net.ServerSSLOptions options, boolean force) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.updateSSLOptions(options, force).map(val -> val);
    return ret;
  }

  /**
   * <p>Update the server with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The <code>options</code> object is compared using its <code>equals</code> method against the existing options to prevent
   * an update when the objects are equals since loading options can be costly, this can happen for share TCP servers.
   * When object are equals, setting <code>force</code> to <code>true</code> forces the update.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return a future signaling the update success
   */
  public io.reactivex.Single<java.lang.Boolean> rxUpdateSSLOptions(io.vertx.core.net.ServerSSLOptions options, boolean force) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.updateSSLOptions(options, force).onComplete($handler);
    });
  }

  /**
   * <p>Update the server with new traffic <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The <code>options</code> object is compared using its <code>equals</code> method against the existing options to prevent
   * an update when the objects are equals since loading options can be costly, this can happen for share TCP servers.
   * When object are equals, setting <code>force</code> to <code>true</code> forces the update.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new traffic shaping options
   * @return a future signaling the update success
   */
  public io.vertx.core.Future<java.lang.Boolean> updateTrafficShapingOptions(io.vertx.core.net.TrafficShapingOptions options) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.updateTrafficShapingOptions(options).map(val -> val);
    return ret;
  }

  /**
   * <p>Update the server with new traffic <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The <code>options</code> object is compared using its <code>equals</code> method against the existing options to prevent
   * an update when the objects are equals since loading options can be costly, this can happen for share TCP servers.
   * When object are equals, setting <code>force</code> to <code>true</code> forces the update.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new traffic shaping options
   * @return a future signaling the update success
   */
  public io.reactivex.Single<java.lang.Boolean> rxUpdateTrafficShapingOptions(io.vertx.core.net.TrafficShapingOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.updateTrafficShapingOptions(options).onComplete($handler);
    });
  }

  public static NetServer newInstance(io.vertx.core.net.NetServer arg) {
    return arg != null ? new NetServer(arg) : null;
  }

}
