/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.net;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A TCP client.
 * <p>
 * Multiple connections to different servers can be made using the same instance.
 * <p>
 * This client supports a configurable number of connection attempts and a configurable
 * delay between attempts.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.net.NetClient.class)
public class NetClient implements RxDelegate, io.vertx.reactivex.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetClient that = (NetClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<NetClient> __TYPE_ARG = new TypeArg<>(    obj -> new NetClient((io.vertx.core.net.NetClient) obj),
    NetClient::getDelegate
  );

  private final io.vertx.core.net.NetClient delegate;
  
  public NetClient(io.vertx.core.net.NetClient delegate) {
    this.delegate = delegate;
  }

  public NetClient(Object delegate) {
    this.delegate = (io.vertx.core.net.NetClient)delegate;
  }

  @Override 
  public io.vertx.core.net.NetClient getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.core.net.NetSocket> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.net.NetSocket>(o1 -> io.vertx.reactivex.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.net.NetSocket> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.core.net.NetSocket>(o1 -> io.vertx.reactivex.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.net.NetSocket> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.core.net.NetSocket>(o1 -> io.vertx.reactivex.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.net.NetSocket> TYPE_ARG_3 = new TypeArg<io.vertx.reactivex.core.net.NetSocket>(o1 -> io.vertx.reactivex.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.net.NetSocket> TYPE_ARG_4 = new TypeArg<io.vertx.reactivex.core.net.NetSocket>(o1 -> io.vertx.reactivex.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.reactivex.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @return a future notified when the socket is connected
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.net.NetSocket> connect(int port, java.lang.String host) { 
    io.vertx.core.Future<io.vertx.reactivex.core.net.NetSocket> ret = delegate.connect(port, host).map(val -> io.vertx.reactivex.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)val));
    return ret;
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.reactivex.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @return a future notified when the socket is connected
   */
  public io.reactivex.Single<io.vertx.reactivex.core.net.NetSocket> rxConnect(int port, java.lang.String host) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.connect(port, host).onComplete($handler);
    });
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.reactivex.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @param serverName the SNI server name
   * @return a future notified when the socket is connected
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.net.NetSocket> connect(int port, java.lang.String host, java.lang.String serverName) { 
    io.vertx.core.Future<io.vertx.reactivex.core.net.NetSocket> ret = delegate.connect(port, host, serverName).map(val -> io.vertx.reactivex.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)val));
    return ret;
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.reactivex.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @param serverName the SNI server name
   * @return a future notified when the socket is connected
   */
  public io.reactivex.Single<io.vertx.reactivex.core.net.NetSocket> rxConnect(int port, java.lang.String host, java.lang.String serverName) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.connect(port, host, serverName).onComplete($handler);
    });
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.reactivex.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @return a future notified when the socket is connected
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.net.NetSocket> connect(io.vertx.core.net.SocketAddress remoteAddress) { 
    io.vertx.core.Future<io.vertx.reactivex.core.net.NetSocket> ret = delegate.connect(remoteAddress).map(val -> io.vertx.reactivex.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)val));
    return ret;
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.reactivex.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @return a future notified when the socket is connected
   */
  public io.reactivex.Single<io.vertx.reactivex.core.net.NetSocket> rxConnect(io.vertx.core.net.SocketAddress remoteAddress) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.connect(remoteAddress).onComplete($handler);
    });
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.reactivex.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @param serverName the SNI server name
   * @return a future notified when the socket is connected
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.net.NetSocket> connect(io.vertx.core.net.SocketAddress remoteAddress, java.lang.String serverName) { 
    io.vertx.core.Future<io.vertx.reactivex.core.net.NetSocket> ret = delegate.connect(remoteAddress, serverName).map(val -> io.vertx.reactivex.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)val));
    return ret;
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.reactivex.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @param serverName the SNI server name
   * @return a future notified when the socket is connected
   */
  public io.reactivex.Single<io.vertx.reactivex.core.net.NetSocket> rxConnect(io.vertx.core.net.SocketAddress remoteAddress, java.lang.String serverName) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.connect(remoteAddress, serverName).onComplete($handler);
    });
  }

  /**
   * Open a connection to a server at the specific <code>connectOptions</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.reactivex.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param connectOptions the options describing how to connect to the remote server
   * @return a future notified when the socket is connected
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.net.NetSocket> connect(io.vertx.core.net.ConnectOptions connectOptions) { 
    io.vertx.core.Future<io.vertx.reactivex.core.net.NetSocket> ret = delegate.connect(connectOptions).map(val -> io.vertx.reactivex.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)val));
    return ret;
  }

  /**
   * Open a connection to a server at the specific <code>connectOptions</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.reactivex.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param connectOptions the options describing how to connect to the remote server
   * @return a future notified when the socket is connected
   */
  public io.reactivex.Single<io.vertx.reactivex.core.net.NetSocket> rxConnect(io.vertx.core.net.ConnectOptions connectOptions) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.connect(connectOptions).onComplete($handler);
    });
  }

  /**
   * Close immediately (<code>shutdown(0, TimeUnit.SECONDS</code>).
   * @return a future notified when the client is closed
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Close immediately (<code>shutdown(0, TimeUnit.SECONDS</code>).
   * @return a future notified when the client is closed
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * Shutdown with a 30 seconds timeout (<code>shutdown(30, TimeUnit.SECONDS)</code>).
   * @return a future completed when shutdown has completed
   */
  public io.vertx.core.Future<java.lang.Void> shutdown() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown().map(val -> val);
    return ret;
  }

  /**
   * Shutdown with a 30 seconds timeout (<code>shutdown(30, TimeUnit.SECONDS)</code>).
   * @return a future completed when shutdown has completed
   */
  public io.reactivex.Completable rxShutdown() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown().onComplete($handler);
    });
  }

  /**
   * Initiate the client shutdown sequence.
   * <p>
   * Connections are taken out of service and notified the close sequence has started through {@link io.vertx.reactivex.core.net.NetSocket#shutdownHandler}.
   * When all connections are closed the client is closed. When the <code>timeout</code> expires, all unclosed connections are immediately closed.
   * @param timeout the amount of time after which all resources are forcibly closed
   * @param unit the of the timeout
   * @return a future notified when the client is closed
   */
  public io.vertx.core.Future<java.lang.Void> shutdown(long timeout, java.util.concurrent.TimeUnit unit) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown(timeout, unit).map(val -> val);
    return ret;
  }

  /**
   * Initiate the client shutdown sequence.
   * <p>
   * Connections are taken out of service and notified the close sequence has started through {@link io.vertx.reactivex.core.net.NetSocket#shutdownHandler}.
   * When all connections are closed the client is closed. When the <code>timeout</code> expires, all unclosed connections are immediately closed.
   * @param timeout the amount of time after which all resources are forcibly closed
   * @param unit the of the timeout
   * @return a future notified when the client is closed
   */
  public io.reactivex.Completable rxShutdown(long timeout, java.util.concurrent.TimeUnit unit) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown(timeout, unit).onComplete($handler);
    });
  }

  /**
   * <p>Update the client with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @return a future signaling the update success
   */
  public io.vertx.core.Future<java.lang.Boolean> updateSSLOptions(io.vertx.core.net.ClientSSLOptions options) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.updateSSLOptions(options).map(val -> val);
    return ret;
  }

  /**
   * <p>Update the client with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @return a future signaling the update success
   */
  public io.reactivex.Single<java.lang.Boolean> rxUpdateSSLOptions(io.vertx.core.net.ClientSSLOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.updateSSLOptions(options).onComplete($handler);
    });
  }

  /**
   * <p>Update the client with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The <code>options</code> object is compared using its <code>equals</code> method against the existing options to prevent
   * an update when the objects are equals since loading options can be costly, this can happen for share TCP servers.
   * When object are equals, setting <code>force</code> to <code>true</code> forces the update.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return a future signaling the update success
   */
  public io.vertx.core.Future<java.lang.Boolean> updateSSLOptions(io.vertx.core.net.ClientSSLOptions options, boolean force) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.updateSSLOptions(options, force).map(val -> val);
    return ret;
  }

  /**
   * <p>Update the client with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The <code>options</code> object is compared using its <code>equals</code> method against the existing options to prevent
   * an update when the objects are equals since loading options can be costly, this can happen for share TCP servers.
   * When object are equals, setting <code>force</code> to <code>true</code> forces the update.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return a future signaling the update success
   */
  public io.reactivex.Single<java.lang.Boolean> rxUpdateSSLOptions(io.vertx.core.net.ClientSSLOptions options, boolean force) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.updateSSLOptions(options, force).onComplete($handler);
    });
  }

  public static NetClient newInstance(io.vertx.core.net.NetClient arg) {
    return arg != null ? new NetClient(arg) : null;
  }

}
