/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.http;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An asynchronous WebSocket client.
 * <p>
 * It allows you to open WebSockets to servers.
 * <p>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.WebSocketClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.WebSocketClient.class)
public class WebSocketClient implements RxDelegate, io.vertx.reactivex.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebSocketClient that = (WebSocketClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<WebSocketClient> __TYPE_ARG = new TypeArg<>(    obj -> new WebSocketClient((io.vertx.core.http.WebSocketClient) obj),
    WebSocketClient::getDelegate
  );

  private final io.vertx.core.http.WebSocketClient delegate;
  
  public WebSocketClient(io.vertx.core.http.WebSocketClient delegate) {
    this.delegate = delegate;
  }

  public WebSocketClient(Object delegate) {
    this.delegate = (io.vertx.core.http.WebSocketClient)delegate;
  }

  @Override 
  public io.vertx.core.http.WebSocketClient getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.core.http.WebSocket> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.http.WebSocket>(o1 -> io.vertx.reactivex.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.http.WebSocket> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.core.http.WebSocket>(o1 -> io.vertx.reactivex.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.http.WebSocket> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.core.http.WebSocket>(o1 -> io.vertx.reactivex.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.http.WebSocket> TYPE_ARG_3 = new TypeArg<io.vertx.reactivex.core.http.WebSocket>(o1 -> io.vertx.reactivex.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Create a WebSocket that is not yet connected to the server.
   * @return the client WebSocket
   */
  public io.vertx.reactivex.core.http.ClientWebSocket webSocket() { 
    io.vertx.reactivex.core.http.ClientWebSocket ret = io.vertx.reactivex.core.http.ClientWebSocket.newInstance((io.vertx.core.http.ClientWebSocket)delegate.webSocket());
    return ret;
  }

  /**
   * Connect a WebSocket to the specified port, host and relative request URI.
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return a future notified when the WebSocket when connected
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.http.WebSocket> connect(int port, java.lang.String host, java.lang.String requestURI) { 
    io.vertx.core.Future<io.vertx.reactivex.core.http.WebSocket> ret = delegate.connect(port, host, requestURI).map(val -> io.vertx.reactivex.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)val));
    return ret;
  }

  /**
   * Connect a WebSocket to the specified port, host and relative request URI.
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return a future notified when the WebSocket when connected
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.WebSocket> rxConnect(int port, java.lang.String host, java.lang.String requestURI) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.connect(port, host, requestURI).onComplete($handler);
    });
  }

  /**
   * Connect a WebSocket to the default client port and specified host and relative request URI.
   * @param host the host
   * @param requestURI the relative URI
   * @return a future notified when the WebSocket when connected
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.http.WebSocket> connect(java.lang.String host, java.lang.String requestURI) { 
    io.vertx.core.Future<io.vertx.reactivex.core.http.WebSocket> ret = delegate.connect(host, requestURI).map(val -> io.vertx.reactivex.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)val));
    return ret;
  }

  /**
   * Connect a WebSocket to the default client port and specified host and relative request URI.
   * @param host the host
   * @param requestURI the relative URI
   * @return a future notified when the WebSocket when connected
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.WebSocket> rxConnect(java.lang.String host, java.lang.String requestURI) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.connect(host, requestURI).onComplete($handler);
    });
  }

  /**
   * Connect a WebSocket to the default client port, default client host and specified, relative request URI.
   * @param requestURI the relative URI
   * @return a future notified when the WebSocket when connected
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.http.WebSocket> connect(java.lang.String requestURI) { 
    io.vertx.core.Future<io.vertx.reactivex.core.http.WebSocket> ret = delegate.connect(requestURI).map(val -> io.vertx.reactivex.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)val));
    return ret;
  }

  /**
   * Connect a WebSocket to the default client port, default client host and specified, relative request URI.
   * @param requestURI the relative URI
   * @return a future notified when the WebSocket when connected
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.WebSocket> rxConnect(java.lang.String requestURI) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.connect(requestURI).onComplete($handler);
    });
  }

  /**
   * Connect a WebSocket with the specified options.
   * @param options the request options
   * @return a future notified when the WebSocket when connected
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.http.WebSocket> connect(io.vertx.core.http.WebSocketConnectOptions options) { 
    io.vertx.core.Future<io.vertx.reactivex.core.http.WebSocket> ret = delegate.connect(options).map(val -> io.vertx.reactivex.core.http.WebSocket.newInstance((io.vertx.core.http.WebSocket)val));
    return ret;
  }

  /**
   * Connect a WebSocket with the specified options.
   * @param options the request options
   * @return a future notified when the WebSocket when connected
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.WebSocket> rxConnect(io.vertx.core.http.WebSocketConnectOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.connect(options).onComplete($handler);
    });
  }

  /**
   * Shutdown with a 30 seconds timeout (<code>shutdown(30, TimeUnit.SECONDS)</code>).
   * @return a future completed when shutdown has completed
   */
  public io.vertx.core.Future<java.lang.Void> shutdown() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown().map(val -> val);
    return ret;
  }

  /**
   * Shutdown with a 30 seconds timeout (<code>shutdown(30, TimeUnit.SECONDS)</code>).
   * @return a future completed when shutdown has completed
   */
  public io.reactivex.Completable rxShutdown() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown().onComplete($handler);
    });
  }

  /**
   * Close immediately (<code>shutdown(0, TimeUnit.SECONDS</code>).
   * @return a future notified when the client is closed
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Close immediately (<code>shutdown(0, TimeUnit.SECONDS</code>).
   * @return a future notified when the client is closed
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * Update the client with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   * @param options the new SSL options
   * @return a future signaling the update success
   */
  public io.vertx.core.Future<java.lang.Boolean> updateSSLOptions(io.vertx.core.net.ClientSSLOptions options) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.updateSSLOptions(options).map(val -> val);
    return ret;
  }

  /**
   * Update the client with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   * @param options the new SSL options
   * @return a future signaling the update success
   */
  public io.reactivex.Single<java.lang.Boolean> rxUpdateSSLOptions(io.vertx.core.net.ClientSSLOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.updateSSLOptions(options).onComplete($handler);
    });
  }

  /**
   * <p>Update the client with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The <code>options</code> object is compared using its <code>equals</code> method against the existing options to prevent
   * an update when the objects are equals since loading options can be costly, this can happen for share TCP servers.
   * When object are equals, setting <code>force</code> to <code>true</code> forces the update.
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return a future signaling the update success
   */
  public io.vertx.core.Future<java.lang.Boolean> updateSSLOptions(io.vertx.core.net.ClientSSLOptions options, boolean force) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.updateSSLOptions(options, force).map(val -> val);
    return ret;
  }

  /**
   * <p>Update the client with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The <code>options</code> object is compared using its <code>equals</code> method against the existing options to prevent
   * an update when the objects are equals since loading options can be costly, this can happen for share TCP servers.
   * When object are equals, setting <code>force</code> to <code>true</code> forces the update.
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return a future signaling the update success
   */
  public io.reactivex.Single<java.lang.Boolean> rxUpdateSSLOptions(io.vertx.core.net.ClientSSLOptions options, boolean force) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.updateSSLOptions(options, force).onComplete($handler);
    });
  }

  /**
   * Initiate the client shutdown sequence.
   * @param timeout the amount of time after which all resources are forcibly closed
   * @param unit the of the timeout
   * @return a future notified when the client is closed
   */
  public io.vertx.core.Future<java.lang.Void> shutdown(long timeout, java.util.concurrent.TimeUnit unit) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown(timeout, unit).map(val -> val);
    return ret;
  }

  /**
   * Initiate the client shutdown sequence.
   * @param timeout the amount of time after which all resources are forcibly closed
   * @param unit the of the timeout
   * @return a future notified when the client is closed
   */
  public io.reactivex.Completable rxShutdown(long timeout, java.util.concurrent.TimeUnit unit) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown(timeout, unit).onComplete($handler);
    });
  }

  public static WebSocketClient newInstance(io.vertx.core.http.WebSocketClient arg) {
    return arg != null ? new WebSocketClient(arg) : null;
  }

}
