/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.http;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a server side WebSocket.
 * <p>
 * Instances of this class are passed into a {@link io.vertx.reactivex.core.http.HttpServer#webSocketHandler} or provided
 * when a WebSocket handshake is manually {@link io.vertx.reactivex.core.http.HttpServerRequest#toWebSocket}ed.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.ServerWebSocket original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.ServerWebSocket.class)
public class ServerWebSocket extends io.vertx.reactivex.core.http.WebSocket implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServerWebSocket that = (ServerWebSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ServerWebSocket> __TYPE_ARG = new TypeArg<>(    obj -> new ServerWebSocket((io.vertx.core.http.ServerWebSocket) obj),
    ServerWebSocket::getDelegate
  );

  private final io.vertx.core.http.ServerWebSocket delegate;
  
  public ServerWebSocket(io.vertx.core.http.ServerWebSocket delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public ServerWebSocket(Object delegate) {
    super((io.vertx.core.http.ServerWebSocket)delegate);
    this.delegate = (io.vertx.core.http.ServerWebSocket)delegate;
  }

  @Override 
  public io.vertx.core.http.ServerWebSocket getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<io.vertx.core.buffer.Buffer> observable;
  private io.reactivex.Flowable<io.vertx.core.buffer.Buffer> flowable;

  public synchronized io.reactivex.Observable<io.vertx.core.buffer.Buffer> toObservable() {
    if (observable == null) {
      observable = ObservableHelper.toObservable(this.getDelegate());
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<io.vertx.core.buffer.Buffer> toFlowable() {
    if (flowable == null) {
      flowable = FlowableHelper.toFlowable(this.getDelegate());
    }
    return flowable;
  }

  private WriteStreamObserver<io.vertx.core.buffer.Buffer> observer;
  private WriteStreamSubscriber<io.vertx.core.buffer.Buffer> subscriber;

  public synchronized WriteStreamObserver<io.vertx.core.buffer.Buffer> toObserver() {
    if (observer == null) {
      observer = RxHelper.toObserver(getDelegate());
    }
    return observer;
  }

  public synchronized WriteStreamSubscriber<io.vertx.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      subscriber = RxHelper.toSubscriber(getDelegate());
    }
    return subscriber;
  }


  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<io.vertx.core.buffer.Buffer> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TypeArg.unknown());
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.vertx.core.Future<java.lang.Void> pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.buffer.Buffer> dst) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.pipeTo(dst.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.reactivex.Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.buffer.Buffer> dst) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.pipeTo(dst).onComplete($handler);
    });
  }

  /**
   * Write some data to the stream.
   *
   * <p> The data is usually put on an internal write queue, and the write actually happens
   * asynchronously. To avoid running out of memory by putting too much on the write queue,
   * check the {@link io.vertx.reactivex.core.streams.WriteStream#writeQueueFull} method before writing. This is done automatically if
   * using a .
   *
   * <p> When the <code>data</code> is moved from the queue to the actual medium, the returned
   *  will be completed with the write result, e.g the future is succeeded
   * when a server HTTP response buffer is written to the socket and failed if the remote
   * client has closed the socket while the data was still pending for write.
   * @param data the data to write
   * @return a future completed with the write result
   */
  public io.vertx.core.Future<java.lang.Void> write(io.vertx.core.buffer.Buffer data) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.write(data).map(val -> val);
    return ret;
  }

  /**
   * Write some data to the stream.
   *
   * <p> The data is usually put on an internal write queue, and the write actually happens
   * asynchronously. To avoid running out of memory by putting too much on the write queue,
   * check the {@link io.vertx.reactivex.core.streams.WriteStream#writeQueueFull} method before writing. This is done automatically if
   * using a .
   *
   * <p> When the <code>data</code> is moved from the queue to the actual medium, the returned
   *  will be completed with the write result, e.g the future is succeeded
   * when a server HTTP response buffer is written to the socket and failed if the remote
   * client has closed the socket while the data was still pending for write.
   * @param data the data to write
   * @return a future completed with the write result
   */
  public io.reactivex.Completable rxWrite(io.vertx.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.write(data).onComplete($handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.http.WebSocketBase#end} but writes some data to the stream before ending.
   * @param data the data to write
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> end(io.vertx.core.buffer.Buffer data) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.end(data).map(val -> val);
    return ret;
  }

  /**
   * Same as {@link io.vertx.reactivex.core.http.WebSocketBase#end} but writes some data to the stream before ending.
   * @param data the data to write
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxEnd(io.vertx.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.end(data).onComplete($handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.reactivex.core.http.ServerWebSocket#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * When a <code>WebSocket</code> is created, it may register an event handler with the event bus - the ID of that
   * handler is given by this method.
   * <p>
   * By default, no handler is registered, the feature must be enabled via {@link io.vertx.core.http.WebSocketConnectOptions} or {@link io.vertx.core.http.HttpServerOptions}.
   * <p>
   * Given this ID, a different event loop can send a binary frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return the binary handler id
   */
  public java.lang.String binaryHandlerID() { 
    java.lang.String ret = delegate.binaryHandlerID();
    return ret;
  }

  /**
   * When a <code>WebSocket</code> is created, it may register an event handler with the eventbus, the ID of that
   * handler is given by <code>textHandlerID</code>.
   * <p>
   * By default, no handler is registered, the feature must be enabled via {@link io.vertx.core.http.WebSocketConnectOptions} or {@link io.vertx.core.http.HttpServerOptions}.
   * <p>
   * Given this ID, a different event loop can send a text frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return the text handler id
   */
  public java.lang.String textHandlerID() { 
    java.lang.String ret = delegate.textHandlerID();
    return ret;
  }

  /**
   * Returns the WebSocket sub protocol selected by the WebSocket handshake.
   * <p/>
   * On the server, the value will be <code>null</code> when the handler receives the WebSocket callback as the
   * handshake will not be completed yet.
   * @return 
   */
  public java.lang.String subProtocol() { 
    java.lang.String ret = delegate.subProtocol();
    return ret;
  }

  /**
   * Returns the close status code received from the remote endpoint or <code>null</code> when not yet received.
   * @return 
   */
  public java.lang.Short closeStatusCode() { 
    java.lang.Short ret = delegate.closeStatusCode();
    return ret;
  }

  /**
   * Returns the close reason message from the remote endpoint or <code>null</code> when not yet received.
   * @return 
   */
  public java.lang.String closeReason() { 
    java.lang.String ret = delegate.closeReason();
    return ret;
  }

  /**
   *  Returns the HTTP headers.
   * @return the headers
   */
  public io.vertx.core.MultiMap headers() { 
    io.vertx.core.MultiMap ret = delegate.headers();
    return ret;
  }

  /**
   * Write a WebSocket frame to the connection
   * @param frame the frame to write
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> writeFrame(io.vertx.core.http.WebSocketFrame frame) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.writeFrame(frame).map(val -> val);
    return ret;
  }

  /**
   * Write a WebSocket frame to the connection
   * @param frame the frame to write
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxWriteFrame(io.vertx.core.http.WebSocketFrame frame) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.writeFrame(frame).onComplete($handler);
    });
  }

  /**
   * Write a final WebSocket text frame to the connection
   * @param text The text to write
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> writeFinalTextFrame(java.lang.String text) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.writeFinalTextFrame(text).map(val -> val);
    return ret;
  }

  /**
   * Write a final WebSocket text frame to the connection
   * @param text The text to write
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxWriteFinalTextFrame(java.lang.String text) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.writeFinalTextFrame(text).onComplete($handler);
    });
  }

  /**
   * Write a final WebSocket binary frame to the connection
   * @param data The data to write
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> writeFinalBinaryFrame(io.vertx.core.buffer.Buffer data) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.writeFinalBinaryFrame(data).map(val -> val);
    return ret;
  }

  /**
   * Write a final WebSocket binary frame to the connection
   * @param data The data to write
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxWriteFinalBinaryFrame(io.vertx.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.writeFinalBinaryFrame(data).onComplete($handler);
    });
  }

  /**
   * Writes a (potentially large) piece of binary data to the connection. This data might be written as multiple frames
   * if it exceeds the maximum WebSocket frame size.
   * @param data the data to write
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> writeBinaryMessage(io.vertx.core.buffer.Buffer data) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.writeBinaryMessage(data).map(val -> val);
    return ret;
  }

  /**
   * Writes a (potentially large) piece of binary data to the connection. This data might be written as multiple frames
   * if it exceeds the maximum WebSocket frame size.
   * @param data the data to write
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxWriteBinaryMessage(io.vertx.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.writeBinaryMessage(data).onComplete($handler);
    });
  }

  /**
   * Writes a (potentially large) piece of text data to the connection. This data might be written as multiple frames
   * if it exceeds the maximum WebSocket frame size.
   * @param text the data to write
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> writeTextMessage(java.lang.String text) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.writeTextMessage(text).map(val -> val);
    return ret;
  }

  /**
   * Writes a (potentially large) piece of text data to the connection. This data might be written as multiple frames
   * if it exceeds the maximum WebSocket frame size.
   * @param text the data to write
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxWriteTextMessage(java.lang.String text) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.writeTextMessage(text).onComplete($handler);
    });
  }

  /**
   * Writes a ping frame to the connection. This will be written in a single frame. Ping frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 Section <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no handler for ping frames because RFC 6455  clearly
   * states that the only response to a ping frame is a pong frame with identical contents.
   * @param data the data to write, may be at most 125 bytes
   * @return a future notified when the ping frame has been successfully written
   */
  public io.vertx.core.Future<java.lang.Void> writePing(io.vertx.core.buffer.Buffer data) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.writePing(data).map(val -> val);
    return ret;
  }

  /**
   * Writes a ping frame to the connection. This will be written in a single frame. Ping frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 Section <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no handler for ping frames because RFC 6455  clearly
   * states that the only response to a ping frame is a pong frame with identical contents.
   * @param data the data to write, may be at most 125 bytes
   * @return a future notified when the ping frame has been successfully written
   */
  public io.reactivex.Completable rxWritePing(io.vertx.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.writePing(data).onComplete($handler);
    });
  }

  /**
   * Writes a pong frame to the connection. This will be written in a single frame. Pong frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no need to manually write a pong frame, as the server and client both handle responding to a ping from with a pong from
   * automatically and this is exposed to users. RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> states that pongs may be sent unsolicited in order
   * to implement a one way heartbeat.
   * @param data the data to write, may be at most 125 bytes
   * @return a future notified when the pong frame has been successfully written
   */
  public io.vertx.core.Future<java.lang.Void> writePong(io.vertx.core.buffer.Buffer data) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.writePong(data).map(val -> val);
    return ret;
  }

  /**
   * Writes a pong frame to the connection. This will be written in a single frame. Pong frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no need to manually write a pong frame, as the server and client both handle responding to a ping from with a pong from
   * automatically and this is exposed to users. RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> states that pongs may be sent unsolicited in order
   * to implement a one way heartbeat.
   * @param data the data to write, may be at most 125 bytes
   * @return a future notified when the pong frame has been successfully written
   */
  public io.reactivex.Completable rxWritePong(io.vertx.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.writePong(data).onComplete($handler);
    });
  }

  /**
   * 
   *
   * Calls {@link io.vertx.reactivex.core.http.ServerWebSocket#close}
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> end() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.end().map(val -> val);
    return ret;
  }

  /**
   * 
   *
   * Calls {@link io.vertx.reactivex.core.http.ServerWebSocket#close}
   * @return 
   */
  public io.reactivex.Completable rxEnd() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.end().onComplete($handler);
    });
  }

  /**
   * Close the WebSocket sending a close frame with specified status code. You can give a look at various close payloads
   * here: RFC6455 <a href="https://tools.ietf.org/html/rfc6455#section-7.4.1">section 7.4.1</a>
   * <p/>
   * No more messages can be sent.
   * @param statusCode the status code
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> close(short statusCode) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close(statusCode).map(val -> val);
    return ret;
  }

  /**
   * Close the WebSocket sending a close frame with specified status code. You can give a look at various close payloads
   * here: RFC6455 <a href="https://tools.ietf.org/html/rfc6455#section-7.4.1">section 7.4.1</a>
   * <p/>
   * No more messages can be sent.
   * @param statusCode the status code
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxClose(short statusCode) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close(statusCode).onComplete($handler);
    });
  }

  /**
   * Close sending a close frame with specified status code and reason. You can give a look at various close payloads
   * here: RFC6455 <a href="https://tools.ietf.org/html/rfc6455#section-7.4.1">section 7.4.1</a>
   * <p/>
   * No more messages can be sent.
   * @param statusCode the status code
   * @param reason reason of closure
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> close(short statusCode, java.lang.String reason) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close(statusCode, reason).map(val -> val);
    return ret;
  }

  /**
   * Close sending a close frame with specified status code and reason. You can give a look at various close payloads
   * here: RFC6455 <a href="https://tools.ietf.org/html/rfc6455#section-7.4.1">section 7.4.1</a>
   * <p/>
   * No more messages can be sent.
   * @param statusCode the status code
   * @param reason reason of closure
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxClose(short statusCode, java.lang.String reason) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close(statusCode, reason).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.WebSocketBase#shutdown} with a 30 seconds timeout, the status code <code>1000</code> a <code>null</code> reason.
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> shutdown() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown().map(val -> val);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.WebSocketBase#shutdown} with a 30 seconds timeout, the status code <code>1000</code> a <code>null</code> reason.
   * @return 
   */
  public io.reactivex.Completable rxShutdown() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown().onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.WebSocketBase#shutdown} with a 30 seconds timeout and a <code>null</code> reason.
   * @param statusCode 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> shutdown(short statusCode) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown(statusCode).map(val -> val);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.WebSocketBase#shutdown} with a 30 seconds timeout and a <code>null</code> reason.
   * @param statusCode 
   * @return 
   */
  public io.reactivex.Completable rxShutdown(short statusCode) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown(statusCode).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.WebSocketBase#shutdown} with a 30 seconds timeout.
   * @param statusCode 
   * @param reason 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> shutdown(short statusCode, java.lang.String reason) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown(statusCode, reason).map(val -> val);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.WebSocketBase#shutdown} with a 30 seconds timeout.
   * @param statusCode 
   * @param reason 
   * @return 
   */
  public io.reactivex.Completable rxShutdown(short statusCode, java.lang.String reason) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown(statusCode, reason).onComplete($handler);
    });
  }

  /**
   * Calls {@link io.vertx.reactivex.core.http.WebSocketBase#shutdown} with the status code <code>1000</code> and a <code>null</code> reason.
   * @param timeout 
   * @param unit 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> shutdown(long timeout, java.util.concurrent.TimeUnit unit) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown(timeout, unit).map(val -> val);
    return ret;
  }

  /**
   * Calls {@link io.vertx.reactivex.core.http.WebSocketBase#shutdown} with the status code <code>1000</code> and a <code>null</code> reason.
   * @param timeout 
   * @param unit 
   * @return 
   */
  public io.reactivex.Completable rxShutdown(long timeout, java.util.concurrent.TimeUnit unit) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown(timeout, unit).onComplete($handler);
    });
  }

  /**
   * Calls {@link io.vertx.reactivex.core.http.WebSocketBase#shutdown} with a <code>null</code> reason.
   * @param timeout 
   * @param unit 
   * @param statusCode 
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> shutdown(long timeout, java.util.concurrent.TimeUnit unit, short statusCode) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown(timeout, unit, statusCode).map(val -> val);
    return ret;
  }

  /**
   * Calls {@link io.vertx.reactivex.core.http.WebSocketBase#shutdown} with a <code>null</code> reason.
   * @param timeout 
   * @param unit 
   * @param statusCode 
   * @return 
   */
  public io.reactivex.Completable rxShutdown(long timeout, java.util.concurrent.TimeUnit unit, short statusCode) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown(timeout, unit, statusCode).onComplete($handler);
    });
  }

  /**
   * Initiate a graceful WebSocket shutdown, the shutdown handler is notified and shall close the WebSocket, otherwise
   * after a <code>timeout</code> the WebSocket will be closed.
   * <p/>
   * The WebSocket is closed with specified status code and reason. You can give a look at various close payloads
   * here: RFC6455 <a href="https://tools.ietf.org/html/rfc6455#section-7.4.1">section 7.4.1</a>
   * @param timeout the amount of time after which all resources are forcibly closed
   * @param unit the of the timeout
   * @param statusCode the status code
   * @param reason reason of closure
   * @return a future completed when shutdown has completed
   */
  public io.vertx.core.Future<java.lang.Void> shutdown(long timeout, java.util.concurrent.TimeUnit unit, short statusCode, java.lang.String reason) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown(timeout, unit, statusCode, reason).map(val -> val);
    return ret;
  }

  /**
   * Initiate a graceful WebSocket shutdown, the shutdown handler is notified and shall close the WebSocket, otherwise
   * after a <code>timeout</code> the WebSocket will be closed.
   * <p/>
   * The WebSocket is closed with specified status code and reason. You can give a look at various close payloads
   * here: RFC6455 <a href="https://tools.ietf.org/html/rfc6455#section-7.4.1">section 7.4.1</a>
   * @param timeout the amount of time after which all resources are forcibly closed
   * @param unit the of the timeout
   * @param statusCode the status code
   * @param reason reason of closure
   * @return a future completed when shutdown has completed
   */
  public io.reactivex.Completable rxShutdown(long timeout, java.util.concurrent.TimeUnit unit, short statusCode, java.lang.String reason) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown(timeout, unit, statusCode, reason).onComplete($handler);
    });
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket). If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the actual connecting client.
   */
  public io.vertx.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.core.net.SocketAddress ret = delegate.remoteAddress();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket) If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the proxy.
   */
  public io.vertx.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.core.net.SocketAddress ret = delegate.localAddress();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.reactivex.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * @return <code>true</code> if the WebSocket cannot be used to send message anymore
   */
  public boolean isClosed() { 
    boolean ret = delegate.isClosed();
    return ret;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket handler(io.vertx.core.Handler<io.vertx.core.buffer.Buffer> handler) { 
    delegate.handler(handler);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket drainHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  public io.vertx.reactivex.core.http.ServerWebSocket frameHandler(io.vertx.core.Handler<io.vertx.core.http.WebSocketFrame> handler) { 
    delegate.frameHandler(handler);
    return this;
  }

  /**
   * @return the WebSocket handshake scheme
   */
  public java.lang.String scheme() { 
    java.lang.String ret = delegate.scheme();
    return ret;
  }

  /**
   * @return the WebSocket handshake authority
   */
  public io.vertx.core.net.HostAndPort authority() { 
    io.vertx.core.net.HostAndPort ret = delegate.authority();
    return ret;
  }

  public java.lang.String uri() { 
    java.lang.String ret = delegate.uri();
    return ret;
  }

  /**
   * @return the WebSocket handshake path.
   */
  public java.lang.String path() { 
    java.lang.String ret = delegate.path();
    return ret;
  }

  /**
   * @return the WebSocket handshake query string.
   */
  public java.lang.String query() { 
    java.lang.String ret = delegate.query();
    return ret;
  }

  /**
   * 
   *
   * <p>
   * The WebSocket handshake will be accepted when it hasn't yet been settled or when an asynchronous handshake
   * is in progress.
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * 
   *
   * <p>
   * The WebSocket handshake will be accepted when it hasn't yet been settled or when an asynchronous handshake
   * is in progress.
   * @return 
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public javax.net.ssl.SSLSession sslSession() { 
    javax.net.ssl.SSLSession ret = delegate.sslSession();
    return ret;
  }

  private io.vertx.core.net.SocketAddress cached_0;
  private io.vertx.core.net.SocketAddress cached_1;
  public static ServerWebSocket newInstance(io.vertx.core.http.ServerWebSocket arg) {
    return arg != null ? new ServerWebSocket(arg) : null;
  }

}
