/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.http;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An HTTP and WebSockets server.
 * <p>
 * You receive HTTP requests by providing a {@link io.vertx.reactivex.core.http.HttpServer#requestHandler}. As requests arrive on the server the handler
 * will be called with the requests.
 * <p>
 * You receive WebSockets by providing a {@link io.vertx.reactivex.core.http.HttpServer#webSocketHandler}. As WebSocket connections arrive on the server, the
 * WebSocket is passed to the handler.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpServer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.HttpServer.class)
public class HttpServer implements RxDelegate, io.vertx.reactivex.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpServer that = (HttpServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HttpServer> __TYPE_ARG = new TypeArg<>(    obj -> new HttpServer((io.vertx.core.http.HttpServer) obj),
    HttpServer::getDelegate
  );

  private final io.vertx.core.http.HttpServer delegate;
  
  public HttpServer(io.vertx.core.http.HttpServer delegate) {
    this.delegate = delegate;
  }

  public HttpServer(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpServer)delegate;
  }

  @Override 
  public io.vertx.core.http.HttpServer getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.core.http.HttpServer> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.http.HttpServer>(o1 -> io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.http.HttpServer> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.core.http.HttpServer>(o1 -> io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.http.HttpServer> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.core.http.HttpServer>(o1 -> io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.http.HttpServer> TYPE_ARG_3 = new TypeArg<io.vertx.reactivex.core.http.HttpServer>(o1 -> io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)o1), o1 -> o1.getDelegate());

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Set the request handler for the server to <code>requestHandler</code>. As HTTP requests are received by the server,
   * instances of {@link io.vertx.reactivex.core.http.HttpServerRequest} will be created and passed to this handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpServer requestHandler(io.vertx.core.Handler<io.vertx.reactivex.core.http.HttpServerRequest> handler) { 
    delegate.requestHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)event)));
    return this;
  }

  /**
   * Set a <code>handler</code> for handling invalid requests. When an invalid request is received by the server
   * this handler will be called with the request. The handler can send any HTTP response, when the response
   * ends, the server shall close the connection. {@link io.vertx.reactivex.core.http.HttpServerRequest#decoderResult} can be used
   * to obtain the Netty decoder result and the failure cause reported by the decoder.
   *
   * <p> Currently this handler is only used for HTTP/1.x requests.
   *
   * <p> When no specific handler is set, the {@link io.vertx.reactivex.core.http.HttpServerRequest} is used.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpServer invalidRequestHandler(io.vertx.core.Handler<io.vertx.reactivex.core.http.HttpServerRequest> handler) { 
    io.vertx.reactivex.core.http.HttpServer ret = io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)delegate.invalidRequestHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)event))));
    return ret;
  }

  /**
   * Set a connection handler for the server.
   * <br/>
   * The handler will always be called on the event-loop thread.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpServer connectionHandler(io.vertx.core.Handler<io.vertx.reactivex.core.http.HttpConnection> handler) { 
    delegate.connectionHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.core.http.HttpConnection.newInstance((io.vertx.core.http.HttpConnection)event)));
    return this;
  }

  /**
   * Set a handler for WebSocket handshake.
   *
   * <p>When an inbound HTTP request presents a WebSocket upgrade, this handler is called first. The handler
   * can chose to {@link io.vertx.reactivex.core.http.ServerWebSocketHandshake#accept} or {@link io.vertx.reactivex.core.http.ServerWebSocketHandshake#reject} the request.</p>
   *
   * <p>Setting no handler, implicitly accepts any HTTP request connection presenting an upgrade header and upgrades it
   * to a WebSocket.</p>
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.core.http.HttpServer webSocketHandshakeHandler(io.vertx.core.Handler<io.vertx.reactivex.core.http.ServerWebSocketHandshake> handler) { 
    delegate.webSocketHandshakeHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.core.http.ServerWebSocketHandshake.newInstance((io.vertx.core.http.ServerWebSocketHandshake)event)));
    return this;
  }

  /**
   * Set an exception handler called for socket errors happening before the HTTP connection
   * is established, e.g during the TLS handshake.
   * @param handler the handler to set
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpServer exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Set the WebSocket handler for the server to <code>wsHandler</code>. If a WebSocket connect handshake is successful a
   * new {@link io.vertx.reactivex.core.http.ServerWebSocket} instance will be created and passed to the handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpServer webSocketHandler(io.vertx.core.Handler<io.vertx.reactivex.core.http.ServerWebSocket> handler) { 
    delegate.webSocketHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)event)));
    return this;
  }

  /**
   * Update the server with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @return a future signaling the update success
   */
  public io.vertx.core.Future<java.lang.Boolean> updateSSLOptions(io.vertx.core.net.ServerSSLOptions options) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.updateSSLOptions(options).map(val -> val);
    return ret;
  }

  /**
   * Update the server with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @return a future signaling the update success
   */
  public io.reactivex.Single<java.lang.Boolean> rxUpdateSSLOptions(io.vertx.core.net.ServerSSLOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.updateSSLOptions(options).onComplete($handler);
    });
  }

  /**
   * <p>Update the server with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The <code>options</code> object is compared using its <code>equals</code> method against the existing options to prevent
   * an update when the objects are equals since loading options can be costly, this can happen for share TCP servers.
   * When object are equals, setting <code>force</code> to <code>true</code> forces the update.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return a future signaling the update success
   */
  public io.vertx.core.Future<java.lang.Boolean> updateSSLOptions(io.vertx.core.net.ServerSSLOptions options, boolean force) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.updateSSLOptions(options, force).map(val -> val);
    return ret;
  }

  /**
   * <p>Update the server with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The <code>options</code> object is compared using its <code>equals</code> method against the existing options to prevent
   * an update when the objects are equals since loading options can be costly, this can happen for share TCP servers.
   * When object are equals, setting <code>force</code> to <code>true</code> forces the update.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return a future signaling the update success
   */
  public io.reactivex.Single<java.lang.Boolean> rxUpdateSSLOptions(io.vertx.core.net.ServerSSLOptions options, boolean force) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.updateSSLOptions(options, force).onComplete($handler);
    });
  }

  /**
   * <p>Update the server with new traffic <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The <code>options</code> object is compared using its <code>equals</code> method against the existing options to prevent
   * an update when the objects are equals since loading options can be costly, this can happen for share TCP servers.
   * When object are equals, setting <code>force</code> to <code>true</code> forces the update.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new traffic shaping options
   * @return a future signaling the update success
   */
  public io.vertx.core.Future<java.lang.Boolean> updateTrafficShapingOptions(io.vertx.core.net.TrafficShapingOptions options) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.updateTrafficShapingOptions(options).map(val -> val);
    return ret;
  }

  /**
   * <p>Update the server with new traffic <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The <code>options</code> object is compared using its <code>equals</code> method against the existing options to prevent
   * an update when the objects are equals since loading options can be costly, this can happen for share TCP servers.
   * When object are equals, setting <code>force</code> to <code>true</code> forces the update.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new traffic shaping options
   * @return a future signaling the update success
   */
  public io.reactivex.Single<java.lang.Boolean> rxUpdateTrafficShapingOptions(io.vertx.core.net.TrafficShapingOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.updateTrafficShapingOptions(options).onComplete($handler);
    });
  }

  /**
   * Tell the server to start listening. The server will listen on the port and host specified in the
   * {@link io.vertx.core.http.HttpServerOptions} that was used when creating the server.
   * <p>
   * The listen happens asynchronously and the server may not be listening until some time after the call has returned.
   * @return a future completed with the listen operation result
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.http.HttpServer> listen() { 
    io.vertx.core.Future<io.vertx.reactivex.core.http.HttpServer> ret = delegate.listen().map(val -> io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)val));
    return ret;
  }

  /**
   * Tell the server to start listening. The server will listen on the port and host specified in the
   * {@link io.vertx.core.http.HttpServerOptions} that was used when creating the server.
   * <p>
   * The listen happens asynchronously and the server may not be listening until some time after the call has returned.
   * @return a future completed with the listen operation result
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.HttpServer> rxListen() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listen().onComplete($handler);
    });
  }

  /**
   * Tell the server to start listening. The server will listen on the port and host specified here,
   * ignoring any value set in the {@link io.vertx.core.http.HttpServerOptions} that was used when creating the server.
   * <p>
   * The listen happens asynchronously and the server may not be listening until some time after the call has returned.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a future completed with the listen operation result
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.http.HttpServer> listen(int port, java.lang.String host) { 
    io.vertx.core.Future<io.vertx.reactivex.core.http.HttpServer> ret = delegate.listen(port, host).map(val -> io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)val));
    return ret;
  }

  /**
   * Tell the server to start listening. The server will listen on the port and host specified here,
   * ignoring any value set in the {@link io.vertx.core.http.HttpServerOptions} that was used when creating the server.
   * <p>
   * The listen happens asynchronously and the server may not be listening until some time after the call has returned.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a future completed with the listen operation result
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.HttpServer> rxListen(int port, java.lang.String host) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listen(port, host).onComplete($handler);
    });
  }

  /**
   * Tell the server to start listening on the given address supplying
   * a handler that will be called when the server is actually
   * listening (or has failed).
   * @param address the address to listen on
   * @return a future completed with the listen operation result
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.http.HttpServer> listen(io.vertx.core.net.SocketAddress address) { 
    io.vertx.core.Future<io.vertx.reactivex.core.http.HttpServer> ret = delegate.listen(address).map(val -> io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)val));
    return ret;
  }

  /**
   * Tell the server to start listening on the given address supplying
   * a handler that will be called when the server is actually
   * listening (or has failed).
   * @param address the address to listen on
   * @return a future completed with the listen operation result
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.HttpServer> rxListen(io.vertx.core.net.SocketAddress address) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listen(address).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#listen} but the server will listen on host "0.0.0.0" and port specified here ignoring
   * any value in the {@link io.vertx.core.http.HttpServerOptions} that was used when creating the server.
   * @param port the port to listen on
   * @return a future completed with the listen operation result
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.http.HttpServer> listen(int port) { 
    io.vertx.core.Future<io.vertx.reactivex.core.http.HttpServer> ret = delegate.listen(port).map(val -> io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)val));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#listen} but the server will listen on host "0.0.0.0" and port specified here ignoring
   * any value in the {@link io.vertx.core.http.HttpServerOptions} that was used when creating the server.
   * @param port the port to listen on
   * @return a future completed with the listen operation result
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.HttpServer> rxListen(int port) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listen(port).onComplete($handler);
    });
  }

  /**
   * Close the server. Any open HTTP connections will be closed.
   * <p>
   * The close happens asynchronously and the server may not be closed until some time after the call has returned.
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Close the server. Any open HTTP connections will be closed.
   * <p>
   * The close happens asynchronously and the server may not be closed until some time after the call has returned.
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * Shutdown with a 30 seconds timeout (<code>shutdown(30, TimeUnit.SECONDS)</code>).
   * @return a future completed when shutdown has completed
   */
  public io.vertx.core.Future<java.lang.Void> shutdown() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown().map(val -> val);
    return ret;
  }

  /**
   * Shutdown with a 30 seconds timeout (<code>shutdown(30, TimeUnit.SECONDS)</code>).
   * @return a future completed when shutdown has completed
   */
  public io.reactivex.Completable rxShutdown() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown().onComplete($handler);
    });
  }

  /**
   * Initiate the server shutdown sequence.
   *
   * <p> Connections are taken out of service and closed when all inflight requests are processed. When all connections are closed
   * the server is closed. When the <code>timeout</code> expires, all unclosed connections are immediately closed.
   *
   * <ul>
   *   <li>HTTP/2 connections will send a go away frame immediately to signal the other side the connection will close</li>
   *   <li>HTTP/1.x server connection will be closed after the current response is sent</li>
   * </ul>
   * @param timeout the amount of time after which all resources are forcibly closed
   * @param unit the of the timeout
   * @return a future notified when the client is closed
   */
  public io.vertx.core.Future<java.lang.Void> shutdown(long timeout, java.util.concurrent.TimeUnit unit) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown(timeout, unit).map(val -> val);
    return ret;
  }

  /**
   * Initiate the server shutdown sequence.
   *
   * <p> Connections are taken out of service and closed when all inflight requests are processed. When all connections are closed
   * the server is closed. When the <code>timeout</code> expires, all unclosed connections are immediately closed.
   *
   * <ul>
   *   <li>HTTP/2 connections will send a go away frame immediately to signal the other side the connection will close</li>
   *   <li>HTTP/1.x server connection will be closed after the current response is sent</li>
   * </ul>
   * @param timeout the amount of time after which all resources are forcibly closed
   * @param unit the of the timeout
   * @return a future notified when the client is closed
   */
  public io.reactivex.Completable rxShutdown(long timeout, java.util.concurrent.TimeUnit unit) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown(timeout, unit).onComplete($handler);
    });
  }

  /**
   * The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
   * signifying an ephemeral port
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  public static HttpServer newInstance(io.vertx.core.http.HttpServer arg) {
    return arg != null ? new HttpServer(arg) : null;
  }

}
