/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.http;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The state of the HTTP request head:
 *
 * <ul>
 *   <li>Method / URI</li>
 *   <li>Headers</li>
 * </ul>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpRequestHead original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.HttpRequestHead.class)
public class HttpRequestHead implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpRequestHead that = (HttpRequestHead) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HttpRequestHead> __TYPE_ARG = new TypeArg<>(    obj -> new HttpRequestHead((io.vertx.core.http.HttpRequestHead) obj),
    HttpRequestHead::getDelegate
  );

  private final io.vertx.core.http.HttpRequestHead delegate;
  
  public HttpRequestHead(io.vertx.core.http.HttpRequestHead delegate) {
    this.delegate = delegate;
  }

  public HttpRequestHead(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpRequestHead)delegate;
  }

  @Override 
  public io.vertx.core.http.HttpRequestHead getDelegate() {
    return delegate;
  }

  /**
   * @return the HTTP method for the request.
   */
  public io.vertx.core.http.HttpMethod method() { 
    io.vertx.core.http.HttpMethod ret = delegate.method();
    return ret;
  }

  /**
   * @return the URI of the request. This is usually a relative URI
   */
  public java.lang.String uri() { 
    java.lang.String ret = delegate.uri();
    return ret;
  }

  /**
   * @return The path part of the uri. For example <code>/somepath/somemorepath/someresource.foo</code>
   */
  public java.lang.String path() { 
    java.lang.String ret = delegate.path();
    return ret;
  }

  /**
   * @return the query part of the uri. For example <code>someparam=32&amp;someotherparam=x</code>
   */
  public java.lang.String query() { 
    java.lang.String ret = delegate.query();
    return ret;
  }

  /**
   * @return the headers
   */
  public io.vertx.core.MultiMap headers() { 
    io.vertx.core.MultiMap ret = delegate.headers();
    return ret;
  }

  /**
   * Return the first header value with the specified name
   * @param headerName the header name
   * @return the header value
   */
  public java.lang.String getHeader(java.lang.String headerName) { 
    java.lang.String ret = delegate.getHeader(headerName);
    return ret;
  }

  /**
   * Return the first header value with the specified name
   * @param headerName the header name
   * @return the header value
   */
  public java.lang.String getHeader(java.lang.CharSequence headerName) { 
    java.lang.String ret = delegate.getHeader(headerName);
    return ret;
  }

  public static HttpRequestHead newInstance(io.vertx.core.http.HttpRequestHead arg) {
    return arg != null ? new HttpRequestHead(arg) : null;
  }

}
