/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.http;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents an HTTP connection.
 * <p/>
 * HTTP/1.x connection provides a limited implementation, the following methods are implemented:
 * <ul>
 *   <li>{@link io.vertx.reactivex.core.http.HttpConnection#close}</li>
 *   <li>{@link io.vertx.reactivex.core.http.HttpConnection#closeHandler}</li>
 *   <li>{@link io.vertx.reactivex.core.http.HttpConnection#exceptionHandler}</li>
 * </ul>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpConnection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.HttpConnection.class)
public class HttpConnection implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpConnection that = (HttpConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HttpConnection> __TYPE_ARG = new TypeArg<>(    obj -> new HttpConnection((io.vertx.core.http.HttpConnection) obj),
    HttpConnection::getDelegate
  );

  private final io.vertx.core.http.HttpConnection delegate;
  
  public HttpConnection(io.vertx.core.http.HttpConnection delegate) {
    this.delegate = delegate;
  }

  public HttpConnection(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpConnection)delegate;
  }

  @Override 
  public io.vertx.core.http.HttpConnection getDelegate() {
    return delegate;
  }


  /**
   * @return the current connection window size or <code>-1</code> for HTTP/1.x
   */
  public int getWindowSize() { 
    int ret = delegate.getWindowSize();
    return ret;
  }

  /**
   * Update the current connection wide window size to a new size.
   * <p/>
   * Increasing this value, gives better performance when several data streams are multiplexed
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param windowSize the new window size
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpConnection setWindowSize(int windowSize) { 
    delegate.setWindowSize(windowSize);
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpConnection#goAway} with a last stream id <code>-1</code> which means to disallow any new stream creation.
   * @param errorCode 
   * @return 
   */
  public io.vertx.reactivex.core.http.HttpConnection goAway(long errorCode) { 
    delegate.goAway(errorCode);
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpConnection#goAway} with no buffer.
   * @param errorCode 
   * @param lastStreamId 
   * @return 
   */
  public io.vertx.reactivex.core.http.HttpConnection goAway(long errorCode, int lastStreamId) { 
    delegate.goAway(errorCode, lastStreamId);
    return this;
  }

  /**
   * Send a go away frame to the remote endpoint of the connection.
   * <p/>
   * <ul>
   *   <li>a  frame is sent to the to the remote endpoint with the <code>errorCode</code> and <code>debugData</code></li>
   *   <li>any stream created after the stream identified by <code>lastStreamId</code> will be closed</li>
   *   <li>for an  is different than <code>0</code> when all the remaining streams are closed this connection will be closed automatically</li>
   * </ul>
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param errorCode the  error code
   * @param lastStreamId the last stream id
   * @param debugData additional debug data sent to the remote endpoint
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpConnection goAway(long errorCode, int lastStreamId, io.vertx.core.buffer.Buffer debugData) { 
    delegate.goAway(errorCode, lastStreamId, debugData);
    return this;
  }

  /**
   * Set an handler called when a  frame is received.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpConnection goAwayHandler(io.vertx.core.Handler<io.vertx.core.http.GoAway> handler) { 
    delegate.goAwayHandler(handler);
    return this;
  }

  /**
   * Set a <code>handler</code> notified when the HTTP connection is shutdown: the client or server will close the connection
   * within a certain amount of time. This gives the opportunity to the <code>handler</code> to close the current requests in progress
   * gracefully before the HTTP connection is forcefully closed.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpConnection shutdownHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.shutdownHandler(handler);
    return this;
  }

  /**
   * Shutdown with a 30 seconds timeout (<code>shutdown(30, TimeUnit.SECONDS)</code>).
   * @return a future completed when shutdown has completed
   */
  public io.vertx.core.Future<java.lang.Void> shutdown() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown().map(val -> val);
    return ret;
  }

  /**
   * Shutdown with a 30 seconds timeout (<code>shutdown(30, TimeUnit.SECONDS)</code>).
   * @return a future completed when shutdown has completed
   */
  public io.reactivex.Completable rxShutdown() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown().onComplete($handler);
    });
  }

  /**
   * Initiate a graceful connection shutdown, the connection is taken out of service and closed when all the inflight requests
   * are processed, otherwise after a <code>timeout</code> the connection will be closed. Client connection are immediately removed
   * from the pool.
   *
   * <ul>
   *   <li>HTTP/2 connections will send a go away frame immediately to signal the other side the connection will close.</li>
   *   <li>HTTP/1.x connection will be closed.</li>
   * </ul>
   * @param timeout the amount of time after which all resources are forcibly closed
   * @param unit the of the timeout
   * @return a future completed when shutdown has completed
   */
  public io.vertx.core.Future<java.lang.Void> shutdown(long timeout, java.util.concurrent.TimeUnit unit) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown(timeout, unit).map(val -> val);
    return ret;
  }

  /**
   * Initiate a graceful connection shutdown, the connection is taken out of service and closed when all the inflight requests
   * are processed, otherwise after a <code>timeout</code> the connection will be closed. Client connection are immediately removed
   * from the pool.
   *
   * <ul>
   *   <li>HTTP/2 connections will send a go away frame immediately to signal the other side the connection will close.</li>
   *   <li>HTTP/1.x connection will be closed.</li>
   * </ul>
   * @param timeout the amount of time after which all resources are forcibly closed
   * @param unit the of the timeout
   * @return a future completed when shutdown has completed
   */
  public io.reactivex.Completable rxShutdown(long timeout, java.util.concurrent.TimeUnit unit) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown(timeout, unit).onComplete($handler);
    });
  }

  /**
   * Set a close handler. The handler will get notified when the connection is closed.
   * @param handler the handler to be notified
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpConnection closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Close immediately (<code>shutdown(0, TimeUnit.SECONDS</code>).
   * @return a future notified when the client is closed
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Close immediately (<code>shutdown(0, TimeUnit.SECONDS</code>).
   * @return a future notified when the client is closed
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * @return the latest server settings acknowledged by the remote endpoint - this is not implemented for HTTP/1.x
   */
  public io.vertx.core.http.Http2Settings settings() { 
    io.vertx.core.http.Http2Settings ret = delegate.settings();
    return ret;
  }

  /**
   * Send to the remote endpoint an update of this endpoint settings
   * <p/>
   * The <code>completionHandler</code> will be notified when the remote endpoint has acknowledged the settings.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param settings the new settings
   * @return a future completed when the settings have been acknowledged by the remote endpoint
   */
  public io.vertx.core.Future<java.lang.Void> updateSettings(io.vertx.core.http.Http2Settings settings) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.updateSettings(settings).map(val -> val);
    return ret;
  }

  /**
   * Send to the remote endpoint an update of this endpoint settings
   * <p/>
   * The <code>completionHandler</code> will be notified when the remote endpoint has acknowledged the settings.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param settings the new settings
   * @return a future completed when the settings have been acknowledged by the remote endpoint
   */
  public io.reactivex.Completable rxUpdateSettings(io.vertx.core.http.Http2Settings settings) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.updateSettings(settings).onComplete($handler);
    });
  }

  /**
   * @return the current remote endpoint settings for this connection - this is not implemented for HTTP/1.x
   */
  public io.vertx.core.http.Http2Settings remoteSettings() { 
    io.vertx.core.http.Http2Settings ret = delegate.remoteSettings();
    return ret;
  }

  /**
   * Set an handler that is called when remote endpoint {@link io.vertx.core.http.Http2Settings} are updated.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param handler the handler for remote endpoint settings
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpConnection remoteSettingsHandler(io.vertx.core.Handler<io.vertx.core.http.Http2Settings> handler) { 
    delegate.remoteSettingsHandler(handler);
    return this;
  }

  /**
   * Send a  frame to the remote endpoint.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param data the 8 bytes data of the frame
   * @return a future notified with the pong reply or the failure
   */
  public io.vertx.core.Future<io.vertx.core.buffer.Buffer> ping(io.vertx.core.buffer.Buffer data) { 
    io.vertx.core.Future<io.vertx.core.buffer.Buffer> ret = delegate.ping(data).map(val -> val);
    return ret;
  }

  /**
   * Send a  frame to the remote endpoint.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param data the 8 bytes data of the frame
   * @return a future notified with the pong reply or the failure
   */
  public io.reactivex.Single<io.vertx.core.buffer.Buffer> rxPing(io.vertx.core.buffer.Buffer data) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.ping(data).onComplete($handler);
    });
  }

  /**
   * Set an handler notified when a  frame is received from the remote endpoint.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * @param handler the handler to be called when a  is received
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpConnection pingHandler(io.vertx.core.Handler<io.vertx.core.buffer.Buffer> handler) { 
    delegate.pingHandler(handler);
    return this;
  }

  /**
   * Set an handler called when a connection error happens
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpConnection exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket). If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the actual connecting client.
   */
  public io.vertx.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.core.net.SocketAddress ret = delegate.remoteAddress();
    cached_0 = ret;
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpConnection#remoteAddress} but returns the proxy remote address when <code>real</code> is <code>true</code>
   * @param real 
   * @return 
   */
  public io.vertx.core.net.SocketAddress remoteAddress(boolean real) { 
    io.vertx.core.net.SocketAddress ret = delegate.remoteAddress(real);
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket) If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the proxy.
   */
  public io.vertx.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.core.net.SocketAddress ret = delegate.localAddress();
    cached_1 = ret;
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpConnection#localAddress} ()} but returns the server local address when <code>real</code> is <code>true</code>
   * @param real 
   * @return 
   */
  public io.vertx.core.net.SocketAddress localAddress(boolean real) { 
    io.vertx.core.net.SocketAddress ret = delegate.localAddress(real);
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.reactivex.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * Returns the SNI server name presented during the SSL handshake by the client.
   * @return the indicated server name
   */
  public java.lang.String indicatedServerName() { 
    java.lang.String ret = delegate.indicatedServerName();
    return ret;
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public javax.net.ssl.SSLSession sslSession() { 
    javax.net.ssl.SSLSession ret = delegate.sslSession();
    return ret;
  }

  private io.vertx.core.net.SocketAddress cached_0;
  private io.vertx.core.net.SocketAddress cached_1;
  public static HttpConnection newInstance(io.vertx.core.http.HttpConnection arg) {
    return arg != null ? new HttpConnection(arg) : null;
  }

}
