/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.http;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents an HTTP client connection.
 * <p>
 * You can use this connection to create requests to the connected server.
 * <p>
 * Depending on the nature of the connection, requests might just be sent to the server or might be queued until
 * a connection request is available.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpClientConnection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.HttpClientConnection.class)
public class HttpClientConnection extends io.vertx.reactivex.core.http.HttpConnection implements RxDelegate, io.vertx.reactivex.core.http.HttpClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpClientConnection that = (HttpClientConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HttpClientConnection> __TYPE_ARG = new TypeArg<>(    obj -> new HttpClientConnection((io.vertx.core.http.HttpClientConnection) obj),
    HttpClientConnection::getDelegate
  );

  private final io.vertx.core.http.HttpClientConnection delegate;
  
  public HttpClientConnection(io.vertx.core.http.HttpClientConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public HttpClientConnection(Object delegate) {
    super((io.vertx.core.http.HttpClientConnection)delegate);
    this.delegate = (io.vertx.core.http.HttpClientConnection)delegate;
  }

  @Override 
  public io.vertx.core.http.HttpClientConnection getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.core.http.HttpClientRequest> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.http.HttpClientRequest>(o1 -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.http.HttpClientRequest> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.core.http.HttpClientRequest>(o1 -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.http.HttpClientRequest> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.core.http.HttpClientRequest>(o1 -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.http.HttpClientRequest> TYPE_ARG_3 = new TypeArg<io.vertx.reactivex.core.http.HttpClientRequest>(o1 -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.http.HttpClientRequest> TYPE_ARG_4 = new TypeArg<io.vertx.reactivex.core.http.HttpClientRequest>(o1 -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)o1), o1 -> o1.getDelegate());

  /**
   * Create an HTTP request to send to the server with the default host and port of the client.
   * @return a future notified when the request is ready to be sent
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> request() { 
    io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> ret = delegate.request().map(val -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)val));
    return ret;
  }

  /**
   * Create an HTTP request to send to the server with the default host and port of the client.
   * @return a future notified when the request is ready to be sent
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.HttpClientRequest> rxRequest() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.request().onComplete($handler);
    });
  }

  /**
   * Create an HTTP request to send to the server.
   * @param options the request options
   * @return a future notified when the request is ready to be sent
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> request(io.vertx.core.http.RequestOptions options) { 
    io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> ret = delegate.request(options).map(val -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)val));
    return ret;
  }

  /**
   * Create an HTTP request to send to the server.
   * @param options the request options
   * @return a future notified when the request is ready to be sent
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.HttpClientRequest> rxRequest(io.vertx.core.http.RequestOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.request(options).onComplete($handler);
    });
  }

  /**
   * Create an HTTP request to send to the server at the <code>host</code> and <code>port</code>.
   * @param method the HTTP method
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return a future notified when the request is ready to be sent
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> request(io.vertx.core.http.HttpMethod method, int port, java.lang.String host, java.lang.String requestURI) { 
    io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> ret = delegate.request(method, port, host, requestURI).map(val -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)val));
    return ret;
  }

  /**
   * Create an HTTP request to send to the server at the <code>host</code> and <code>port</code>.
   * @param method the HTTP method
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return a future notified when the request is ready to be sent
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.HttpClientRequest> rxRequest(io.vertx.core.http.HttpMethod method, int port, java.lang.String host, java.lang.String requestURI) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.request(method, port, host, requestURI).onComplete($handler);
    });
  }

  /**
   * Create an HTTP request to send to the server at the <code>host</code> and default port.
   * @param method the HTTP method
   * @param host the host
   * @param requestURI the relative URI
   * @return a future notified when the request is ready to be sent
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> request(io.vertx.core.http.HttpMethod method, java.lang.String host, java.lang.String requestURI) { 
    io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> ret = delegate.request(method, host, requestURI).map(val -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)val));
    return ret;
  }

  /**
   * Create an HTTP request to send to the server at the <code>host</code> and default port.
   * @param method the HTTP method
   * @param host the host
   * @param requestURI the relative URI
   * @return a future notified when the request is ready to be sent
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.HttpClientRequest> rxRequest(io.vertx.core.http.HttpMethod method, java.lang.String host, java.lang.String requestURI) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.request(method, host, requestURI).onComplete($handler);
    });
  }

  /**
   * Create an HTTP request to send to the server at the default host and port.
   * @param method the HTTP method
   * @param requestURI the relative URI
   * @return a future notified when the request is ready to be sent
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> request(io.vertx.core.http.HttpMethod method, java.lang.String requestURI) { 
    io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> ret = delegate.request(method, requestURI).map(val -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)val));
    return ret;
  }

  /**
   * Create an HTTP request to send to the server at the default host and port.
   * @param method the HTTP method
   * @param requestURI the relative URI
   * @return a future notified when the request is ready to be sent
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.HttpClientRequest> rxRequest(io.vertx.core.http.HttpMethod method, java.lang.String requestURI) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.request(method, requestURI).onComplete($handler);
    });
  }

  /**
   * @return the number of active request/response (streams)
   */
  public long activeStreams() { 
    long ret = delegate.activeStreams();
    return ret;
  }

  /**
   * @return the max number of concurrent active streams this connection can handle
   */
  public long maxActiveStreams() { 
    long ret = delegate.maxActiveStreams();
    return ret;
  }

  public io.vertx.core.Future<java.lang.Void> shutdown() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown().map(val -> val);
    return ret;
  }

  public io.reactivex.Completable rxShutdown() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown().onComplete($handler);
    });
  }

  public io.vertx.core.Future<java.lang.Void> shutdown(long timeout, java.util.concurrent.TimeUnit unit) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown(timeout, unit).map(val -> val);
    return ret;
  }

  public io.reactivex.Completable rxShutdown(long timeout, java.util.concurrent.TimeUnit unit) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown(timeout, unit).onComplete($handler);
    });
  }

  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  public static HttpClientConnection newInstance(io.vertx.core.http.HttpClientConnection arg) {
    return arg != null ? new HttpClientConnection(arg) : null;
  }

}
