/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.http;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An asynchronous HTTP client.
 * <p>
 * It allows you to make requests to HTTP servers, and a single client can make requests to any server.
 * <p>
 * The client can also pool HTTP connections.
 * <p>
 * For pooling to occur, keep-alive must be true on the {@link io.vertx.core.http.HttpClientOptions} (default is true).
 * In this case connections will be pooled and re-used if there are pending HTTP requests waiting to get a connection,
 * otherwise they will be closed.
 * <p>
 * This gives the benefits of keep alive when the client is loaded but means we don't keep connections hanging around
 * unnecessarily when there would be no benefits anyway.
 * <p>
 * The client also supports pipe-lining of requests. Pipe-lining means another request is sent on the same connection
 * before the response from the preceding one has returned. Pipe-lining is not appropriate for all requests.
 * <p>
 * To enable pipe-lining, it must be enabled on the {@link io.vertx.core.http.HttpClientOptions} (default is false).
 * <p>
 * When pipe-lining is enabled the connection will be automatically closed when all in-flight responses have returned
 * and there are no outstanding pending requests to write.
 * <p>
 * The client is designed to be reused between requests.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpClientAgent original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.HttpClientAgent.class)
public class HttpClientAgent implements RxDelegate, io.vertx.reactivex.core.http.HttpClient, io.vertx.reactivex.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpClientAgent that = (HttpClientAgent) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HttpClientAgent> __TYPE_ARG = new TypeArg<>(    obj -> new HttpClientAgent((io.vertx.core.http.HttpClientAgent) obj),
    HttpClientAgent::getDelegate
  );

  private final io.vertx.core.http.HttpClientAgent delegate;
  
  public HttpClientAgent(io.vertx.core.http.HttpClientAgent delegate) {
    this.delegate = delegate;
  }

  public HttpClientAgent(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpClientAgent)delegate;
  }

  @Override 
  public io.vertx.core.http.HttpClientAgent getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.core.http.HttpClientRequest> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.http.HttpClientRequest>(o1 -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.http.HttpClientRequest> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.core.http.HttpClientRequest>(o1 -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.http.HttpClientRequest> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.core.http.HttpClientRequest>(o1 -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.http.HttpClientRequest> TYPE_ARG_3 = new TypeArg<io.vertx.reactivex.core.http.HttpClientRequest>(o1 -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.http.HttpClientRequest> TYPE_ARG_4 = new TypeArg<io.vertx.reactivex.core.http.HttpClientRequest>(o1 -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.http.HttpClientConnection> TYPE_ARG_5 = new TypeArg<io.vertx.reactivex.core.http.HttpClientConnection>(o1 -> io.vertx.reactivex.core.http.HttpClientConnection.newInstance((io.vertx.core.http.HttpClientConnection)o1), o1 -> o1.getDelegate());

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Create an HTTP request to send to the server with the default host and port of the client.
   * @return a future notified when the request is ready to be sent
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> request() { 
    io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> ret = delegate.request().map(val -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)val));
    return ret;
  }

  /**
   * Create an HTTP request to send to the server with the default host and port of the client.
   * @return a future notified when the request is ready to be sent
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.HttpClientRequest> rxRequest() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.request().onComplete($handler);
    });
  }

  /**
   * Create an HTTP request to send to the server.
   * @param options the request options
   * @return a future notified when the request is ready to be sent
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> request(io.vertx.core.http.RequestOptions options) { 
    io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> ret = delegate.request(options).map(val -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)val));
    return ret;
  }

  /**
   * Create an HTTP request to send to the server.
   * @param options the request options
   * @return a future notified when the request is ready to be sent
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.HttpClientRequest> rxRequest(io.vertx.core.http.RequestOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.request(options).onComplete($handler);
    });
  }

  /**
   * Create an HTTP request to send to the server at the <code>host</code> and <code>port</code>.
   * @param method the HTTP method
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return a future notified when the request is ready to be sent
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> request(io.vertx.core.http.HttpMethod method, int port, java.lang.String host, java.lang.String requestURI) { 
    io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> ret = delegate.request(method, port, host, requestURI).map(val -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)val));
    return ret;
  }

  /**
   * Create an HTTP request to send to the server at the <code>host</code> and <code>port</code>.
   * @param method the HTTP method
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return a future notified when the request is ready to be sent
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.HttpClientRequest> rxRequest(io.vertx.core.http.HttpMethod method, int port, java.lang.String host, java.lang.String requestURI) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.request(method, port, host, requestURI).onComplete($handler);
    });
  }

  /**
   * Create an HTTP request to send to the server at the <code>host</code> and default port.
   * @param method the HTTP method
   * @param host the host
   * @param requestURI the relative URI
   * @return a future notified when the request is ready to be sent
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> request(io.vertx.core.http.HttpMethod method, java.lang.String host, java.lang.String requestURI) { 
    io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> ret = delegate.request(method, host, requestURI).map(val -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)val));
    return ret;
  }

  /**
   * Create an HTTP request to send to the server at the <code>host</code> and default port.
   * @param method the HTTP method
   * @param host the host
   * @param requestURI the relative URI
   * @return a future notified when the request is ready to be sent
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.HttpClientRequest> rxRequest(io.vertx.core.http.HttpMethod method, java.lang.String host, java.lang.String requestURI) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.request(method, host, requestURI).onComplete($handler);
    });
  }

  /**
   * Create an HTTP request to send to the server at the default host and port.
   * @param method the HTTP method
   * @param requestURI the relative URI
   * @return a future notified when the request is ready to be sent
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> request(io.vertx.core.http.HttpMethod method, java.lang.String requestURI) { 
    io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientRequest> ret = delegate.request(method, requestURI).map(val -> io.vertx.reactivex.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)val));
    return ret;
  }

  /**
   * Create an HTTP request to send to the server at the default host and port.
   * @param method the HTTP method
   * @param requestURI the relative URI
   * @return a future notified when the request is ready to be sent
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.HttpClientRequest> rxRequest(io.vertx.core.http.HttpMethod method, java.lang.String requestURI) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.request(method, requestURI).onComplete($handler);
    });
  }

  /**
   * Shutdown with a 30 seconds timeout (<code>shutdown(30, TimeUnit.SECONDS)</code>).
   * @return a future completed when shutdown has completed
   */
  public io.vertx.core.Future<java.lang.Void> shutdown() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown().map(val -> val);
    return ret;
  }

  /**
   * Shutdown with a 30 seconds timeout (<code>shutdown(30, TimeUnit.SECONDS)</code>).
   * @return a future completed when shutdown has completed
   */
  public io.reactivex.Completable rxShutdown() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown().onComplete($handler);
    });
  }

  /**
   * Close immediately (<code>shutdown(0, TimeUnit.SECONDS</code>).
   * @return a future notified when the client is closed
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Close immediately (<code>shutdown(0, TimeUnit.SECONDS</code>).
   * @return a future notified when the client is closed
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * Initiate the client shutdown sequence.
   *
   * <p> Connections are taken out of service and closed when all inflight requests are processed, client connection are
   * immediately removed from the pool. When all connections are closed the client is closed. When the <code>timeout</code>
   * expires, all unclosed connections are immediately closed.
   *
   * <ul>
   *   <li>HTTP/2 connections will send a go away frame immediately to signal the other side the connection will close</li>
   *   <li>HTTP/1.x client connection will be closed after the current response is received</li>
   * </ul>
   * @param timeout the amount of time after which all resources are forcibly closed
   * @param unit the of the timeout
   * @return a future notified when the client is closed
   */
  public io.vertx.core.Future<java.lang.Void> shutdown(long timeout, java.util.concurrent.TimeUnit unit) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.shutdown(timeout, unit).map(val -> val);
    return ret;
  }

  /**
   * Initiate the client shutdown sequence.
   *
   * <p> Connections are taken out of service and closed when all inflight requests are processed, client connection are
   * immediately removed from the pool. When all connections are closed the client is closed. When the <code>timeout</code>
   * expires, all unclosed connections are immediately closed.
   *
   * <ul>
   *   <li>HTTP/2 connections will send a go away frame immediately to signal the other side the connection will close</li>
   *   <li>HTTP/1.x client connection will be closed after the current response is received</li>
   * </ul>
   * @param timeout the amount of time after which all resources are forcibly closed
   * @param unit the of the timeout
   * @return a future notified when the client is closed
   */
  public io.reactivex.Completable rxShutdown(long timeout, java.util.concurrent.TimeUnit unit) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.shutdown(timeout, unit).onComplete($handler);
    });
  }

  /**
   * <p>Update the client with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @return a future signaling the update success
   */
  public io.vertx.core.Future<java.lang.Boolean> updateSSLOptions(io.vertx.core.net.ClientSSLOptions options) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.updateSSLOptions(options).map(val -> val);
    return ret;
  }

  /**
   * <p>Update the client with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @return a future signaling the update success
   */
  public io.reactivex.Single<java.lang.Boolean> rxUpdateSSLOptions(io.vertx.core.net.ClientSSLOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.updateSSLOptions(options).onComplete($handler);
    });
  }

  /**
   * <p>Update the client with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The <code>options</code> object is compared using its <code>equals</code> method against the existing options to prevent
   * an update when the objects are equals since loading options can be costly, this can happen for share TCP servers.
   * When object are equals, setting <code>force</code> to <code>true</code> forces the update.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return a future signaling the update success
   */
  public io.vertx.core.Future<java.lang.Boolean> updateSSLOptions(io.vertx.core.net.ClientSSLOptions options, boolean force) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.updateSSLOptions(options, force).map(val -> val);
    return ret;
  }

  /**
   * <p>Update the client with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The <code>options</code> object is compared using its <code>equals</code> method against the existing options to prevent
   * an update when the objects are equals since loading options can be costly, this can happen for share TCP servers.
   * When object are equals, setting <code>force</code> to <code>true</code> forces the update.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return a future signaling the update success
   */
  public io.reactivex.Single<java.lang.Boolean> rxUpdateSSLOptions(io.vertx.core.net.ClientSSLOptions options, boolean force) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.updateSSLOptions(options, force).onComplete($handler);
    });
  }

  /**
   * Connect to a remote HTTP server with the specific <code>options</code>, the connection is un-pooled and the management
   * of the connection is left to the user.
   * @param options the server connect options
   * @return a future notified when the connection is available
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientConnection> connect(io.vertx.core.http.HttpConnectOptions options) { 
    io.vertx.core.Future<io.vertx.reactivex.core.http.HttpClientConnection> ret = delegate.connect(options).map(val -> io.vertx.reactivex.core.http.HttpClientConnection.newInstance((io.vertx.core.http.HttpClientConnection)val));
    return ret;
  }

  /**
   * Connect to a remote HTTP server with the specific <code>options</code>, the connection is un-pooled and the management
   * of the connection is left to the user.
   * @param options the server connect options
   * @return a future notified when the connection is available
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.HttpClientConnection> rxConnect(io.vertx.core.http.HttpConnectOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.connect(options).onComplete($handler);
    });
  }

  public static HttpClientAgent newInstance(io.vertx.core.http.HttpClientAgent arg) {
    return arg != null ? new HttpClientAgent(arg) : null;
  }

}
