/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.file;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a file on the file-system which can be read from, or written to asynchronously.
 * <p>
 * This class also implements {@link io.vertx.reactivex.core.streams.ReadStream} and
 * {@link io.vertx.reactivex.core.streams.WriteStream}. This allows the data to be piped to and from
 * other streams, e.g. an {@link io.vertx.reactivex.core.http.HttpClientRequest} instance,
 * using the {@link io.vertx.reactivex.core.streams.Pipe} class
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.file.AsyncFile original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.file.AsyncFile.class)
public class AsyncFile implements RxDelegate, io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.buffer.Buffer>, io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AsyncFile that = (AsyncFile) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AsyncFile> __TYPE_ARG = new TypeArg<>(    obj -> new AsyncFile((io.vertx.core.file.AsyncFile) obj),
    AsyncFile::getDelegate
  );

  private final io.vertx.core.file.AsyncFile delegate;
  
  public AsyncFile(io.vertx.core.file.AsyncFile delegate) {
    this.delegate = delegate;
  }

  public AsyncFile(Object delegate) {
    this.delegate = (io.vertx.core.file.AsyncFile)delegate;
  }

  @Override 
  public io.vertx.core.file.AsyncFile getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<io.vertx.core.buffer.Buffer> observable;
  private io.reactivex.Flowable<io.vertx.core.buffer.Buffer> flowable;

  public synchronized io.reactivex.Observable<io.vertx.core.buffer.Buffer> toObservable() {
    if (observable == null) {
      observable = ObservableHelper.toObservable(this.getDelegate());
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<io.vertx.core.buffer.Buffer> toFlowable() {
    if (flowable == null) {
      flowable = FlowableHelper.toFlowable(this.getDelegate());
    }
    return flowable;
  }

  private WriteStreamObserver<io.vertx.core.buffer.Buffer> observer;
  private WriteStreamSubscriber<io.vertx.core.buffer.Buffer> subscriber;

  public synchronized WriteStreamObserver<io.vertx.core.buffer.Buffer> toObserver() {
    if (observer == null) {
      observer = RxHelper.toObserver(getDelegate());
    }
    return observer;
  }

  public synchronized WriteStreamSubscriber<io.vertx.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      subscriber = RxHelper.toSubscriber(getDelegate());
    }
    return subscriber;
  }

  private static final TypeArg<io.vertx.reactivex.core.file.AsyncFileLock> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.file.AsyncFileLock>(o1 -> io.vertx.reactivex.core.file.AsyncFileLock.newInstance((io.vertx.core.file.AsyncFileLock)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.file.AsyncFileLock> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.core.file.AsyncFileLock>(o1 -> io.vertx.reactivex.core.file.AsyncFileLock.newInstance((io.vertx.core.file.AsyncFileLock)o1), o1 -> o1.getDelegate());

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<io.vertx.core.buffer.Buffer> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TypeArg.unknown());
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.vertx.core.Future<java.lang.Void> pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.buffer.Buffer> dst) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.pipeTo(dst.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.reactivex.Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.buffer.Buffer> dst) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.pipeTo(dst).onComplete($handler);
    });
  }

  /**
   * Write some data to the stream.
   *
   * <p> The data is usually put on an internal write queue, and the write actually happens
   * asynchronously. To avoid running out of memory by putting too much on the write queue,
   * check the {@link io.vertx.reactivex.core.streams.WriteStream#writeQueueFull} method before writing. This is done automatically if
   * using a .
   *
   * <p> When the <code>data</code> is moved from the queue to the actual medium, the returned
   *  will be completed with the write result, e.g the future is succeeded
   * when a server HTTP response buffer is written to the socket and failed if the remote
   * client has closed the socket while the data was still pending for write.
   * @param data the data to write
   * @return a future completed with the write result
   */
  public io.vertx.core.Future<java.lang.Void> write(io.vertx.core.buffer.Buffer data) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.write(data).map(val -> val);
    return ret;
  }

  /**
   * Write some data to the stream.
   *
   * <p> The data is usually put on an internal write queue, and the write actually happens
   * asynchronously. To avoid running out of memory by putting too much on the write queue,
   * check the {@link io.vertx.reactivex.core.streams.WriteStream#writeQueueFull} method before writing. This is done automatically if
   * using a .
   *
   * <p> When the <code>data</code> is moved from the queue to the actual medium, the returned
   *  will be completed with the write result, e.g the future is succeeded
   * when a server HTTP response buffer is written to the socket and failed if the remote
   * client has closed the socket while the data was still pending for write.
   * @param data the data to write
   * @return a future completed with the write result
   */
  public io.reactivex.Completable rxWrite(io.vertx.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.write(data).onComplete($handler);
    });
  }

  /**
   * Ends the stream.
   * <p>
   * Once the stream has ended, it cannot be used any more.
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> end() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.end().map(val -> val);
    return ret;
  }

  /**
   * Ends the stream.
   * <p>
   * Once the stream has ended, it cannot be used any more.
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxEnd() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.end().onComplete($handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but writes some data to the stream before ending.
   * @param data the data to write
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> end(io.vertx.core.buffer.Buffer data) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.end(data).map(val -> val);
    return ret;
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but writes some data to the stream before ending.
   * @param data the data to write
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxEnd(io.vertx.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.end(data).onComplete($handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.reactivex.core.file.AsyncFile#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  public io.vertx.reactivex.core.file.AsyncFile handler(io.vertx.core.Handler<io.vertx.core.buffer.Buffer> handler) { 
    delegate.handler(handler);
    return this;
  }

  public io.vertx.reactivex.core.file.AsyncFile pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.core.file.AsyncFile resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.core.file.AsyncFile endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.reactivex.core.file.AsyncFile setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public io.vertx.reactivex.core.file.AsyncFile drainHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * Set an exception handler on the read stream and on the write stream.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.file.AsyncFile exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.core.file.AsyncFile fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * Close the file. The actual close happens asynchronously.
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Close the file. The actual close happens asynchronously.
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * Write a {@link io.vertx.core.buffer.Buffer} to the file at position <code>position</code> in the file, asynchronously.
   * <p>
   * If <code>position</code> lies outside of the current size
   * of the file, the file will be enlarged to encompass it.
   * <p>
   * When multiple writes are invoked on the same file
   * there are no guarantees as to order in which those writes actually occur
   * @param buffer the buffer to write
   * @param position the position in the file to write it at
   * @return a future notified when the write is complete
   */
  public io.vertx.core.Future<java.lang.Void> write(io.vertx.core.buffer.Buffer buffer, long position) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.write(buffer, position).map(val -> val);
    return ret;
  }

  /**
   * Write a {@link io.vertx.core.buffer.Buffer} to the file at position <code>position</code> in the file, asynchronously.
   * <p>
   * If <code>position</code> lies outside of the current size
   * of the file, the file will be enlarged to encompass it.
   * <p>
   * When multiple writes are invoked on the same file
   * there are no guarantees as to order in which those writes actually occur
   * @param buffer the buffer to write
   * @param position the position in the file to write it at
   * @return a future notified when the write is complete
   */
  public io.reactivex.Completable rxWrite(io.vertx.core.buffer.Buffer buffer, long position) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.write(buffer, position).onComplete($handler);
    });
  }

  /**
   * Reads <code>length</code> bytes of data from the file at position <code>position</code> in the file, asynchronously.
   * <p>
   * The read data will be written into the specified <code>Buffer buffer</code> at position <code>offset</code>.
   * <p>
   * If data is read past the end of the file then zero bytes will be read.<p>
   * When multiple reads are invoked on the same file there are no guarantees as to order in which those reads actually occur.
   * @param buffer the buffer to read into
   * @param offset the offset into the buffer where the data will be read
   * @param position the position in the file where to start reading
   * @param length the number of bytes to read
   * @return a future notified when the write is complete
   */
  public io.vertx.core.Future<io.vertx.core.buffer.Buffer> read(io.vertx.core.buffer.Buffer buffer, int offset, long position, int length) { 
    io.vertx.core.Future<io.vertx.core.buffer.Buffer> ret = delegate.read(buffer, offset, position, length).map(val -> val);
    return ret;
  }

  /**
   * Reads <code>length</code> bytes of data from the file at position <code>position</code> in the file, asynchronously.
   * <p>
   * The read data will be written into the specified <code>Buffer buffer</code> at position <code>offset</code>.
   * <p>
   * If data is read past the end of the file then zero bytes will be read.<p>
   * When multiple reads are invoked on the same file there are no guarantees as to order in which those reads actually occur.
   * @param buffer the buffer to read into
   * @param offset the offset into the buffer where the data will be read
   * @param position the position in the file where to start reading
   * @param length the number of bytes to read
   * @return a future notified when the write is complete
   */
  public io.reactivex.Single<io.vertx.core.buffer.Buffer> rxRead(io.vertx.core.buffer.Buffer buffer, int offset, long position, int length) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.read(buffer, offset, position, length).onComplete($handler);
    });
  }

  /**
   * Flush any writes made to this file to underlying persistent storage.
   * <p>
   * If the file was opened with <code>flush</code> set to <code>true</code> then calling this method will have no effect.
   * <p>
   * The actual flush will happen asynchronously.
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> flush() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.flush().map(val -> val);
    return ret;
  }

  /**
   * Flush any writes made to this file to underlying persistent storage.
   * <p>
   * If the file was opened with <code>flush</code> set to <code>true</code> then calling this method will have no effect.
   * <p>
   * The actual flush will happen asynchronously.
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxFlush() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.flush().onComplete($handler);
    });
  }

  /**
   * Sets the position from which data will be read from when using the file as a {@link io.vertx.reactivex.core.streams.ReadStream}.
   * @param readPos the position in the file
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.file.AsyncFile setReadPos(long readPos) { 
    delegate.setReadPos(readPos);
    return this;
  }

  /**
   * Sets the number of bytes that will be read when using the file as a {@link io.vertx.reactivex.core.streams.ReadStream}.
   * @param readLength the bytes that will be read from the file
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.file.AsyncFile setReadLength(long readLength) { 
    delegate.setReadLength(readLength);
    return this;
  }

  /**
   * @return the number of bytes that will be read when using the file as a {@link io.vertx.reactivex.core.streams.ReadStream}
   */
  public long getReadLength() { 
    long ret = delegate.getReadLength();
    return ret;
  }

  /**
   * Sets the position from which data will be written when using the file as a {@link io.vertx.reactivex.core.streams.WriteStream}.
   * @param writePos the position in the file
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.file.AsyncFile setWritePos(long writePos) { 
    delegate.setWritePos(writePos);
    return this;
  }

  /**
   * @return the current write position the file is at
   */
  public long getWritePos() { 
    long ret = delegate.getWritePos();
    return ret;
  }

  /**
   * Sets the buffer size that will be used to read the data from the file. Changing this value will impact how much
   * the data will be read at a time from the file system.
   * @param readBufferSize the buffer size
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.file.AsyncFile setReadBufferSize(int readBufferSize) { 
    delegate.setReadBufferSize(readBufferSize);
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.file.AsyncFile#size} but blocking.
   * @return 
   */
  public long sizeBlocking() { 
    long ret = delegate.sizeBlocking();
    return ret;
  }

  /**
   * @return the size of the file
   */
  public io.vertx.core.Future<java.lang.Long> size() { 
    io.vertx.core.Future<java.lang.Long> ret = delegate.size().map(val -> val);
    return ret;
  }

  /**
   * @return the size of the file
   */
  public io.reactivex.Single<java.lang.Long> rxSize() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.size().onComplete($handler);
    });
  }

  /**
   * Try to acquire a non-shared lock on the entire file.
   * @return the lock if it can be acquired immediately, otherwise <code>null</code>
   */
  public io.vertx.reactivex.core.file.AsyncFileLock tryLock() { 
    io.vertx.reactivex.core.file.AsyncFileLock ret = io.vertx.reactivex.core.file.AsyncFileLock.newInstance((io.vertx.core.file.AsyncFileLock)delegate.tryLock());
    return ret;
  }

  /**
   * Try to acquire a lock on a portion of this file.
   * @param position where the region starts
   * @param size the size of the region
   * @param shared whether the lock should be shared
   * @return the lock if it can be acquired immediately, otherwise <code>null</code>
   */
  public io.vertx.reactivex.core.file.AsyncFileLock tryLock(long position, long size, boolean shared) { 
    io.vertx.reactivex.core.file.AsyncFileLock ret = io.vertx.reactivex.core.file.AsyncFileLock.newInstance((io.vertx.core.file.AsyncFileLock)delegate.tryLock(position, size, shared));
    return ret;
  }

  /**
   * Acquire a non-shared lock on the entire file.
   * @return a future indicating the completion of this operation
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.file.AsyncFileLock> lock() { 
    io.vertx.core.Future<io.vertx.reactivex.core.file.AsyncFileLock> ret = delegate.lock().map(val -> io.vertx.reactivex.core.file.AsyncFileLock.newInstance((io.vertx.core.file.AsyncFileLock)val));
    return ret;
  }

  /**
   * Acquire a non-shared lock on the entire file.
   * @return a future indicating the completion of this operation
   */
  public io.reactivex.Single<io.vertx.reactivex.core.file.AsyncFileLock> rxLock() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.lock().onComplete($handler);
    });
  }

  /**
   * Acquire a lock on a portion of this file.
   * @param position where the region starts
   * @param size the size of the region
   * @param shared whether the lock should be shared
   * @return a future indicating the completion of this operation
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.file.AsyncFileLock> lock(long position, long size, boolean shared) { 
    io.vertx.core.Future<io.vertx.reactivex.core.file.AsyncFileLock> ret = delegate.lock(position, size, shared).map(val -> io.vertx.reactivex.core.file.AsyncFileLock.newInstance((io.vertx.core.file.AsyncFileLock)val));
    return ret;
  }

  /**
   * Acquire a lock on a portion of this file.
   * @param position where the region starts
   * @param size the size of the region
   * @param shared whether the lock should be shared
   * @return a future indicating the completion of this operation
   */
  public io.reactivex.Single<io.vertx.reactivex.core.file.AsyncFileLock> rxLock(long position, long size, boolean shared) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.lock(position, size, shared).onComplete($handler);
    });
  }

  /**
   * Acquire a non-shared lock on the entire file.
   *
   * <p>When the <code>block</code> is called, the lock is already acquired, it will be released when the
   * <code>Future<T></code> returned by the block completes.
   *
   * <p>When the <code>block</code> fails, the lock is released and the returned future is failed with the cause of the failure.
   * @param block the code block called after lock acquisition
   * @return the future returned by the <code>block</code>
   */
  public <T> io.vertx.core.Future<T> withLock(java.util.function.Supplier<io.vertx.core.Future<T>> block) { 
    io.vertx.core.Future<T> ret = delegate.withLock(new Supplier<io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> get() {
        io.vertx.core.Future<T> ret = block.get();
        return ret.map(val -> val);
      }
    }).map(val -> (T) val);
    return ret;
  }

  /**
   * Acquire a non-shared lock on the entire file.
   *
   * <p>When the <code>block</code> is called, the lock is already acquired, it will be released when the
   * <code>Future<T></code> returned by the block completes.
   *
   * <p>When the <code>block</code> fails, the lock is released and the returned future is failed with the cause of the failure.
   * @param block the code block called after lock acquisition
   * @return the future returned by the <code>block</code>
   */
  public <T> io.reactivex.Single<T> rxWithLock(java.util.function.Supplier<io.vertx.core.Future<T>> block) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.<T>withLock(block).onComplete($handler);
    });
  }

  /**
   * Acquire a lock on a portion of this file.
   *
   * <p>When the <code>block</code> is called, the lock is already acquired , it will be released when the
   * <code>Future<T></code> returned by the block completes.
   *
   * <p>When the <code>block</code> fails, the lock is released and the returned future is failed with the cause of the failure.
   * @param position where the region starts
   * @param size the size of the region
   * @param shared whether the lock should be shared
   * @param block the code block called after lock acquisition
   * @return the future returned by the <code>block</code>
   */
  public <T> io.vertx.core.Future<T> withLock(long position, long size, boolean shared, java.util.function.Supplier<io.vertx.core.Future<T>> block) { 
    io.vertx.core.Future<T> ret = delegate.withLock(position, size, shared, new Supplier<io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> get() {
        io.vertx.core.Future<T> ret = block.get();
        return ret.map(val -> val);
      }
    }).map(val -> (T) val);
    return ret;
  }

  /**
   * Acquire a lock on a portion of this file.
   *
   * <p>When the <code>block</code> is called, the lock is already acquired , it will be released when the
   * <code>Future<T></code> returned by the block completes.
   *
   * <p>When the <code>block</code> fails, the lock is released and the returned future is failed with the cause of the failure.
   * @param position where the region starts
   * @param size the size of the region
   * @param shared whether the lock should be shared
   * @param block the code block called after lock acquisition
   * @return the future returned by the <code>block</code>
   */
  public <T> io.reactivex.Single<T> rxWithLock(long position, long size, boolean shared, java.util.function.Supplier<io.vertx.core.Future<T>> block) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.<T>withLock(position, size, shared, block).onComplete($handler);
    });
  }

  public static AsyncFile newInstance(io.vertx.core.file.AsyncFile arg) {
    return arg != null ? new AsyncFile(arg) : null;
  }

}
