/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.eventbus;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a stream of message that can be written to.
 * <p>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.MessageProducer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.eventbus.MessageProducer.class)
public class MessageProducer<T> implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MessageProducer that = (MessageProducer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MessageProducer> __TYPE_ARG = new TypeArg<>(    obj -> new MessageProducer((io.vertx.core.eventbus.MessageProducer) obj),
    MessageProducer::getDelegate
  );

  private final io.vertx.core.eventbus.MessageProducer<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public MessageProducer(io.vertx.core.eventbus.MessageProducer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public MessageProducer(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.core.eventbus.MessageProducer)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  @Override 
  public io.vertx.core.eventbus.MessageProducer getDelegate() {
    return delegate;
  }


  /**
   * Update the delivery options of this producer.
   * @param options the new options
   * @return this producer object
   */
  public io.vertx.reactivex.core.eventbus.MessageProducer<T> deliveryOptions(io.vertx.core.eventbus.DeliveryOptions options) { 
    delegate.deliveryOptions(options);
    return this;
  }

  /**
   * @return The address to which the producer produces messages.
   */
  public java.lang.String address() { 
    java.lang.String ret = delegate.address();
    return ret;
  }

  /**
   * Write a message to the event-bus, either sending or publishing.
   *
   * The returned  completion depends on the producer type:
   *
   * <ul>
   *   <li>send or request: the future is completed successfully if the message has been written; otherwise, the future is failed</li>
   *   <li>publish: the future is failed if there is no recipient; otherwise, the future is completed successfully</li>
   * </ul>
   *
   * In any case, a successfully completed  is not a delivery guarantee.
   * @param body the message body
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> write(T body) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.write(__typeArg_0.<T>unwrap(body)).map(val -> val);
    return ret;
  }

  /**
   * Write a message to the event-bus, either sending or publishing.
   *
   * The returned  completion depends on the producer type:
   *
   * <ul>
   *   <li>send or request: the future is completed successfully if the message has been written; otherwise, the future is failed</li>
   *   <li>publish: the future is failed if there is no recipient; otherwise, the future is completed successfully</li>
   * </ul>
   *
   * In any case, a successfully completed  is not a delivery guarantee.
   * @param body the message body
   * @return 
   */
  public io.reactivex.Completable rxWrite(T body) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.write(body).onComplete($handler);
    });
  }

  /**
   * Closes the producer, this method should be called when the message producer is not used anymore.
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Closes the producer, this method should be called when the message producer is not used anymore.
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  public static <T> MessageProducer<T> newInstance(io.vertx.core.eventbus.MessageProducer arg) {
    return arg != null ? new MessageProducer<T>(arg) : null;
  }

  public static <T> MessageProducer<T> newInstance(io.vertx.core.eventbus.MessageProducer arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new MessageProducer<T>(arg, __typeArg_T) : null;
  }

}
