/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.eventbus;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An event bus consumer object representing a stream of message to an {@link io.vertx.reactivex.core.eventbus.EventBus} address that can
 * be read from.
 * <p>
 * The {@link io.vertx.reactivex.core.eventbus.EventBus#consumer} or {@link io.vertx.reactivex.core.eventbus.EventBus#localConsumer}
 * creates a new consumer, the returned consumer is not yet registered against the event bus. Registration
 * is effective after the {@link io.vertx.reactivex.core.eventbus.MessageConsumer#handler} method is invoked.<p>
 *
 * The consumer is unregistered from the event bus using the {@link io.vertx.reactivex.core.eventbus.MessageConsumer#unregister} method or by calling the
 * {@link io.vertx.reactivex.core.eventbus.MessageConsumer#handler} with a null value..
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.MessageConsumer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.eventbus.MessageConsumer.class)
public class MessageConsumer<T> implements RxDelegate, io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.eventbus.Message<T>> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MessageConsumer that = (MessageConsumer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MessageConsumer> __TYPE_ARG = new TypeArg<>(    obj -> new MessageConsumer((io.vertx.core.eventbus.MessageConsumer) obj),
    MessageConsumer::getDelegate
  );

  private final io.vertx.core.eventbus.MessageConsumer<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public MessageConsumer(io.vertx.core.eventbus.MessageConsumer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public MessageConsumer(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.core.eventbus.MessageConsumer)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  @Override 
  public io.vertx.core.eventbus.MessageConsumer getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<io.vertx.reactivex.core.eventbus.Message<T>> observable;
  private io.reactivex.Flowable<io.vertx.reactivex.core.eventbus.Message<T>> flowable;

  public synchronized io.reactivex.Observable<io.vertx.reactivex.core.eventbus.Message<T>> toObservable() {
    if (observable == null) {
      Function<io.vertx.core.eventbus.Message<T>, io.vertx.reactivex.core.eventbus.Message<T>> conv = io.vertx.reactivex.core.eventbus.Message::newInstance;
      observable = ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<io.vertx.reactivex.core.eventbus.Message<T>> toFlowable() {
    if (flowable == null) {
      Function<io.vertx.core.eventbus.Message<T>, io.vertx.reactivex.core.eventbus.Message<T>> conv = io.vertx.reactivex.core.eventbus.Message::newInstance;
      flowable = FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }


  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.core.eventbus.Message<T>> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.core.eventbus.Message<T>> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), new TypeArg<io.vertx.reactivex.core.eventbus.Message<T>>(o0 -> io.vertx.reactivex.core.eventbus.Message.newInstance((io.vertx.core.eventbus.Message)o0, __typeArg_0), o0 -> o0.getDelegate()));
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.vertx.core.Future<java.lang.Void> pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.eventbus.Message<T>> dst) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.pipeTo(dst.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.reactivex.Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.eventbus.Message<T>> dst) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.pipeTo(dst).onComplete($handler);
    });
  }

  public io.vertx.reactivex.core.eventbus.MessageConsumer<T> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.core.eventbus.MessageConsumer<T> handler(io.vertx.core.Handler<io.vertx.reactivex.core.eventbus.Message<T>> handler) { 
    delegate.handler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.core.eventbus.Message.newInstance((io.vertx.core.eventbus.Message)event, __typeArg_0)));
    return this;
  }

  public io.vertx.reactivex.core.eventbus.MessageConsumer<T> pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.core.eventbus.MessageConsumer<T> resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.core.eventbus.MessageConsumer<T> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.reactivex.core.eventbus.MessageConsumer<T> endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * @return a read stream for the body of the message stream.
   */
  public io.vertx.reactivex.core.streams.ReadStream<T> bodyStream() { 
    io.vertx.reactivex.core.streams.ReadStream<T> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.bodyStream(), __typeArg_0);
    return ret;
  }

  /**
   * @return true if the current consumer is registered
   */
  public boolean isRegistered() { 
    boolean ret = delegate.isRegistered();
    return ret;
  }

  /**
   * @return The address the handler was registered with.
   */
  public java.lang.String address() { 
    java.lang.String ret = delegate.address();
    return ret;
  }

  /**
   * @return a future notified when the message consumer is registered
   */
  public io.vertx.core.Future<java.lang.Void> completion() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.completion().map(val -> val);
    return ret;
  }

  /**
   * @return a future notified when the message consumer is registered
   */
  public io.reactivex.Completable rxCompletion() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.completion().onComplete($handler);
    });
  }

  /**
   * Unregisters the handler which created this registration
   * @return a future notified when the unregistation is done
   */
  public io.vertx.core.Future<java.lang.Void> unregister() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.unregister().map(val -> val);
    return ret;
  }

  /**
   * Unregisters the handler which created this registration
   * @return a future notified when the unregistation is done
   */
  public io.reactivex.Completable rxUnregister() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.unregister().onComplete($handler);
    });
  }

  public static <T> MessageConsumer<T> newInstance(io.vertx.core.eventbus.MessageConsumer arg) {
    return arg != null ? new MessageConsumer<T>(arg) : null;
  }

  public static <T> MessageConsumer<T> newInstance(io.vertx.core.eventbus.MessageConsumer arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new MessageConsumer<T>(arg, __typeArg_T) : null;
  }

}
