/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.dns;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Provides a way to asynchronously lookup information from DNS servers.
 * <p>
 * Please consult the documentation for more information on DNS clients.
 * <p>
 * The client is thread safe and can be used from any thread.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.dns.DnsClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.dns.DnsClient.class)
public class DnsClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DnsClient that = (DnsClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<DnsClient> __TYPE_ARG = new TypeArg<>(    obj -> new DnsClient((io.vertx.core.dns.DnsClient) obj),
    DnsClient::getDelegate
  );

  private final io.vertx.core.dns.DnsClient delegate;
  
  public DnsClient(io.vertx.core.dns.DnsClient delegate) {
    this.delegate = delegate;
  }

  public DnsClient(Object delegate) {
    this.delegate = (io.vertx.core.dns.DnsClient)delegate;
  }

  @Override 
  public io.vertx.core.dns.DnsClient getDelegate() {
    return delegate;
  }


  /**
   * Try to lookup the A (ipv4) or AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a future notified with the resolved address if a record was found. If none was found it will get notified with <code>null</code>. If an error occurs it will get failed.
   */
  public io.vertx.core.Future<java.lang.String> lookup(java.lang.String name) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.lookup(name).map(val -> val);
    return ret;
  }

  /**
   * Try to lookup the A (ipv4) or AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a future notified with the resolved address if a record was found. If none was found it will get notified with <code>null</code>. If an error occurs it will get failed.
   */
  public io.reactivex.Maybe<java.lang.String> rxLookup(java.lang.String name) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.lookup(name).onComplete($handler);
    });
  }

  /**
   * Try to lookup the A (ipv4) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a future notified with the resolved {@link java.net.Inet4Address} if a record was found. If none was found it will get notified with <code>null</code>. If an error occurs it will get failed.
   */
  public io.vertx.core.Future<java.lang.String> lookup4(java.lang.String name) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.lookup4(name).map(val -> val);
    return ret;
  }

  /**
   * Try to lookup the A (ipv4) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a future notified with the resolved {@link java.net.Inet4Address} if a record was found. If none was found it will get notified with <code>null</code>. If an error occurs it will get failed.
   */
  public io.reactivex.Maybe<java.lang.String> rxLookup4(java.lang.String name) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.lookup4(name).onComplete($handler);
    });
  }

  /**
   * Try to lookup the AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a future notified with the resolved {@link java.net.Inet6Address} if a record was found. If none was found it will get notified with <code>null</code>. If an error occurs it will get failed.
   */
  public io.vertx.core.Future<java.lang.String> lookup6(java.lang.String name) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.lookup6(name).map(val -> val);
    return ret;
  }

  /**
   * Try to lookup the AAAA (ipv6) record for the given name. The first found will be used.
   * @param name the name to resolve
   * @return a future notified with the resolved {@link java.net.Inet6Address} if a record was found. If none was found it will get notified with <code>null</code>. If an error occurs it will get failed.
   */
  public io.reactivex.Maybe<java.lang.String> rxLookup6(java.lang.String name) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.lookup6(name).onComplete($handler);
    });
  }

  /**
   * Try to resolve all A (ipv4) records for the given name.
   * @param name the name to resolve
   * @return a future notified with a {@link java.util.List} that contains all the resolved {@link java.net.Inet4Address}es. If none was found an empty {@link java.util.List} will be used. If an error occurs it will get failed.
   */
  public io.vertx.core.Future<java.util.List<java.lang.String>> resolveA(java.lang.String name) { 
    io.vertx.core.Future<java.util.List<java.lang.String>> ret = delegate.resolveA(name).map(val -> val);
    return ret;
  }

  /**
   * Try to resolve all A (ipv4) records for the given name.
   * @param name the name to resolve
   * @return a future notified with a {@link java.util.List} that contains all the resolved {@link java.net.Inet4Address}es. If none was found an empty {@link java.util.List} will be used. If an error occurs it will get failed.
   */
  public io.reactivex.Single<java.util.List<java.lang.String>> rxResolveA(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.resolveA(name).onComplete($handler);
    });
  }

  /**
   * Try to resolve all AAAA (ipv6) records for the given name.
   * @param name the name to resolve
   * @return a future notified with a {@link java.util.List} that contains all the resolved {@link java.net.Inet6Address}es. If none was found an empty {@link java.util.List} will be used. If an error occurs it will get failed.
   */
  public io.vertx.core.Future<java.util.List<java.lang.String>> resolveAAAA(java.lang.String name) { 
    io.vertx.core.Future<java.util.List<java.lang.String>> ret = delegate.resolveAAAA(name).map(val -> val);
    return ret;
  }

  /**
   * Try to resolve all AAAA (ipv6) records for the given name.
   * @param name the name to resolve
   * @return a future notified with a {@link java.util.List} that contains all the resolved {@link java.net.Inet6Address}es. If none was found an empty {@link java.util.List} will be used. If an error occurs it will get failed.
   */
  public io.reactivex.Single<java.util.List<java.lang.String>> rxResolveAAAA(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.resolveAAAA(name).onComplete($handler);
    });
  }

  /**
   * Try to resolve the CNAME record for the given name.
   * @param name the name to resolve the CNAME for
   * @return a future notified with the resolved {@link java.lang.String} if a record was found. If none was found it will get notified with <code>null</code>. If an error occurs it will get failed.
   */
  public io.vertx.core.Future<java.util.List<java.lang.String>> resolveCNAME(java.lang.String name) { 
    io.vertx.core.Future<java.util.List<java.lang.String>> ret = delegate.resolveCNAME(name).map(val -> val);
    return ret;
  }

  /**
   * Try to resolve the CNAME record for the given name.
   * @param name the name to resolve the CNAME for
   * @return a future notified with the resolved {@link java.lang.String} if a record was found. If none was found it will get notified with <code>null</code>. If an error occurs it will get failed.
   */
  public io.reactivex.Single<java.util.List<java.lang.String>> rxResolveCNAME(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.resolveCNAME(name).onComplete($handler);
    });
  }

  /**
   * Try to resolve the MX records for the given name.
   * @param name the name for which the MX records should be resolved
   * @return a future notified with a List that contains all resolved {@link io.vertx.core.dns.MxRecord}s, sorted by their {@link io.vertx.core.dns.MxRecord}. If none was found it will get notified with an empty {@link java.util.List}. If an error occurs it will get failed.
   */
  public io.vertx.core.Future<java.util.List<io.vertx.core.dns.MxRecord>> resolveMX(java.lang.String name) { 
    io.vertx.core.Future<java.util.List<io.vertx.core.dns.MxRecord>> ret = delegate.resolveMX(name).map(val -> val);
    return ret;
  }

  /**
   * Try to resolve the MX records for the given name.
   * @param name the name for which the MX records should be resolved
   * @return a future notified with a List that contains all resolved {@link io.vertx.core.dns.MxRecord}s, sorted by their {@link io.vertx.core.dns.MxRecord}. If none was found it will get notified with an empty {@link java.util.List}. If an error occurs it will get failed.
   */
  public io.reactivex.Single<java.util.List<io.vertx.core.dns.MxRecord>> rxResolveMX(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.resolveMX(name).onComplete($handler);
    });
  }

  /**
   * Try to resolve the TXT records for the given name.
   * @param name the name for which the TXT records should be resolved
   * @return a future notified with a List that contains all resolved {@link java.lang.String}s. If none was found it will get notified with an empty {@link java.util.List}. If an error occurs it will get failed.
   */
  public io.vertx.core.Future<java.util.List<java.lang.String>> resolveTXT(java.lang.String name) { 
    io.vertx.core.Future<java.util.List<java.lang.String>> ret = delegate.resolveTXT(name).map(val -> val);
    return ret;
  }

  /**
   * Try to resolve the TXT records for the given name.
   * @param name the name for which the TXT records should be resolved
   * @return a future notified with a List that contains all resolved {@link java.lang.String}s. If none was found it will get notified with an empty {@link java.util.List}. If an error occurs it will get failed.
   */
  public io.reactivex.Single<java.util.List<java.lang.String>> rxResolveTXT(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.resolveTXT(name).onComplete($handler);
    });
  }

  /**
   * Try to resolve the PTR record for the given name.
   * @param name the name to resolve the PTR for
   * @return a future notified with the resolved {@link java.lang.String} if a record was found. If none was found it will get notified with <code>null</code>. If an error occurs it will get failed.
   */
  public io.vertx.core.Future<java.lang.String> resolvePTR(java.lang.String name) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.resolvePTR(name).map(val -> val);
    return ret;
  }

  /**
   * Try to resolve the PTR record for the given name.
   * @param name the name to resolve the PTR for
   * @return a future notified with the resolved {@link java.lang.String} if a record was found. If none was found it will get notified with <code>null</code>. If an error occurs it will get failed.
   */
  public io.reactivex.Maybe<java.lang.String> rxResolvePTR(java.lang.String name) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.resolvePTR(name).onComplete($handler);
    });
  }

  /**
   * Try to resolve the NS records for the given name.
   * @param name the name for which the NS records should be resolved
   * @return a future notified with a List that contains all resolved {@link java.lang.String}s. If none was found it will get notified with an empty {@link java.util.List}. If an error occurs it will get failed.
   */
  public io.vertx.core.Future<java.util.List<java.lang.String>> resolveNS(java.lang.String name) { 
    io.vertx.core.Future<java.util.List<java.lang.String>> ret = delegate.resolveNS(name).map(val -> val);
    return ret;
  }

  /**
   * Try to resolve the NS records for the given name.
   * @param name the name for which the NS records should be resolved
   * @return a future notified with a List that contains all resolved {@link java.lang.String}s. If none was found it will get notified with an empty {@link java.util.List}. If an error occurs it will get failed.
   */
  public io.reactivex.Single<java.util.List<java.lang.String>> rxResolveNS(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.resolveNS(name).onComplete($handler);
    });
  }

  /**
   * Try to resolve the SRV records for the given name.
   * @param name the name for which the SRV records should be resolved
   * @return a future resolved with a List that contains all resolved {@link io.vertx.core.dns.SrvRecord}s. If none was found it will get notified with an empty {@link java.util.List}. If an error occurs it will get failed.
   */
  public io.vertx.core.Future<java.util.List<io.vertx.core.dns.SrvRecord>> resolveSRV(java.lang.String name) { 
    io.vertx.core.Future<java.util.List<io.vertx.core.dns.SrvRecord>> ret = delegate.resolveSRV(name).map(val -> val);
    return ret;
  }

  /**
   * Try to resolve the SRV records for the given name.
   * @param name the name for which the SRV records should be resolved
   * @return a future resolved with a List that contains all resolved {@link io.vertx.core.dns.SrvRecord}s. If none was found it will get notified with an empty {@link java.util.List}. If an error occurs it will get failed.
   */
  public io.reactivex.Single<java.util.List<io.vertx.core.dns.SrvRecord>> rxResolveSRV(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.resolveSRV(name).onComplete($handler);
    });
  }

  /**
   * Try to do a reverse lookup of an IP address. This is basically the same as doing trying to resolve a PTR record
   * but allows you to just pass in the IP address and not a valid ptr query string.
   * @param ipaddress the IP address to resolve the PTR for
   * @return a future notified with the resolved {@link java.lang.String} if a record was found. If none was found it will get notified with <code>null</code>. If an error occurs it will get failed.
   */
  public io.vertx.core.Future<java.lang.String> reverseLookup(java.lang.String ipaddress) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.reverseLookup(ipaddress).map(val -> val);
    return ret;
  }

  /**
   * Try to do a reverse lookup of an IP address. This is basically the same as doing trying to resolve a PTR record
   * but allows you to just pass in the IP address and not a valid ptr query string.
   * @param ipaddress the IP address to resolve the PTR for
   * @return a future notified with the resolved {@link java.lang.String} if a record was found. If none was found it will get notified with <code>null</code>. If an error occurs it will get failed.
   */
  public io.reactivex.Maybe<java.lang.String> rxReverseLookup(java.lang.String ipaddress) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.reverseLookup(ipaddress).onComplete($handler);
    });
  }

  /**
   * Close the client.
   * @return the future completed when the client resources have been released
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Close the client.
   * @return the future completed when the client resources have been released
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  public static DnsClient newInstance(io.vertx.core.dns.DnsClient arg) {
    return arg != null ? new DnsClient(arg) : null;
  }

}
