/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.datagram;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A datagram socket can be used to send {@link io.vertx.core.datagram.DatagramPacket}'s to remote datagram servers
 * and receive {@link io.vertx.core.datagram.DatagramPacket}s .
 * <p>
 * Usually you use a datagram socket to send UDP over the wire. UDP is connection-less which means you are not connected
 * to the remote peer in a persistent way. Because of this you have to supply the address and port of the remote peer
 * when sending data.
 * <p>
 * You can send data to ipv4 or ipv6 addresses, which also include multicast addresses.
 * <p>
 * Please consult the documentation for more information on datagram sockets.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.datagram.DatagramSocket original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.datagram.DatagramSocket.class)
public class DatagramSocket implements RxDelegate, io.vertx.reactivex.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DatagramSocket that = (DatagramSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<DatagramSocket> __TYPE_ARG = new TypeArg<>(    obj -> new DatagramSocket((io.vertx.core.datagram.DatagramSocket) obj),
    DatagramSocket::getDelegate
  );

  private final io.vertx.core.datagram.DatagramSocket delegate;
  
  public DatagramSocket(io.vertx.core.datagram.DatagramSocket delegate) {
    this.delegate = delegate;
  }

  public DatagramSocket(Object delegate) {
    this.delegate = (io.vertx.core.datagram.DatagramSocket)delegate;
  }

  @Override 
  public io.vertx.core.datagram.DatagramSocket getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.core.datagram.DatagramSocket> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.datagram.DatagramSocket>(o1 -> io.vertx.reactivex.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)o1), o1 -> o1.getDelegate());

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Write the given {@link io.vertx.core.buffer.Buffer} to the {@link io.vertx.core.net.SocketAddress}.
   * @param packet the {@link io.vertx.core.buffer.Buffer} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a future notified once the write completes.
   */
  public io.vertx.core.Future<java.lang.Void> send(io.vertx.core.buffer.Buffer packet, int port, java.lang.String host) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.send(packet, port, host).map(val -> val);
    return ret;
  }

  /**
   * Write the given {@link io.vertx.core.buffer.Buffer} to the {@link io.vertx.core.net.SocketAddress}.
   * @param packet the {@link io.vertx.core.buffer.Buffer} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a future notified once the write completes.
   */
  public io.reactivex.Completable rxSend(io.vertx.core.buffer.Buffer packet, int port, java.lang.String host) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.send(packet, port, host).onComplete($handler);
    });
  }

  /**
   * Returns a <code>WriteStream<Buffer></code> able to send  to the
   * {@link io.vertx.core.net.SocketAddress}.
   * @param port the port of the remote peer
   * @param host the host address of the remote peer
   * @return the write stream for sending packets
   */
  public io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.buffer.Buffer> sender(int port, java.lang.String host) { 
    io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.core.streams.WriteStream.newInstance((io.vertx.core.streams.WriteStream)delegate.sender(port, host), TypeArg.unknown());
    return ret;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.core.net.SocketAddress} using UTF8 encoding.
   * @param str the {@link java.lang.String} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a future notified once the write completes.
   */
  public io.vertx.core.Future<java.lang.Void> send(java.lang.String str, int port, java.lang.String host) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.send(str, port, host).map(val -> val);
    return ret;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.core.net.SocketAddress} using UTF8 encoding.
   * @param str the {@link java.lang.String} to write
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a future notified once the write completes.
   */
  public io.reactivex.Completable rxSend(java.lang.String str, int port, java.lang.String host) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.send(str, port, host).onComplete($handler);
    });
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.core.net.SocketAddress} using the given encoding.
   * @param str the {@link java.lang.String} to write
   * @param enc the charset used for encoding
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a future notified once the write completes.
   */
  public io.vertx.core.Future<java.lang.Void> send(java.lang.String str, java.lang.String enc, int port, java.lang.String host) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.send(str, enc, port, host).map(val -> val);
    return ret;
  }

  /**
   * Write the given {@link java.lang.String} to the {@link io.vertx.core.net.SocketAddress} using the given encoding.
   * @param str the {@link java.lang.String} to write
   * @param enc the charset used for encoding
   * @param port the host port of the remote peer
   * @param host the host address of the remote peer
   * @return a future notified once the write completes.
   */
  public io.reactivex.Completable rxSend(java.lang.String str, java.lang.String enc, int port, java.lang.String host) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.send(str, enc, port, host).onComplete($handler);
    });
  }

  /**
   * Closes the {@link io.vertx.reactivex.core.datagram.DatagramSocket} implementation asynchronous
   * and notifies the handler once done.
   * @return a future notified once the socket is closed
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Closes the {@link io.vertx.reactivex.core.datagram.DatagramSocket} implementation asynchronous
   * and notifies the handler once done.
   * @return a future notified once the socket is closed
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * Return the {@link io.vertx.core.net.SocketAddress} to which
   * this {@link io.vertx.reactivex.core.datagram.DatagramSocket} is bound.
   * @return the socket address
   */
  public io.vertx.core.net.SocketAddress localAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.core.net.SocketAddress ret = delegate.localAddress();
    cached_0 = ret;
    return ret;
  }

  /**
   * Joins a multicast group and listens for packets send to it.
   * @param multicastAddress the address of the multicast group to join
   * @return a future notified once the operation completes
   */
  public io.vertx.core.Future<java.lang.Void> listenMulticastGroup(java.lang.String multicastAddress) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.listenMulticastGroup(multicastAddress).map(val -> val);
    return ret;
  }

  /**
   * Joins a multicast group and listens for packets send to it.
   * @param multicastAddress the address of the multicast group to join
   * @return a future notified once the operation completes
   */
  public io.reactivex.Completable rxListenMulticastGroup(java.lang.String multicastAddress) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.listenMulticastGroup(multicastAddress).onComplete($handler);
    });
  }

  /**
   * Joins a multicast group and listens for packets send to it on the given network interface.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a future notified once the operation completes
   */
  public io.vertx.core.Future<java.lang.Void> listenMulticastGroup(java.lang.String multicastAddress, java.lang.String networkInterface, java.lang.String source) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.listenMulticastGroup(multicastAddress, networkInterface, source).map(val -> val);
    return ret;
  }

  /**
   * Joins a multicast group and listens for packets send to it on the given network interface.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a future notified once the operation completes
   */
  public io.reactivex.Completable rxListenMulticastGroup(java.lang.String multicastAddress, java.lang.String networkInterface, java.lang.String source) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.listenMulticastGroup(multicastAddress, networkInterface, source).onComplete($handler);
    });
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it.
   * @param multicastAddress the address of the multicast group to leave
   * @return a future notified once the operation completes
   */
  public io.vertx.core.Future<java.lang.Void> unlistenMulticastGroup(java.lang.String multicastAddress) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.unlistenMulticastGroup(multicastAddress).map(val -> val);
    return ret;
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it.
   * @param multicastAddress the address of the multicast group to leave
   * @return a future notified once the operation completes
   */
  public io.reactivex.Completable rxUnlistenMulticastGroup(java.lang.String multicastAddress) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.unlistenMulticastGroup(multicastAddress).onComplete($handler);
    });
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it on the given network interface.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a future notified once the operation completes
   */
  public io.vertx.core.Future<java.lang.Void> unlistenMulticastGroup(java.lang.String multicastAddress, java.lang.String networkInterface, java.lang.String source) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.unlistenMulticastGroup(multicastAddress, networkInterface, source).map(val -> val);
    return ret;
  }

  /**
   * Leaves a multicast group and stops listening for packets send to it on the given network interface.
   * @param multicastAddress the address of the multicast group to join
   * @param networkInterface the network interface on which to listen for packets.
   * @param source the address of the source for which we will listen for multicast packets
   * @return a future notified once the operation completes
   */
  public io.reactivex.Completable rxUnlistenMulticastGroup(java.lang.String multicastAddress, java.lang.String networkInterface, java.lang.String source) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.unlistenMulticastGroup(multicastAddress, networkInterface, source).onComplete($handler);
    });
  }

  /**
   * Block the given address for the given multicast address and notifies the  once
   * the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a future notified once the operation completes
   */
  public io.vertx.core.Future<java.lang.Void> blockMulticastGroup(java.lang.String multicastAddress, java.lang.String sourceToBlock) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.blockMulticastGroup(multicastAddress, sourceToBlock).map(val -> val);
    return ret;
  }

  /**
   * Block the given address for the given multicast address and notifies the  once
   * the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a future notified once the operation completes
   */
  public io.reactivex.Completable rxBlockMulticastGroup(java.lang.String multicastAddress, java.lang.String sourceToBlock) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.blockMulticastGroup(multicastAddress, sourceToBlock).onComplete($handler);
    });
  }

  /**
   * Block the given address for the given multicast address on the given network interface and notifies
   * the  once the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param networkInterface the network interface on which the blocking should occur.
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a future notified once the operation completes
   */
  public io.vertx.core.Future<java.lang.Void> blockMulticastGroup(java.lang.String multicastAddress, java.lang.String networkInterface, java.lang.String sourceToBlock) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock).map(val -> val);
    return ret;
  }

  /**
   * Block the given address for the given multicast address on the given network interface and notifies
   * the  once the operation completes.
   * @param multicastAddress the address for which you want to block the source address
   * @param networkInterface the network interface on which the blocking should occur.
   * @param sourceToBlock the source address which should be blocked. You will not receive an multicast packets for it anymore.
   * @return a future notified once the operation completes
   */
  public io.reactivex.Completable rxBlockMulticastGroup(java.lang.String multicastAddress, java.lang.String networkInterface, java.lang.String sourceToBlock) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock).onComplete($handler);
    });
  }

  /**
   * Start listening on the given port and host. The handler will be called when the socket is listening.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a future notified once the operation completes
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.datagram.DatagramSocket> listen(int port, java.lang.String host) { 
    io.vertx.core.Future<io.vertx.reactivex.core.datagram.DatagramSocket> ret = delegate.listen(port, host).map(val -> io.vertx.reactivex.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)val));
    return ret;
  }

  /**
   * Start listening on the given port and host. The handler will be called when the socket is listening.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a future notified once the operation completes
   */
  public io.reactivex.Single<io.vertx.reactivex.core.datagram.DatagramSocket> rxListen(int port, java.lang.String host) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listen(port, host).onComplete($handler);
    });
  }

  public io.vertx.reactivex.core.datagram.DatagramSocket handler(io.vertx.core.Handler<io.vertx.core.datagram.DatagramPacket> handler) { 
    io.vertx.reactivex.core.datagram.DatagramSocket ret = io.vertx.reactivex.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)delegate.handler(handler));
    return ret;
  }

  public io.vertx.reactivex.core.datagram.DatagramSocket exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    io.vertx.reactivex.core.datagram.DatagramSocket ret = io.vertx.reactivex.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)delegate.exceptionHandler(handler));
    return ret;
  }

  private io.vertx.core.net.SocketAddress cached_0;
  public static DatagramSocket newInstance(io.vertx.core.datagram.DatagramSocket arg) {
    return arg != null ? new DatagramSocket(arg) : null;
  }

}
