/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The entry point into the Vert.x Core API.
 * <p>
 * You use an instance of this class for functionality including:
 * <ul>
 *   <li>Creating TCP clients and servers</li>
 *   <li>Creating HTTP clients and servers</li>
 *   <li>Creating DNS clients</li>
 *   <li>Creating Datagram sockets</li>
 *   <li>Setting and cancelling periodic and one-shot timers</li>
 *   <li>Getting a reference to the event bus API</li>
 *   <li>Getting a reference to the file system API</li>
 *   <li>Getting a reference to the shared data API</li>
 *   <li>Deploying and undeploying verticles</li>
 * </ul>
 * <p>
 * Most functionality in Vert.x core is fairly low level.
 * <p>
 * To create an instance of this class you can use the static factory methods: {@link io.vertx.reactivex.core.Vertx#vertx},
 * {@link io.vertx.reactivex.core.Vertx#vertx} and {@link io.vertx.reactivex.core.Vertx#clusteredVertx}.
 * <p>
 * Please see the user manual for more detailed usage information.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.Vertx original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.Vertx.class)
public class Vertx implements RxDelegate, io.vertx.reactivex.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Vertx that = (Vertx) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Vertx> __TYPE_ARG = new TypeArg<>(    obj -> new Vertx((io.vertx.core.Vertx) obj),
    Vertx::getDelegate
  );

  private final io.vertx.core.Vertx delegate;
  
  public Vertx(io.vertx.core.Vertx delegate) {
    this.delegate = delegate;
  }

  public Vertx(Object delegate) {
    this.delegate = (io.vertx.core.Vertx)delegate;
  }

  @Override 
  public io.vertx.core.Vertx getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.core.Vertx> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.Vertx>(o1 -> io.vertx.reactivex.core.Vertx.newInstance((io.vertx.core.Vertx)o1), o1 -> o1.getDelegate());

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Return a builder for Vert.x instances which allows to specify SPI such as cluster manager, metrics or tracing.
   * @return a Vert.x instance builder
   */
  public static io.vertx.reactivex.core.VertxBuilder builder() { 
    io.vertx.reactivex.core.VertxBuilder ret = io.vertx.reactivex.core.VertxBuilder.newInstance((io.vertx.core.VertxBuilder)io.vertx.core.Vertx.builder());
    return ret;
  }

  /**
   * Creates a non clustered instance using default options.
   * @return the instance
   */
  public static io.vertx.reactivex.core.Vertx vertx() { 
    io.vertx.reactivex.core.Vertx ret = io.vertx.reactivex.core.Vertx.newInstance((io.vertx.core.Vertx)io.vertx.core.Vertx.vertx());
    return ret;
  }

  /**
   * Creates a non clustered instance using the specified options
   * @param options the options to use
   * @return the instance
   */
  public static io.vertx.reactivex.core.Vertx vertx(io.vertx.core.VertxOptions options) { 
    io.vertx.reactivex.core.Vertx ret = io.vertx.reactivex.core.Vertx.newInstance((io.vertx.core.Vertx)io.vertx.core.Vertx.vertx(options));
    return ret;
  }

  /**
   * Creates a clustered instance using the specified options.
   * <p>
   * The instance is created asynchronously and the returned future is completed with the result when it is ready.
   * @param options the options to use
   * @return a future completed with the clustered vertx
   */
  public static io.vertx.core.Future<io.vertx.reactivex.core.Vertx> clusteredVertx(io.vertx.core.VertxOptions options) { 
    io.vertx.core.Future<io.vertx.reactivex.core.Vertx> ret = io.vertx.core.Vertx.clusteredVertx(options).map(val -> io.vertx.reactivex.core.Vertx.newInstance((io.vertx.core.Vertx)val));
    return ret;
  }

  /**
   * Creates a clustered instance using the specified options.
   * <p>
   * The instance is created asynchronously and the returned future is completed with the result when it is ready.
   * @param options the options to use
   * @return a future completed with the clustered vertx
   */
  public static io.reactivex.Single<io.vertx.reactivex.core.Vertx> rxClusteredVertx(io.vertx.core.VertxOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      io.vertx.reactivex.core.Vertx.clusteredVertx(options).onComplete($handler);
    });
  }

  /**
   * Gets the current context
   * @return The current context or <code>null</code> if there is no current context
   */
  public static io.vertx.reactivex.core.Context currentContext() { 
    io.vertx.reactivex.core.Context ret = io.vertx.reactivex.core.Context.newInstance((io.vertx.core.Context)io.vertx.core.Vertx.currentContext());
    return ret;
  }

  /**
   * Gets the current context, or creates one if there isn't one
   * @return The current context (created if didn't exist)
   */
  public io.vertx.reactivex.core.Context getOrCreateContext() { 
    io.vertx.reactivex.core.Context ret = io.vertx.reactivex.core.Context.newInstance((io.vertx.core.Context)delegate.getOrCreateContext());
    return ret;
  }

  /**
   * Create a TCP/SSL server using the specified options
   * @param options the options to use
   * @return the server
   */
  public io.vertx.reactivex.core.net.NetServer createNetServer(io.vertx.core.net.NetServerOptions options) { 
    io.vertx.reactivex.core.net.NetServer ret = io.vertx.reactivex.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)delegate.createNetServer(options));
    return ret;
  }

  /**
   * Create a TCP/SSL server using default options
   * @return the server
   */
  public io.vertx.reactivex.core.net.NetServer createNetServer() { 
    io.vertx.reactivex.core.net.NetServer ret = io.vertx.reactivex.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)delegate.createNetServer());
    return ret;
  }

  /**
   * Create a TCP/SSL client using the specified options
   * @param options the options to use
   * @return the client
   */
  public io.vertx.reactivex.core.net.NetClient createNetClient(io.vertx.core.net.NetClientOptions options) { 
    io.vertx.reactivex.core.net.NetClient ret = io.vertx.reactivex.core.net.NetClient.newInstance((io.vertx.core.net.NetClient)delegate.createNetClient(options));
    return ret;
  }

  /**
   * Create a TCP/SSL client using default options
   * @return the client
   */
  public io.vertx.reactivex.core.net.NetClient createNetClient() { 
    io.vertx.reactivex.core.net.NetClient ret = io.vertx.reactivex.core.net.NetClient.newInstance((io.vertx.core.net.NetClient)delegate.createNetClient());
    return ret;
  }

  /**
   * Create an HTTP/HTTPS server using the specified options
   * @param options the options to use
   * @return the server
   */
  public io.vertx.reactivex.core.http.HttpServer createHttpServer(io.vertx.core.http.HttpServerOptions options) { 
    io.vertx.reactivex.core.http.HttpServer ret = io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)delegate.createHttpServer(options));
    return ret;
  }

  /**
   * Create an HTTP/HTTPS server using default options
   * @return the server
   */
  public io.vertx.reactivex.core.http.HttpServer createHttpServer() { 
    io.vertx.reactivex.core.http.HttpServer ret = io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)delegate.createHttpServer());
    return ret;
  }

  /**
   * Create a WebSocket client using default options
   * @return the client
   */
  public io.vertx.reactivex.core.http.WebSocketClient createWebSocketClient() { 
    io.vertx.reactivex.core.http.WebSocketClient ret = io.vertx.reactivex.core.http.WebSocketClient.newInstance((io.vertx.core.http.WebSocketClient)delegate.createWebSocketClient());
    return ret;
  }

  /**
   * Create a WebSocket client using the specified options
   * @param options the options to use
   * @return the client
   */
  public io.vertx.reactivex.core.http.WebSocketClient createWebSocketClient(io.vertx.core.http.WebSocketClientOptions options) { 
    io.vertx.reactivex.core.http.WebSocketClient ret = io.vertx.reactivex.core.http.WebSocketClient.newInstance((io.vertx.core.http.WebSocketClient)delegate.createWebSocketClient(options));
    return ret;
  }

  /**
   * Provide a builder for , it can be used to configure advanced
   * HTTP client settings like a redirect handler or a connection handler.
   * <p>
   * Example usage: <code>HttpClient client = vertx.httpClientBuilder().with(options).withConnectHandler(conn -> ...).build()</code>
   * @return 
   */
  public io.vertx.reactivex.core.http.HttpClientBuilder httpClientBuilder() { 
    io.vertx.reactivex.core.http.HttpClientBuilder ret = io.vertx.reactivex.core.http.HttpClientBuilder.newInstance((io.vertx.core.http.HttpClientBuilder)delegate.httpClientBuilder());
    return ret;
  }

  /**
   * Create a HTTP/HTTPS client using the specified client and pool options
   * @param clientOptions the client options to use
   * @param poolOptions the pool options to use
   * @return the client
   */
  public io.vertx.reactivex.core.http.HttpClientAgent createHttpClient(io.vertx.core.http.HttpClientOptions clientOptions, io.vertx.core.http.PoolOptions poolOptions) { 
    io.vertx.reactivex.core.http.HttpClientAgent ret = io.vertx.reactivex.core.http.HttpClientAgent.newInstance((io.vertx.core.http.HttpClientAgent)delegate.createHttpClient(clientOptions, poolOptions));
    return ret;
  }

  /**
   * Create a HTTP/HTTPS client using the specified client options
   * @param clientOptions the options to use
   * @return the client
   */
  public io.vertx.reactivex.core.http.HttpClientAgent createHttpClient(io.vertx.core.http.HttpClientOptions clientOptions) { 
    io.vertx.reactivex.core.http.HttpClientAgent ret = io.vertx.reactivex.core.http.HttpClientAgent.newInstance((io.vertx.core.http.HttpClientAgent)delegate.createHttpClient(clientOptions));
    return ret;
  }

  /**
   * Create a HTTP/HTTPS client using the specified pool options
   * @param poolOptions the pool options to use
   * @return the client
   */
  public io.vertx.reactivex.core.http.HttpClientAgent createHttpClient(io.vertx.core.http.PoolOptions poolOptions) { 
    io.vertx.reactivex.core.http.HttpClientAgent ret = io.vertx.reactivex.core.http.HttpClientAgent.newInstance((io.vertx.core.http.HttpClientAgent)delegate.createHttpClient(poolOptions));
    return ret;
  }

  /**
   * Create a HTTP/HTTPS client using default options
   * @return the client
   */
  public io.vertx.reactivex.core.http.HttpClientAgent createHttpClient() { 
    io.vertx.reactivex.core.http.HttpClientAgent ret = io.vertx.reactivex.core.http.HttpClientAgent.newInstance((io.vertx.core.http.HttpClientAgent)delegate.createHttpClient());
    return ret;
  }

  /**
   * Create a datagram socket using the specified options
   * @param options the options to use
   * @return the socket
   */
  public io.vertx.reactivex.core.datagram.DatagramSocket createDatagramSocket(io.vertx.core.datagram.DatagramSocketOptions options) { 
    io.vertx.reactivex.core.datagram.DatagramSocket ret = io.vertx.reactivex.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)delegate.createDatagramSocket(options));
    return ret;
  }

  /**
   * Create a datagram socket using default options
   * @return the socket
   */
  public io.vertx.reactivex.core.datagram.DatagramSocket createDatagramSocket() { 
    io.vertx.reactivex.core.datagram.DatagramSocket ret = io.vertx.reactivex.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)delegate.createDatagramSocket());
    return ret;
  }

  /**
   * Get the filesystem object. There is a single instance of FileSystem per Vertx instance.
   * @return the filesystem object
   */
  public io.vertx.reactivex.core.file.FileSystem fileSystem() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.reactivex.core.file.FileSystem ret = io.vertx.reactivex.core.file.FileSystem.newInstance((io.vertx.core.file.FileSystem)delegate.fileSystem());
    cached_0 = ret;
    return ret;
  }

  /**
   * Get the event bus object. There is a single instance of EventBus per Vertx instance.
   * @return the event bus object
   */
  public io.vertx.reactivex.core.eventbus.EventBus eventBus() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.reactivex.core.eventbus.EventBus ret = io.vertx.reactivex.core.eventbus.EventBus.newInstance((io.vertx.core.eventbus.EventBus)delegate.eventBus());
    cached_1 = ret;
    return ret;
  }

  /**
   * Create a DNS client to connect to a DNS server at the specified host and port, with the default query timeout (5 seconds)
   * <p/>
   * @param port the port
   * @param host the host
   * @return the DNS client
   */
  public io.vertx.reactivex.core.dns.DnsClient createDnsClient(int port, java.lang.String host) { 
    io.vertx.reactivex.core.dns.DnsClient ret = io.vertx.reactivex.core.dns.DnsClient.newInstance((io.vertx.core.dns.DnsClient)delegate.createDnsClient(port, host));
    return ret;
  }

  /**
   * Create a DNS client to connect to the DNS server configured by {@link io.vertx.core.VertxOptions}
   * <p>
   * DNS client takes the first configured resolver address provided by }
   * @return the DNS client
   */
  public io.vertx.reactivex.core.dns.DnsClient createDnsClient() { 
    io.vertx.reactivex.core.dns.DnsClient ret = io.vertx.reactivex.core.dns.DnsClient.newInstance((io.vertx.core.dns.DnsClient)delegate.createDnsClient());
    return ret;
  }

  /**
   * Create a DNS client to connect to a DNS server
   * @param options the client options
   * @return the DNS client
   */
  public io.vertx.reactivex.core.dns.DnsClient createDnsClient(io.vertx.core.dns.DnsClientOptions options) { 
    io.vertx.reactivex.core.dns.DnsClient ret = io.vertx.reactivex.core.dns.DnsClient.newInstance((io.vertx.core.dns.DnsClient)delegate.createDnsClient(options));
    return ret;
  }

  /**
   * Get the shared data object. There is a single instance of SharedData per Vertx instance.
   * @return the shared data object
   */
  public io.vertx.reactivex.core.shareddata.SharedData sharedData() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.vertx.reactivex.core.shareddata.SharedData ret = io.vertx.reactivex.core.shareddata.SharedData.newInstance((io.vertx.core.shareddata.SharedData)delegate.sharedData());
    cached_2 = ret;
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.Vertx#timer} with a unit in millis.
   * @param delay 
   * @return 
   */
  public io.vertx.reactivex.core.Timer timer(long delay) { 
    io.vertx.reactivex.core.Timer ret = io.vertx.reactivex.core.Timer.newInstance((io.vertx.core.Timer)delegate.timer(delay));
    return ret;
  }

  /**
   * Create a timer task configured with the specified <code>delay</code>, when the timeout fires the timer future
   * is succeeded, when the timeout is cancelled the timer future is failed with a {@link java.util.concurrent.CancellationException}
   * instance.
   * @param delay the delay
   * @param unit the delay unit
   * @return the timer object
   */
  public io.vertx.reactivex.core.Timer timer(long delay, java.util.concurrent.TimeUnit unit) { 
    io.vertx.reactivex.core.Timer ret = io.vertx.reactivex.core.Timer.newInstance((io.vertx.core.Timer)delegate.timer(delay, unit));
    return ret;
  }

  /**
   * Set a one-shot timer to fire after <code>delay</code> milliseconds, at which point <code>handler</code> will be called with
   * the id of the timer.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @param handler the handler that will be called with the timer ID when the timer fires
   * @return the unique ID of the timer
   */
  public long setTimer(long delay, io.vertx.core.Handler<java.lang.Long> handler) { 
    long ret = delegate.setTimer(delay, handler);
    return ret;
  }

  /**
   * Set a periodic timer to fire every <code>delay</code> milliseconds, at which point <code>handler</code> will be called with
   * the id of the timer.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @param handler the handler that will be called with the timer ID when the timer fires
   * @return the unique ID of the timer
   */
  public long setPeriodic(long delay, io.vertx.core.Handler<java.lang.Long> handler) { 
    long ret = delegate.setPeriodic(delay, handler);
    return ret;
  }

  /**
   * Set a periodic timer to fire every <code>delay</code> milliseconds with initial delay, at which point <code>handler</code> will be called with
   * the id of the timer.
   * @param initialDelay the initial delay in milliseconds
   * @param delay the delay in milliseconds, after which the timer will fire
   * @param handler the handler that will be called with the timer ID when the timer fires
   * @return the unique ID of the timer
   */
  public long setPeriodic(long initialDelay, long delay, io.vertx.core.Handler<java.lang.Long> handler) { 
    long ret = delegate.setPeriodic(initialDelay, delay, handler);
    return ret;
  }

  /**
   * Cancels the timer with the specified <code>id</code>.
   * @param id The id of the timer to cancel
   * @return true if the timer was successfully cancelled, or false if the timer does not exist.
   */
  public boolean cancelTimer(long id) { 
    boolean ret = delegate.cancelTimer(id);
    return ret;
  }

  /**
   * Puts the handler on the event queue for the current context so it will be run asynchronously ASAP after all
   * preceeding events have been handled.
   * @param action - a handler representing the action to execute
   */
  public void runOnContext(io.vertx.core.Handler<java.lang.Void> action) { 
    delegate.runOnContext(action);
  }

  /**
   * Stop the Vertx instance and release any resources held by it.
   * <p>
   * The instance cannot be used after it has been closed.
   * <p>
   * The actual close is asynchronous and may not complete until after the call has returned.
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Stop the Vertx instance and release any resources held by it.
   * <p>
   * The instance cannot be used after it has been closed.
   * <p>
   * The actual close is asynchronous and may not complete until after the call has returned.
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * Deploy a verticle instance given a name.
   * <p>
   * Given the name, Vert.x selects a  instance to use to instantiate the verticle.
   * <p>
   * For the rules on how factories are selected please consult the user manual.
   * <p>
   * If the deployment is successful the result will contain a String representing the unique deployment ID of the
   * deployment.
   * <p>
   * This deployment ID can subsequently be used to undeploy the verticle.
   * @param name the name.
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.String> deployVerticle(java.lang.String name) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.deployVerticle(name).map(val -> val);
    return ret;
  }

  /**
   * Deploy a verticle instance given a name.
   * <p>
   * Given the name, Vert.x selects a  instance to use to instantiate the verticle.
   * <p>
   * For the rules on how factories are selected please consult the user manual.
   * <p>
   * If the deployment is successful the result will contain a String representing the unique deployment ID of the
   * deployment.
   * <p>
   * This deployment ID can subsequently be used to undeploy the verticle.
   * @param name the name.
   * @return a future completed with the result
   */
  public io.reactivex.Single<java.lang.String> rxDeployVerticle(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.deployVerticle(name).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.Vertx#deployVerticle} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * @param name the name
   * @param options the deployment options.
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.String> deployVerticle(java.lang.String name, io.vertx.core.DeploymentOptions options) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.deployVerticle(name, options).map(val -> val);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.Vertx#deployVerticle} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * @param name the name
   * @param options the deployment options.
   * @return a future completed with the result
   */
  public io.reactivex.Single<java.lang.String> rxDeployVerticle(java.lang.String name, io.vertx.core.DeploymentOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.deployVerticle(name, options).onComplete($handler);
    });
  }

  /**
   * Undeploy a verticle deployment.
   * <p>
   * The actual undeployment happens asynchronously and may not complete until after the method has returned.
   * @param deploymentID the deployment ID
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> undeploy(java.lang.String deploymentID) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.undeploy(deploymentID).map(val -> val);
    return ret;
  }

  /**
   * Undeploy a verticle deployment.
   * <p>
   * The actual undeployment happens asynchronously and may not complete until after the method has returned.
   * @param deploymentID the deployment ID
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxUndeploy(java.lang.String deploymentID) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.undeploy(deploymentID).onComplete($handler);
    });
  }

  /**
   * Return a Set of deployment IDs for the currently deployed deploymentIDs.
   * @return Set of deployment IDs
   */
  public java.util.Set<java.lang.String> deploymentIDs() { 
    java.util.Set<java.lang.String> ret = delegate.deploymentIDs();
    return ret;
  }

  /**
   * Is this Vert.x instance clustered?
   * @return true if clustered
   */
  public boolean isClustered() { 
    boolean ret = delegate.isClustered();
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.Vertx#createSharedWorkerExecutor} but with the {@link io.vertx.core.VertxOptions} <code>poolSize</code>.
   * @param name 
   * @return 
   */
  public io.vertx.reactivex.core.WorkerExecutor createSharedWorkerExecutor(java.lang.String name) { 
    io.vertx.reactivex.core.WorkerExecutor ret = io.vertx.reactivex.core.WorkerExecutor.newInstance((io.vertx.core.WorkerExecutor)delegate.createSharedWorkerExecutor(name));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.Vertx#createSharedWorkerExecutor} but with the {@link io.vertx.core.VertxOptions} <code>maxExecuteTime</code>.
   * @param name 
   * @param poolSize 
   * @return 
   */
  public io.vertx.reactivex.core.WorkerExecutor createSharedWorkerExecutor(java.lang.String name, int poolSize) { 
    io.vertx.reactivex.core.WorkerExecutor ret = io.vertx.reactivex.core.WorkerExecutor.newInstance((io.vertx.core.WorkerExecutor)delegate.createSharedWorkerExecutor(name, poolSize));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.Vertx#createSharedWorkerExecutor} but with the {@link io.vertx.core.VertxOptions} <code>maxExecuteTimeUnit</code>.
   * @param name 
   * @param poolSize 
   * @param maxExecuteTime 
   * @return 
   */
  public io.vertx.reactivex.core.WorkerExecutor createSharedWorkerExecutor(java.lang.String name, int poolSize, long maxExecuteTime) { 
    io.vertx.reactivex.core.WorkerExecutor ret = io.vertx.reactivex.core.WorkerExecutor.newInstance((io.vertx.core.WorkerExecutor)delegate.createSharedWorkerExecutor(name, poolSize, maxExecuteTime));
    return ret;
  }

  /**
   * Create a named worker executor, the executor should be closed when it's not needed anymore to release
   * resources.<p/>
   *
   * This method can be called mutiple times with the same <code>name</code>. Executors with the same name will share
   * the same worker pool. The worker pool size , max execute time and unit of max execute time are set when the worker pool is created and
   * won't change after.<p>
   *
   * The worker pool is released when all the {@link io.vertx.reactivex.core.WorkerExecutor} sharing the same name are closed.
   * @param name the name of the worker executor
   * @param poolSize the size of the pool
   * @param maxExecuteTime the value of max worker execute time
   * @param maxExecuteTimeUnit the value of unit of max worker execute time
   * @return the named worker executor
   */
  public io.vertx.reactivex.core.WorkerExecutor createSharedWorkerExecutor(java.lang.String name, int poolSize, long maxExecuteTime, java.util.concurrent.TimeUnit maxExecuteTimeUnit) { 
    io.vertx.reactivex.core.WorkerExecutor ret = io.vertx.reactivex.core.WorkerExecutor.newInstance((io.vertx.core.WorkerExecutor)delegate.createSharedWorkerExecutor(name, poolSize, maxExecuteTime, maxExecuteTimeUnit));
    return ret;
  }

  /**
   * @return whether the native transport is used
   */
  public boolean isNativeTransportEnabled() { 
    if (cached_3 != null) {
      return cached_3;
    }
    boolean ret = delegate.isNativeTransportEnabled();
    cached_3 = ret;
    return ret;
  }

  /**
   * @return the error (if any) that cause the unavailability of native transport when {@link io.vertx.reactivex.core.Vertx#isNativeTransportEnabled} returns <code>false</code>.
   */
  public java.lang.Throwable unavailableNativeTransportCause() { 
    if (cached_4 != null) {
      return cached_4;
    }
    java.lang.Throwable ret = delegate.unavailableNativeTransportCause();
    cached_4 = ret;
    return ret;
  }

  /**
   * Set a default exception handler for {@link io.vertx.reactivex.core.Context}, set on {@link io.vertx.reactivex.core.Context#exceptionHandler} at creation.
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.Vertx exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Deploy a verticle instance that you have created yourself.
   * <p>
   * Vert.x will assign the verticle a context and start the verticle.
   * <p>
   * The actual deploy happens asynchronously and may not complete until after the call has returned.
   * <p>
   * If the deployment is successful the result will contain a string representing the unique deployment ID of the
   * deployment.
   * <p>
   * This deployment ID can subsequently be used to undeploy the verticle.
   * @param verticle the verticle instance to deploy.
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.String> deployVerticle(io.vertx.core.Deployable verticle) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.deployVerticle(verticle).map(val -> val);
    return ret;
  }

  /**
   * Deploy a verticle instance that you have created yourself.
   * <p>
   * Vert.x will assign the verticle a context and start the verticle.
   * <p>
   * The actual deploy happens asynchronously and may not complete until after the call has returned.
   * <p>
   * If the deployment is successful the result will contain a string representing the unique deployment ID of the
   * deployment.
   * <p>
   * This deployment ID can subsequently be used to undeploy the verticle.
   * @param verticle the verticle instance to deploy.
   * @return a future completed with the result
   */
  public io.reactivex.Single<java.lang.String> rxDeployVerticle(io.vertx.core.Deployable verticle) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.deployVerticle(verticle).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.Vertx#deployVerticle} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * @param verticle the verticle instance to deploy
   * @param options the deployment options.
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.String> deployVerticle(io.vertx.core.Deployable verticle, io.vertx.core.DeploymentOptions options) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.deployVerticle(verticle, options).map(val -> val);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.Vertx#deployVerticle} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * @param verticle the verticle instance to deploy
   * @param options the deployment options.
   * @return a future completed with the result
   */
  public io.reactivex.Single<java.lang.String> rxDeployVerticle(io.vertx.core.Deployable verticle, io.vertx.core.DeploymentOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.deployVerticle(verticle, options).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.Vertx#deployVerticle} but {@link io.vertx.core.Deployable} instance is created by invoking the
   * <code>verticleSupplier</code>.
   * <p>
   * The supplier will be invoked as many times as {@link io.vertx.core.DeploymentOptions}.
   * It must not return the same instance twice.
   * <p>
   * Note that the supplier will be invoked on the caller thread.
   * @param supplier 
   * @param options 
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.String> deployVerticle(java.util.function.Supplier<? extends io.vertx.core.Deployable> supplier, io.vertx.core.DeploymentOptions options) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.deployVerticle(supplier, options).map(val -> val);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.Vertx#deployVerticle} but {@link io.vertx.core.Deployable} instance is created by invoking the
   * <code>verticleSupplier</code>.
   * <p>
   * The supplier will be invoked as many times as {@link io.vertx.core.DeploymentOptions}.
   * It must not return the same instance twice.
   * <p>
   * Note that the supplier will be invoked on the caller thread.
   * @param supplier 
   * @param options 
   * @return a future completed with the result
   */
  public io.reactivex.Single<java.lang.String> rxDeployVerticle(java.util.function.Supplier<? extends io.vertx.core.Deployable> supplier, io.vertx.core.DeploymentOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.deployVerticle(supplier, options).onComplete($handler);
    });
  }

  /**
   * Register a <code>VerticleFactory</code> that can be used for deploying Verticles based on an identifier.
   * @param factory the factory to register
   */
  public void registerVerticleFactory(io.vertx.core.spi.VerticleFactory factory) { 
    delegate.registerVerticleFactory(factory);
  }

  /**
   * Unregister a <code>VerticleFactory</code>
   * @param factory the factory to unregister
   */
  public void unregisterVerticleFactory(io.vertx.core.spi.VerticleFactory factory) { 
    delegate.unregisterVerticleFactory(factory);
  }

  /**
   * Return the Set of currently registered verticle factories.
   * @return the set of verticle factories
   */
  public java.util.Set<io.vertx.core.spi.VerticleFactory> verticleFactories() { 
    java.util.Set<io.vertx.core.spi.VerticleFactory> ret = delegate.verticleFactories();
    return ret;
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * The returned future will be completed with the result on the original context (i.e. on the original event loop of the caller)
   * or failed when the handler throws an exception.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on this context and not on the worker thread.
   * <p>
   * The blocking code should block for a reasonable amount of time (i.e no more than a few seconds). Long blocking operations
   * or polling operations (i.e a thread that spin in a loop polling events in a blocking fashion) are precluded.
   * <p>
   * When the blocking operation lasts more than the 10 seconds, a message will be printed on the console by the
   * blocked thread checker.
   * <p>
   * Long blocking operations should use a dedicated thread managed by the application, which can interact with
   * verticles using the event-bus or {@link io.vertx.reactivex.core.Context#runOnContext}
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return a future completed when the blocking code is complete
   */
  public <T> io.vertx.core.Future<T> executeBlocking(java.util.concurrent.Callable<T> blockingCodeHandler, boolean ordered) { 
    io.vertx.core.Future<T> ret = delegate.executeBlocking(blockingCodeHandler, ordered).map(val -> (T) val);
    return ret;
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * The returned future will be completed with the result on the original context (i.e. on the original event loop of the caller)
   * or failed when the handler throws an exception.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on this context and not on the worker thread.
   * <p>
   * The blocking code should block for a reasonable amount of time (i.e no more than a few seconds). Long blocking operations
   * or polling operations (i.e a thread that spin in a loop polling events in a blocking fashion) are precluded.
   * <p>
   * When the blocking operation lasts more than the 10 seconds, a message will be printed on the console by the
   * blocked thread checker.
   * <p>
   * Long blocking operations should use a dedicated thread managed by the application, which can interact with
   * verticles using the event-bus or {@link io.vertx.reactivex.core.Context#runOnContext}
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return a future completed when the blocking code is complete
   */
  public <T> io.reactivex.Maybe<T> rxExecuteBlocking(java.util.concurrent.Callable<T> blockingCodeHandler, boolean ordered) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.<T>executeBlocking(blockingCodeHandler, ordered).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.Vertx#executeBlocking} called with ordered = true.
   * @param blockingCodeHandler 
   * @return 
   */
  public <T> io.vertx.core.Future<T> executeBlocking(java.util.concurrent.Callable<T> blockingCodeHandler) { 
    io.vertx.core.Future<T> ret = delegate.executeBlocking(blockingCodeHandler).map(val -> (T) val);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.Vertx#executeBlocking} called with ordered = true.
   * @param blockingCodeHandler 
   * @return 
   */
  public <T> io.reactivex.Maybe<T> rxExecuteBlocking(java.util.concurrent.Callable<T> blockingCodeHandler) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.<T>executeBlocking(blockingCodeHandler).onComplete($handler);
    });
  }

  private io.vertx.reactivex.core.file.FileSystem cached_0;
  private io.vertx.reactivex.core.eventbus.EventBus cached_1;
  private io.vertx.reactivex.core.shareddata.SharedData cached_2;
  private java.lang.Boolean cached_3;
  private java.lang.Throwable cached_4;
  public static Vertx newInstance(io.vertx.core.Vertx arg) {
    return arg != null ? new Vertx(arg) : null;
  }

}
