/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A timer task that can be used as a future.
 *
 * The future is completed when the timeout expires, when the task is cancelled the future is failed
 * with a {@link java.util.concurrent.CancellationException}.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.Timer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.Timer.class)
public class Timer implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Timer that = (Timer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Timer> __TYPE_ARG = new TypeArg<>(    obj -> new Timer((io.vertx.core.Timer) obj),
    Timer::getDelegate
  );

  private final io.vertx.core.Timer delegate;
  
  public Timer(io.vertx.core.Timer delegate) {
    this.delegate = delegate;
  }

  public Timer(Object delegate) {
    this.delegate = (io.vertx.core.Timer)delegate;
  }

  @Override 
  public io.vertx.core.Timer getDelegate() {
    return delegate;
  }

  /**
   * Attempt to cancel the timer task, when the timer is cancelled, the timer is
   * failed with a {@link java.util.concurrent.CancellationException}.
   * @return <code>true</code> when the future was cancelled and the timeout didn't fire.
   */
  public boolean cancel() { 
    boolean ret = delegate.cancel();
    return ret;
  }

  public long getDelay(java.util.concurrent.TimeUnit unit) { 
    long ret = delegate.getDelay(unit);
    return ret;
  }

  public int compareTo(java.util.concurrent.Delayed o) { 
    int ret = delegate.compareTo(o);
    return ret;
  }

  public static Timer newInstance(io.vertx.core.Timer arg) {
    return arg != null ? new Timer(arg) : null;
  }

}
