/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.config;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Defines a configuration retriever that read configuration from
 * 
 * and tracks changes periodically.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.config.ConfigRetriever original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.config.ConfigRetriever.class)
public class ConfigRetriever implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConfigRetriever that = (ConfigRetriever) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ConfigRetriever> __TYPE_ARG = new TypeArg<>(    obj -> new ConfigRetriever((io.vertx.config.ConfigRetriever) obj),
    ConfigRetriever::getDelegate
  );

  private final io.vertx.config.ConfigRetriever delegate;
  
  public ConfigRetriever(io.vertx.config.ConfigRetriever delegate) {
    this.delegate = delegate;
  }

  public ConfigRetriever(Object delegate) {
    this.delegate = (io.vertx.config.ConfigRetriever)delegate;
  }

  @Override 
  public io.vertx.config.ConfigRetriever getDelegate() {
    return delegate;
  }


  /**
   * Creates an instance of the default implementation of the {@link io.vertx.reactivex.config.ConfigRetriever}.
   * @param vertx the vert.x instance
   * @param options the options, must not be <code>null</code>, must contain the list of configured store.
   * @return the created instance.
   */
  public static io.vertx.reactivex.config.ConfigRetriever create(io.vertx.reactivex.core.Vertx vertx, io.vertx.config.ConfigRetrieverOptions options) { 
    io.vertx.reactivex.config.ConfigRetriever ret = io.vertx.reactivex.config.ConfigRetriever.newInstance((io.vertx.config.ConfigRetriever)io.vertx.config.ConfigRetriever.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Creates an instance of the default implementation of the {@link io.vertx.reactivex.config.ConfigRetriever}, using the default
   * settings (json file, system properties and environment variables).
   * @param vertx the vert.x instance
   * @return the created instance.
   */
  public static io.vertx.reactivex.config.ConfigRetriever create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.config.ConfigRetriever ret = io.vertx.reactivex.config.ConfigRetriever.newInstance((io.vertx.config.ConfigRetriever)io.vertx.config.ConfigRetriever.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Reads the configuration from the different 
   * and computes the final configuration.
   * @return a future notified the computed configuration, or a failure if the configuration cannot be retrieved
   */
  public io.vertx.core.Future<io.vertx.core.json.JsonObject> getConfig() { 
    io.vertx.core.Future<io.vertx.core.json.JsonObject> ret = delegate.getConfig().map(val -> val);
    return ret;
  }

  /**
   * Reads the configuration from the different 
   * and computes the final configuration.
   * @return a future notified the computed configuration, or a failure if the configuration cannot be retrieved
   */
  public io.reactivex.Single<io.vertx.core.json.JsonObject> rxGetConfig() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getConfig().onComplete($handler);
    });
  }

  /**
   * Closes the retriever.
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Closes the retriever.
   * @return 
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * Gets the last computed configuration.
   * @return the last configuration
   */
  public io.vertx.core.json.JsonObject getCachedConfig() { 
    io.vertx.core.json.JsonObject ret = delegate.getCachedConfig();
    return ret;
  }

  /**
   * Registers a listener receiving configuration changes. This method cannot only be called if
   * the configuration is broadcasted.
   * @param listener the listener
   */
  public void listen(io.vertx.core.Handler<io.vertx.config.ConfigChange> listener) { 
    delegate.listen(listener);
  }

  /**
   * Registers a handler called before every scan. This method is mostly used for logging purpose.
   * @param handler the handler, must not be <code>null</code>
   * @return the current config retriever
   */
  public io.vertx.reactivex.config.ConfigRetriever setBeforeScanHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.setBeforeScanHandler(handler);
    return this;
  }

  /**
   * Registers a handler that process the configuration before being injected into  or {@link io.vertx.reactivex.config.ConfigRetriever#listen}. This allows
   * the code to customize the configuration.
   * @param processor the processor, must not be <code>null</code>. The method must not return <code>null</code>. The returned configuration is used. If the processor does not update the configuration, it must return the input configuration. If the processor throws an exception, the failure is passed to the  handler.
   * @return the current config retriever
   */
  public io.vertx.reactivex.config.ConfigRetriever setConfigurationProcessor(java.util.function.Function<io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject> processor) { 
    delegate.setConfigurationProcessor(processor);
    return this;
  }

  /**
   * @return the stream of configurations. It's single stream (unicast) and that delivers the last known config and the successors periodically.
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> configStream() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.configStream(), TypeArg.unknown());
    cached_0 = ret;
    return ret;
  }

  private io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> cached_0;
  public static ConfigRetriever newInstance(io.vertx.config.ConfigRetriever arg) {
    return arg != null ? new ConfigRetriever(arg) : null;
  }

}
