/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.circuitbreaker;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An implementation of the circuit breaker pattern for Vert.x
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.circuitbreaker.CircuitBreaker original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.circuitbreaker.CircuitBreaker.class)
public class CircuitBreaker implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CircuitBreaker that = (CircuitBreaker) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CircuitBreaker> __TYPE_ARG = new TypeArg<>(    obj -> new CircuitBreaker((io.vertx.circuitbreaker.CircuitBreaker) obj),
    CircuitBreaker::getDelegate
  );

  private final io.vertx.circuitbreaker.CircuitBreaker delegate;
  
  public CircuitBreaker(io.vertx.circuitbreaker.CircuitBreaker delegate) {
    this.delegate = delegate;
  }

  public CircuitBreaker(Object delegate) {
    this.delegate = (io.vertx.circuitbreaker.CircuitBreaker)delegate;
  }

  @Override 
  public io.vertx.circuitbreaker.CircuitBreaker getDelegate() {
    return delegate;
  }


  /**
   * Creates a new instance of {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}.
   * @param name the name
   * @param vertx the Vert.x instance
   * @param options the configuration options
   * @return the created instance
   */
  public static io.vertx.reactivex.circuitbreaker.CircuitBreaker create(java.lang.String name, io.vertx.reactivex.core.Vertx vertx, io.vertx.circuitbreaker.CircuitBreakerOptions options) { 
    io.vertx.reactivex.circuitbreaker.CircuitBreaker ret = io.vertx.reactivex.circuitbreaker.CircuitBreaker.newInstance((io.vertx.circuitbreaker.CircuitBreaker)io.vertx.circuitbreaker.CircuitBreaker.create(name, vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Creates a new instance of {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}, with default options.
   * @param name the name
   * @param vertx the Vert.x instance
   * @return the created instance
   */
  public static io.vertx.reactivex.circuitbreaker.CircuitBreaker create(java.lang.String name, io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.circuitbreaker.CircuitBreaker ret = io.vertx.reactivex.circuitbreaker.CircuitBreaker.newInstance((io.vertx.circuitbreaker.CircuitBreaker)io.vertx.circuitbreaker.CircuitBreaker.create(name, vertx.getDelegate()));
    return ret;
  }

  /**
   * Closes the circuit breaker. It stops sending events on its state on the event bus.
   * <p>
   * This method is not related to the <code>closed</code> state of the circuit breaker. To move the circuit breaker to the
   * <code>closed</code> state, use {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker#reset}.
   * @return 
   */
  public io.vertx.reactivex.circuitbreaker.CircuitBreaker close() { 
    delegate.close();
    return this;
  }

  /**
   * Sets a  to be invoked when the circuit breaker state switches to open.
   * @param handler the handler, must not be <code>null</code>
   * @return this {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}
   */
  public io.vertx.reactivex.circuitbreaker.CircuitBreaker openHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.openHandler(handler);
    return this;
  }

  /**
   * Sets a  to be invoked when the circuit breaker state switches to half-open.
   * @param handler the handler, must not be <code>null</code>
   * @return this {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}
   */
  public io.vertx.reactivex.circuitbreaker.CircuitBreaker halfOpenHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.halfOpenHandler(handler);
    return this;
  }

  /**
   * Sets a  to be invoked when the circuit breaker state switches to closed.
   * @param handler the handler, must not be <code>null</code>
   * @return this {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}
   */
  public io.vertx.reactivex.circuitbreaker.CircuitBreaker closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Executes the given operation with the circuit breaker control. The operation is generally calling an
   * <em>external</em> system. The operation receives a  object as parameter and <strong>must</strong>
   * call  when the operation has terminated successfully. The operation must also
   * call  in case of a failure.
   * <p>
   * The operation is not invoked if the circuit breaker is open, and the given fallback is called instead.
   * The circuit breaker also monitors whether the operation completes in time. The operation is considered failed
   * if it does not terminate before the configured timeout.
   * <p>
   * This method returns a  object to retrieve the status and result of the operation, with the status
   * being a success or a failure. If the fallback is called, the returned future is successfully completed with the
   * value returned from the fallback. If the fallback throws an exception, the returned future is marked as failed.
   * @param command the operation
   * @param fallback the fallback function; gets an exception as parameter and returns the <em>fallback</em> result
   * @return a future object completed when the operation or the fallback completes
   */
  public <T> io.vertx.core.Future<T> executeWithFallback(io.vertx.core.Handler<io.vertx.reactivex.core.Promise<T>> command, java.util.function.Function<java.lang.Throwable,T> fallback) { 
    io.vertx.core.Future<T> ret = delegate.executeWithFallback(io.vertx.lang.reactivex.Helper.convertHandler(command, event -> io.vertx.reactivex.core.Promise.newInstance((io.vertx.core.Promise)event, TypeArg.unknown())), fallback).map(val -> (T) val);
    return ret;
  }

  /**
   * Executes the given operation with the circuit breaker control. The operation is generally calling an
   * <em>external</em> system. The operation receives a  object as parameter and <strong>must</strong>
   * call  when the operation has terminated successfully. The operation must also
   * call  in case of a failure.
   * <p>
   * The operation is not invoked if the circuit breaker is open, and the given fallback is called instead.
   * The circuit breaker also monitors whether the operation completes in time. The operation is considered failed
   * if it does not terminate before the configured timeout.
   * <p>
   * This method returns a  object to retrieve the status and result of the operation, with the status
   * being a success or a failure. If the fallback is called, the returned future is successfully completed with the
   * value returned from the fallback. If the fallback throws an exception, the returned future is marked as failed.
   * @param command the operation
   * @param fallback the fallback function; gets an exception as parameter and returns the <em>fallback</em> result
   * @return a future object completed when the operation or the fallback completes
   */
  public <T> io.reactivex.Single<T> rxExecuteWithFallback(io.vertx.core.Handler<io.vertx.reactivex.core.Promise<T>> command, java.util.function.Function<java.lang.Throwable,T> fallback) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.<T>executeWithFallback(command, fallback).onComplete($handler);
    });
  }

  /**
   * Executes the given operation with the circuit breaker control. The operation is generally calling an
   * <em>external</em> system. The operation receives a  object as parameter and <strong>must</strong>
   * call  when the operation has terminated successfully. The operation must also
   * call  in case of a failure.
   * <p>
   * The operation is not invoked if the circuit breaker is open, and the given fallback is called instead.
   * The circuit breaker also monitors whether the operation completes in time. The operation is considered failed
   * if it does not terminate before the configured timeout.
   * <p>
   * This method returns a  object to retrieve the status and result of the operation, with the status
   * being a success or a failure. If the fallback is called, the returned future is successfully completed with the
   * value returned from the fallback. If the fallback throws an exception, the returned future is marked as failed.
   * @param command the operation
   * @param fallback the fallback function; gets an exception as parameter and returns the <em>fallback</em> result
   * @return a future object completed when the operation or the fallback completes
   */
  public <T> io.vertx.core.Future<T> executeWithFallback(java.util.function.Supplier<io.vertx.core.Future<T>> command, java.util.function.Function<java.lang.Throwable,T> fallback) { 
    io.vertx.core.Future<T> ret = delegate.executeWithFallback(new Supplier<io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> get() {
        io.vertx.core.Future<T> ret = command.get();
        return ret.map(val -> val);
      }
    }, fallback).map(val -> (T) val);
    return ret;
  }

  /**
   * Executes the given operation with the circuit breaker control. The operation is generally calling an
   * <em>external</em> system. The operation receives a  object as parameter and <strong>must</strong>
   * call  when the operation has terminated successfully. The operation must also
   * call  in case of a failure.
   * <p>
   * The operation is not invoked if the circuit breaker is open, and the given fallback is called instead.
   * The circuit breaker also monitors whether the operation completes in time. The operation is considered failed
   * if it does not terminate before the configured timeout.
   * <p>
   * This method returns a  object to retrieve the status and result of the operation, with the status
   * being a success or a failure. If the fallback is called, the returned future is successfully completed with the
   * value returned from the fallback. If the fallback throws an exception, the returned future is marked as failed.
   * @param command the operation
   * @param fallback the fallback function; gets an exception as parameter and returns the <em>fallback</em> result
   * @return a future object completed when the operation or the fallback completes
   */
  public <T> io.reactivex.Single<T> rxExecuteWithFallback(java.util.function.Supplier<io.vertx.core.Future<T>> command, java.util.function.Function<java.lang.Throwable,T> fallback) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.<T>executeWithFallback(command, fallback).onComplete($handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker#executeWithFallback} but using the circuit breaker
   * .
   * @param command the operation
   * @return a future object completed when the operation or its fallback completes
   */
  public <T> io.vertx.core.Future<T> execute(io.vertx.core.Handler<io.vertx.reactivex.core.Promise<T>> command) { 
    io.vertx.core.Future<T> ret = delegate.execute(io.vertx.lang.reactivex.Helper.convertHandler(command, event -> io.vertx.reactivex.core.Promise.newInstance((io.vertx.core.Promise)event, TypeArg.unknown()))).map(val -> (T) val);
    return ret;
  }

  /**
   * Same as {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker#executeWithFallback} but using the circuit breaker
   * .
   * @param command the operation
   * @return a future object completed when the operation or its fallback completes
   */
  public <T> io.reactivex.Single<T> rxExecute(io.vertx.core.Handler<io.vertx.reactivex.core.Promise<T>> command) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.<T>execute(command).onComplete($handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker#executeWithFallback} but using the circuit breaker
   * .
   * @param command the operation
   * @return a future object completed when the operation or its fallback completes
   */
  public <T> io.vertx.core.Future<T> execute(java.util.function.Supplier<io.vertx.core.Future<T>> command) { 
    io.vertx.core.Future<T> ret = delegate.execute(new Supplier<io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> get() {
        io.vertx.core.Future<T> ret = command.get();
        return ret.map(val -> val);
      }
    }).map(val -> (T) val);
    return ret;
  }

  /**
   * Same as {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker#executeWithFallback} but using the circuit breaker
   * .
   * @param command the operation
   * @return a future object completed when the operation or its fallback completes
   */
  public <T> io.reactivex.Single<T> rxExecute(java.util.function.Supplier<io.vertx.core.Future<T>> command) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.<T>execute(command).onComplete($handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker#executeAndReportWithFallback} but using the circuit breaker
   * .
   * @param resultPromise the promise on which the operation result is reported
   * @param command the operation
   * @return this {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}
   */
  public <T> io.vertx.reactivex.circuitbreaker.CircuitBreaker executeAndReport(io.vertx.reactivex.core.Promise<T> resultPromise, io.vertx.core.Handler<io.vertx.reactivex.core.Promise<T>> command) { 
    delegate.executeAndReport(resultPromise.getDelegate(), io.vertx.lang.reactivex.Helper.convertHandler(command, event -> io.vertx.reactivex.core.Promise.newInstance((io.vertx.core.Promise)event, resultPromise.__typeArg_0)));
    return this;
  }

  /**
   * Executes the given operation with the circuit breaker control. The operation is generally calling an
   * <em>external</em> system. The operation receives a  object as parameter and <strong>must</strong>
   * call  when the operation has terminated successfully. The operation must also
   * call  in case of a failure.
   * <p>
   * The operation is not invoked if the circuit breaker is open, and the given fallback is called instead.
   * The circuit breaker also monitors whether the operation completes in time. The operation is considered failed
   * if it does not terminate before the configured timeout.
   * <p>
   * Unlike {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker#executeWithFallback}, this method does not return a  object, but
   * lets the caller pass a  object on which the result is reported. If the fallback is called, the promise
   * is successfully completed with the value returned by the fallback function. If the fallback throws an exception,
   * the promise is marked as failed.
   * @param resultPromise the promise on which the operation result is reported
   * @param command the operation
   * @param fallback the fallback function; gets an exception as parameter and returns the <em>fallback</em> result
   * @return this {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}
   */
  public <T> io.vertx.reactivex.circuitbreaker.CircuitBreaker executeAndReportWithFallback(io.vertx.reactivex.core.Promise<T> resultPromise, io.vertx.core.Handler<io.vertx.reactivex.core.Promise<T>> command, java.util.function.Function<java.lang.Throwable,T> fallback) { 
    delegate.executeAndReportWithFallback(resultPromise.getDelegate(), io.vertx.lang.reactivex.Helper.convertHandler(command, event -> io.vertx.reactivex.core.Promise.newInstance((io.vertx.core.Promise)event, resultPromise.__typeArg_0)), fallback);
    return this;
  }

  /**
   * Sets a <em>default</em> fallback  to be invoked when the circuit breaker is open or when failure
   * occurs and {@link io.vertx.circuitbreaker.CircuitBreakerOptions} is enabled.
   * <p>
   * The function gets the exception as parameter and returns the <em>fallback</em> result.
   * @param handler the fallback handler
   * @return this {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}
   */
  public <T> io.vertx.reactivex.circuitbreaker.CircuitBreaker fallback(java.util.function.Function<java.lang.Throwable,T> handler) { 
    delegate.fallback(handler);
    return this;
  }

  /**
   * Configures the failure policy for this circuit-breaker.
   * @param failurePolicy 
   * @return the current {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}
   */
  public <T> io.vertx.reactivex.circuitbreaker.CircuitBreaker failurePolicy(io.vertx.reactivex.circuitbreaker.FailurePolicy<T> failurePolicy) { 
    delegate.failurePolicy(failurePolicy.getDelegate());
    return this;
  }

  /**
   * Resets the circuit breaker state. The number of recent failures is set to 0 and if the state is half-open,
   * it is set to closed.
   * @return this {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}
   */
  public io.vertx.reactivex.circuitbreaker.CircuitBreaker reset() { 
    delegate.reset();
    return this;
  }

  /**
   * Explicitly opens the circuit breaker.
   * @return this {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}
   */
  public io.vertx.reactivex.circuitbreaker.CircuitBreaker open() { 
    delegate.open();
    return this;
  }

  /**
   * @return the current state of this circuit breaker
   */
  public io.vertx.circuitbreaker.CircuitBreakerState state() { 
    io.vertx.circuitbreaker.CircuitBreakerState ret = delegate.state();
    return ret;
  }

  /**
   * @return the current number of recorded failures
   */
  public long failureCount() { 
    long ret = delegate.failureCount();
    return ret;
  }

  /**
   * @return the name of this circuit breaker
   */
  public java.lang.String name() { 
    if (cached_0 != null) {
      return cached_0;
    }
    java.lang.String ret = delegate.name();
    cached_0 = ret;
    return ret;
  }

  /**
   * Set a {@link io.vertx.reactivex.circuitbreaker.RetryPolicy} which computes a delay before a retry attempt.
   * @param retryPolicy 
   * @return 
   */
  public io.vertx.reactivex.circuitbreaker.CircuitBreaker retryPolicy(io.vertx.reactivex.circuitbreaker.RetryPolicy retryPolicy) { 
    delegate.retryPolicy(retryPolicy.getDelegate());
    return this;
  }

  private java.lang.String cached_0;
  public static CircuitBreaker newInstance(io.vertx.circuitbreaker.CircuitBreaker arg) {
    return arg != null ? new CircuitBreaker(arg) : null;
  }

}
