/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.cassandra;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * It is like {@link com.datastax.oss.driver.api.core.cql.AsyncResultSet}, but adapted for Vert.x.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.cassandra.ResultSet original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.cassandra.ResultSet.class)
public class ResultSet implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResultSet that = (ResultSet) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ResultSet> __TYPE_ARG = new TypeArg<>(    obj -> new ResultSet((io.vertx.cassandra.ResultSet) obj),
    ResultSet::getDelegate
  );

  private final io.vertx.cassandra.ResultSet delegate;
  
  public ResultSet(io.vertx.cassandra.ResultSet delegate) {
    this.delegate = delegate;
  }

  public ResultSet(Object delegate) {
    this.delegate = (io.vertx.cassandra.ResultSet)delegate;
  }

  @Override 
  public io.vertx.cassandra.ResultSet getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.cassandra.ResultSet> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.cassandra.ResultSet>(o1 -> io.vertx.reactivex.cassandra.ResultSet.newInstance((io.vertx.cassandra.ResultSet)o1), o1 -> o1.getDelegate());

  /**
   * @return 
   */
  public int remaining() { 
    int ret = delegate.remaining();
    return ret;
  }

  /**
   * @return 
   */
  public boolean hasMorePages() { 
    boolean ret = delegate.hasMorePages();
    return ret;
  }

  /**
   * @return 
   */
  public io.vertx.core.Future<io.vertx.reactivex.cassandra.ResultSet> fetchNextPage() { 
    io.vertx.core.Future<io.vertx.reactivex.cassandra.ResultSet> ret = delegate.fetchNextPage().map(val -> io.vertx.reactivex.cassandra.ResultSet.newInstance((io.vertx.cassandra.ResultSet)val));
    return ret;
  }

  /**
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.cassandra.ResultSet> rxFetchNextPage() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.fetchNextPage().onComplete($handler);
    });
  }

  /**
   * @return 
   */
  public boolean wasApplied() { 
    boolean ret = delegate.wasApplied();
    return ret;
  }

  /**
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.reactivex.cassandra.ResultSet#fetchNextPage} or {@link io.vertx.reactivex.cassandra.ResultSet#one}.
   * This may lead to unexpected result.
   * @return a future notified all the rows are fetched
   */
  public io.vertx.core.Future<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> all() { 
    io.vertx.core.Future<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> ret = delegate.all().map(val -> val);
    return ret;
  }

  /**
   * The method should <strong>not</strong> be used concurrently with others like {@link io.vertx.reactivex.cassandra.ResultSet#fetchNextPage} or {@link io.vertx.reactivex.cassandra.ResultSet#one}.
   * This may lead to unexpected result.
   * @return a future notified all the rows are fetched
   */
  public io.reactivex.Single<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> rxAll() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.all().onComplete($handler);
    });
  }

  /**
   * @return 
   */
  public com.datastax.oss.driver.api.core.cql.ColumnDefinitions getColumnDefinitions() { 
    com.datastax.oss.driver.api.core.cql.ColumnDefinitions ret = delegate.getColumnDefinitions();
    return ret;
  }

  /**
   * @return 
   */
  public com.datastax.oss.driver.api.core.cql.ExecutionInfo getExecutionInfo() { 
    com.datastax.oss.driver.api.core.cql.ExecutionInfo ret = delegate.getExecutionInfo();
    return ret;
  }

  /**
   * @return 
   */
  public java.lang.Iterable<com.datastax.oss.driver.api.core.cql.Row> currentPage() { 
    java.lang.Iterable<com.datastax.oss.driver.api.core.cql.Row> ret = delegate.currentPage();
    return ret;
  }

  /**
   * @return 
   */
  public com.datastax.oss.driver.api.core.cql.Row one() { 
    com.datastax.oss.driver.api.core.cql.Row ret = delegate.one();
    return ret;
  }

  public static ResultSet newInstance(io.vertx.cassandra.ResultSet arg) {
    return arg != null ? new ResultSet(arg) : null;
  }

}
