/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.cassandra;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Eclipse Vert.x Cassandra client.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.cassandra.CassandraClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.cassandra.CassandraClient.class)
public class CassandraClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CassandraClient that = (CassandraClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CassandraClient> __TYPE_ARG = new TypeArg<>(    obj -> new CassandraClient((io.vertx.cassandra.CassandraClient) obj),
    CassandraClient::getDelegate
  );

  private final io.vertx.cassandra.CassandraClient delegate;
  
  public CassandraClient(io.vertx.cassandra.CassandraClient delegate) {
    this.delegate = delegate;
  }

  public CassandraClient(Object delegate) {
    this.delegate = (io.vertx.cassandra.CassandraClient)delegate;
  }

  @Override 
  public io.vertx.cassandra.CassandraClient getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.cassandra.ResultSet> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.cassandra.ResultSet>(o1 -> io.vertx.reactivex.cassandra.ResultSet.newInstance((io.vertx.cassandra.ResultSet)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.cassandra.CassandraRowStream> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.cassandra.CassandraRowStream>(o1 -> io.vertx.reactivex.cassandra.CassandraRowStream.newInstance((io.vertx.cassandra.CassandraRowStream)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.cassandra.ResultSet> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.cassandra.ResultSet>(o1 -> io.vertx.reactivex.cassandra.ResultSet.newInstance((io.vertx.cassandra.ResultSet)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.cassandra.CassandraRowStream> TYPE_ARG_3 = new TypeArg<io.vertx.reactivex.cassandra.CassandraRowStream>(o1 -> io.vertx.reactivex.cassandra.CassandraRowStream.newInstance((io.vertx.cassandra.CassandraRowStream)o1), o1 -> o1.getDelegate());

  /**
   * Like {@link io.vertx.reactivex.cassandra.CassandraClient#create} with default options.
   * @param vertx 
   * @return 
   */
  public static io.vertx.reactivex.cassandra.CassandraClient create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a Cassandra client which maintains its own driver session.
   * <p>
   * It is not recommended to create several non shared clients in an application.
   * @param vertx the Vert.x instance
   * @param options the options
   * @return the client
   */
  public static io.vertx.reactivex.cassandra.CassandraClient create(io.vertx.reactivex.core.Vertx vertx, io.vertx.cassandra.CassandraClientOptions options) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.cassandra.CassandraClient#createShared} with default options and client name.
   * @param vertx 
   * @return 
   */
  public static io.vertx.reactivex.cassandra.CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.cassandra.CassandraClient#createShared} with default options.
   * @param vertx 
   * @param clientName 
   * @return 
   */
  public static io.vertx.reactivex.cassandra.CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx, java.lang.String clientName) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate(), clientName));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.cassandra.CassandraClient#createShared} with default client name.
   * @param vertx 
   * @param options 
   * @return 
   */
  public static io.vertx.reactivex.cassandra.CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx, io.vertx.cassandra.CassandraClientOptions options) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Create a Cassandra client that shares its driver session with any other client having the same name.
   * @param vertx the Vert.x instance
   * @param clientName the shared client name
   * @param options the options
   * @return the client
   */
  public static io.vertx.reactivex.cassandra.CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx, java.lang.String clientName, io.vertx.cassandra.CassandraClientOptions options) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate(), clientName, options));
    return ret;
  }

  /**
   * @return whether this Cassandra client instance is connected
   */
  public boolean isConnected() { 
    boolean ret = delegate.isConnected();
    return ret;
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param query the query to execute
   * @return a future of the result
   */
  public io.vertx.core.Future<io.vertx.reactivex.cassandra.ResultSet> execute(java.lang.String query) { 
    io.vertx.core.Future<io.vertx.reactivex.cassandra.ResultSet> ret = delegate.execute(query).map(val -> io.vertx.reactivex.cassandra.ResultSet.newInstance((io.vertx.cassandra.ResultSet)val));
    return ret;
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param query the query to execute
   * @return a future of the result
   */
  public io.reactivex.Single<io.vertx.reactivex.cassandra.ResultSet> rxExecute(java.lang.String query) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.execute(query).onComplete($handler);
    });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return a future of the result
   */
  public io.vertx.core.Future<io.vertx.reactivex.cassandra.CassandraRowStream> queryStream(java.lang.String sql) { 
    io.vertx.core.Future<io.vertx.reactivex.cassandra.CassandraRowStream> ret = delegate.queryStream(sql).map(val -> io.vertx.reactivex.cassandra.CassandraRowStream.newInstance((io.vertx.cassandra.CassandraRowStream)val));
    return ret;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return a future of the result
   */
  public io.reactivex.Single<io.vertx.reactivex.cassandra.CassandraRowStream> rxQueryStream(java.lang.String sql) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.queryStream(sql).onComplete($handler);
    });
  }

  /**
   * Closes this client.
   * @return a future of the result
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Closes this client.
   * @return a future of the result
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param query the query to execute
   * @return a future of the result
   */
  public io.vertx.core.Future<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> executeWithFullFetch(java.lang.String query) { 
    io.vertx.core.Future<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> ret = delegate.executeWithFullFetch(query).map(val -> val);
    return ret;
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param query the query to execute
   * @return a future of the result
   */
  public io.reactivex.Single<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> rxExecuteWithFullFetch(java.lang.String query) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.executeWithFullFetch(query).onComplete($handler);
    });
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param statement the statement to execute
   * @return a future of the result
   */
  public io.vertx.core.Future<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> executeWithFullFetch(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    io.vertx.core.Future<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> ret = delegate.executeWithFullFetch(statement).map(val -> val);
    return ret;
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param statement the statement to execute
   * @return a future of the result
   */
  public io.reactivex.Single<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> rxExecuteWithFullFetch(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.executeWithFullFetch(statement).onComplete($handler);
    });
  }

  /**
   * Execute the statement and provide a handler for consuming results.
   * @param statement the statement to execute
   * @return a future of the result
   */
  public io.vertx.core.Future<io.vertx.reactivex.cassandra.ResultSet> execute(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    io.vertx.core.Future<io.vertx.reactivex.cassandra.ResultSet> ret = delegate.execute(statement).map(val -> io.vertx.reactivex.cassandra.ResultSet.newInstance((io.vertx.cassandra.ResultSet)val));
    return ret;
  }

  /**
   * Execute the statement and provide a handler for consuming results.
   * @param statement the statement to execute
   * @return a future of the result
   */
  public io.reactivex.Single<io.vertx.reactivex.cassandra.ResultSet> rxExecute(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.execute(statement).onComplete($handler);
    });
  }

  /**
   * Prepares the provided query string.
   * @param query the query to prepare
   * @return a future of the result
   */
  public io.vertx.core.Future<com.datastax.oss.driver.api.core.cql.PreparedStatement> prepare(java.lang.String query) { 
    io.vertx.core.Future<com.datastax.oss.driver.api.core.cql.PreparedStatement> ret = delegate.prepare(query).map(val -> val);
    return ret;
  }

  /**
   * Prepares the provided query string.
   * @param query the query to prepare
   * @return a future of the result
   */
  public io.reactivex.Single<com.datastax.oss.driver.api.core.cql.PreparedStatement> rxPrepare(java.lang.String query) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.prepare(query).onComplete($handler);
    });
  }

  /**
   * Prepares the provided a .
   * @param statement the statement to prepare
   * @return a future of the result
   */
  public io.vertx.core.Future<com.datastax.oss.driver.api.core.cql.PreparedStatement> prepare(com.datastax.oss.driver.api.core.cql.SimpleStatement statement) { 
    io.vertx.core.Future<com.datastax.oss.driver.api.core.cql.PreparedStatement> ret = delegate.prepare(statement).map(val -> val);
    return ret;
  }

  /**
   * Prepares the provided a .
   * @param statement the statement to prepare
   * @return a future of the result
   */
  public io.reactivex.Single<com.datastax.oss.driver.api.core.cql.PreparedStatement> rxPrepare(com.datastax.oss.driver.api.core.cql.SimpleStatement statement) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.prepare(statement).onComplete($handler);
    });
  }

  /**
   * Executes the given SQL statement which returns the results of the query as a read stream.
   * @param statement the statement to execute.
   * @return a future of the result
   */
  public io.vertx.core.Future<io.vertx.reactivex.cassandra.CassandraRowStream> queryStream(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    io.vertx.core.Future<io.vertx.reactivex.cassandra.CassandraRowStream> ret = delegate.queryStream(statement).map(val -> io.vertx.reactivex.cassandra.CassandraRowStream.newInstance((io.vertx.cassandra.CassandraRowStream)val));
    return ret;
  }

  /**
   * Executes the given SQL statement which returns the results of the query as a read stream.
   * @param statement the statement to execute.
   * @return a future of the result
   */
  public io.reactivex.Single<io.vertx.reactivex.cassandra.CassandraRowStream> rxQueryStream(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.queryStream(statement).onComplete($handler);
    });
  }

  /**
   * Get  for the session.
   * @return a future of the result
   */
  public io.vertx.core.Future<com.datastax.oss.driver.api.core.metadata.Metadata> metadata() { 
    io.vertx.core.Future<com.datastax.oss.driver.api.core.metadata.Metadata> ret = delegate.metadata().map(val -> val);
    return ret;
  }

  /**
   * Get  for the session.
   * @return a future of the result
   */
  public io.reactivex.Single<com.datastax.oss.driver.api.core.metadata.Metadata> rxMetadata() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.metadata().onComplete($handler);
    });
  }

  /**
   * The default shared client name.
   */
  public static final java.lang.String DEFAULT_SHARED_CLIENT_NAME = io.vertx.cassandra.CassandraClient.DEFAULT_SHARED_CLIENT_NAME;
  public static CassandraClient newInstance(io.vertx.cassandra.CassandraClient arg) {
    return arg != null ? new CassandraClient(arg) : null;
  }

}
