/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.amqp;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * AMQP Sender interface used to send messages.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpSender original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.amqp.AmqpSender.class)
public class AmqpSender implements RxDelegate, io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.amqp.AmqpMessage> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpSender that = (AmqpSender) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AmqpSender> __TYPE_ARG = new TypeArg<>(    obj -> new AmqpSender((io.vertx.amqp.AmqpSender) obj),
    AmqpSender::getDelegate
  );

  private final io.vertx.amqp.AmqpSender delegate;
  
  public AmqpSender(io.vertx.amqp.AmqpSender delegate) {
    this.delegate = delegate;
  }

  public AmqpSender(Object delegate) {
    this.delegate = (io.vertx.amqp.AmqpSender)delegate;
  }

  @Override 
  public io.vertx.amqp.AmqpSender getDelegate() {
    return delegate;
  }

  private WriteStreamObserver<io.vertx.reactivex.amqp.AmqpMessage> observer;
  private WriteStreamSubscriber<io.vertx.reactivex.amqp.AmqpMessage> subscriber;

  public synchronized WriteStreamObserver<io.vertx.reactivex.amqp.AmqpMessage> toObserver() {
    if (observer == null) {
      Function<io.vertx.reactivex.amqp.AmqpMessage, io.vertx.amqp.AmqpMessage> conv = io.vertx.reactivex.amqp.AmqpMessage::getDelegate;
      observer = RxHelper.toObserver(getDelegate(), conv);
    }
    return observer;
  }

  public synchronized WriteStreamSubscriber<io.vertx.reactivex.amqp.AmqpMessage> toSubscriber() {
    if (subscriber == null) {
      Function<io.vertx.reactivex.amqp.AmqpMessage, io.vertx.amqp.AmqpMessage> conv = io.vertx.reactivex.amqp.AmqpMessage::getDelegate;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  private static final TypeArg<io.vertx.reactivex.amqp.AmqpMessage> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.amqp.AmqpMessage>(o1 -> io.vertx.reactivex.amqp.AmqpMessage.newInstance((io.vertx.amqp.AmqpMessage)o1), o1 -> o1.getDelegate());

  /**
   * Write some data to the stream.
   *
   * <p> The data is usually put on an internal write queue, and the write actually happens
   * asynchronously. To avoid running out of memory by putting too much on the write queue,
   * check the {@link io.vertx.reactivex.core.streams.WriteStream#writeQueueFull} method before writing. This is done automatically if
   * using a .
   *
   * <p> When the <code>data</code> is moved from the queue to the actual medium, the returned
   *  will be completed with the write result, e.g the future is succeeded
   * when a server HTTP response buffer is written to the socket and failed if the remote
   * client has closed the socket while the data was still pending for write.
   * @param data the data to write
   * @return a future completed with the write result
   */
  public io.vertx.core.Future<java.lang.Void> write(io.vertx.reactivex.amqp.AmqpMessage data) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.write(data.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Write some data to the stream.
   *
   * <p> The data is usually put on an internal write queue, and the write actually happens
   * asynchronously. To avoid running out of memory by putting too much on the write queue,
   * check the {@link io.vertx.reactivex.core.streams.WriteStream#writeQueueFull} method before writing. This is done automatically if
   * using a .
   *
   * <p> When the <code>data</code> is moved from the queue to the actual medium, the returned
   *  will be completed with the write result, e.g the future is succeeded
   * when a server HTTP response buffer is written to the socket and failed if the remote
   * client has closed the socket while the data was still pending for write.
   * @param data the data to write
   * @return a future completed with the write result
   */
  public io.reactivex.Completable rxWrite(io.vertx.reactivex.amqp.AmqpMessage data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.write(data).onComplete($handler);
    });
  }

  /**
   * Ends the stream.
   * <p>
   * Once the stream has ended, it cannot be used any more.
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> end() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.end().map(val -> val);
    return ret;
  }

  /**
   * Ends the stream.
   * <p>
   * Once the stream has ended, it cannot be used any more.
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxEnd() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.end().onComplete($handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but writes some data to the stream before ending.
   * @param data the data to write
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> end(io.vertx.reactivex.amqp.AmqpMessage data) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.end(data.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but writes some data to the stream before ending.
   * @param data the data to write
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxEnd(io.vertx.reactivex.amqp.AmqpMessage data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.end(data).onComplete($handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.reactivex.amqp.AmqpSender#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Set a drain handler on the stream. If the write queue is full, then the handler will be called when the write
   * queue is ready to accept buffers again. See  for an example of this being used.
   *
   * <p> The stream implementation defines when the drain handler, for example it could be when the queue size has been
   * reduced to <code>maxSize / 2</code>.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.amqp.AmqpMessage> drainHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.reactivex.amqp.AmqpSender exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.amqp.AmqpSender setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  /**
   * Sends an AMQP message. The destination the configured sender address or the address configured in the message.
   * @param message the message, must not be <code>null</code>
   * @return the current sender
   */
  public io.vertx.reactivex.amqp.AmqpSender send(io.vertx.reactivex.amqp.AmqpMessage message) { 
    delegate.send(message.getDelegate());
    return this;
  }

  /**
   * Sends an AMQP message and waits for an acknowledgement. It returns a future marked as failed if the message
   * has been rejected or re-routed. If the message has been accepted, the handler is called with a success.
   * @param message the message, must not be <code>null</code>
   * @return a future notified with the acknowledgement
   */
  public io.vertx.core.Future<java.lang.Void> sendWithAck(io.vertx.reactivex.amqp.AmqpMessage message) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.sendWithAck(message.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Sends an AMQP message and waits for an acknowledgement. It returns a future marked as failed if the message
   * has been rejected or re-routed. If the message has been accepted, the handler is called with a success.
   * @param message the message, must not be <code>null</code>
   * @return a future notified with the acknowledgement
   */
  public io.reactivex.Completable rxSendWithAck(io.vertx.reactivex.amqp.AmqpMessage message) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.sendWithAck(message).onComplete($handler);
    });
  }

  /**
   * Closes the sender.
   * @return a future notified when the sender has been closed
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Closes the sender.
   * @return a future notified when the sender has been closed
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * @return the configured address.
   */
  public java.lang.String address() { 
    java.lang.String ret = delegate.address();
    return ret;
  }

  /**
   * Gets the connection having created the sender. Cannot be <code>null</code>
   * @return the connection having created the sender.
   */
  public io.vertx.reactivex.amqp.AmqpConnection connection() { 
    io.vertx.reactivex.amqp.AmqpConnection ret = io.vertx.reactivex.amqp.AmqpConnection.newInstance((io.vertx.amqp.AmqpConnection)delegate.connection());
    return ret;
  }

  /**
   * @return the remaining credit, 0 is none.
   */
  public long remainingCredits() { 
    long ret = delegate.remainingCredits();
    return ret;
  }

  /**
   * @return the underlying ProtonSender.
   */
  public io.vertx.proton.ProtonSender unwrap() { 
    io.vertx.proton.ProtonSender ret = delegate.unwrap();
    return ret;
  }

  public static AmqpSender newInstance(io.vertx.amqp.AmqpSender arg) {
    return arg != null ? new AmqpSender(arg) : null;
  }

}
