/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.amqp;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * AMQP Client entry point.
 * Use this interface to create an instance of {@link io.vertx.reactivex.amqp.AmqpClient} and connect to a broker and server.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.amqp.AmqpClient.class)
public class AmqpClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpClient that = (AmqpClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AmqpClient> __TYPE_ARG = new TypeArg<>(    obj -> new AmqpClient((io.vertx.amqp.AmqpClient) obj),
    AmqpClient::getDelegate
  );

  private final io.vertx.amqp.AmqpClient delegate;
  
  public AmqpClient(io.vertx.amqp.AmqpClient delegate) {
    this.delegate = delegate;
  }

  public AmqpClient(Object delegate) {
    this.delegate = (io.vertx.amqp.AmqpClient)delegate;
  }

  @Override 
  public io.vertx.amqp.AmqpClient getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.amqp.AmqpConnection> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.amqp.AmqpConnection>(o1 -> io.vertx.reactivex.amqp.AmqpConnection.newInstance((io.vertx.amqp.AmqpConnection)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.amqp.AmqpReceiver> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.amqp.AmqpReceiver>(o1 -> io.vertx.reactivex.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.amqp.AmqpReceiver> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.amqp.AmqpReceiver>(o1 -> io.vertx.reactivex.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.amqp.AmqpSender> TYPE_ARG_3 = new TypeArg<io.vertx.reactivex.amqp.AmqpSender>(o1 -> io.vertx.reactivex.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.amqp.AmqpSender> TYPE_ARG_4 = new TypeArg<io.vertx.reactivex.amqp.AmqpSender>(o1 -> io.vertx.reactivex.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)o1), o1 -> o1.getDelegate());

  /**
   * Creates a new instance of {@link io.vertx.reactivex.amqp.AmqpClient} using an internal Vert.x instance (with default configuration) and
   * the given AMQP client configuration. Note that the created Vert.x instance will be closed when the client is
   * closed.
   * @param options the AMQP client options, may be <code>null</code> falling back to the default configuration
   * @return the created instances.
   */
  public static io.vertx.reactivex.amqp.AmqpClient create(io.vertx.amqp.AmqpClientOptions options) { 
    io.vertx.reactivex.amqp.AmqpClient ret = io.vertx.reactivex.amqp.AmqpClient.newInstance((io.vertx.amqp.AmqpClient)io.vertx.amqp.AmqpClient.create(options));
    return ret;
  }

  /**
   * Creates a new instance of {@link io.vertx.reactivex.amqp.AmqpClient} with the given Vert.x instance and the given options.
   * @param vertx the vert.x instance, must not be <code>null</code>
   * @param options the AMQP options, may be @{code null} falling back to the default configuration
   * @return the AMQP client instance
   */
  public static io.vertx.reactivex.amqp.AmqpClient create(io.vertx.reactivex.core.Vertx vertx, io.vertx.amqp.AmqpClientOptions options) { 
    io.vertx.reactivex.amqp.AmqpClient ret = io.vertx.reactivex.amqp.AmqpClient.newInstance((io.vertx.amqp.AmqpClient)io.vertx.amqp.AmqpClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Connects to the AMQP broker or router. The location is specified in the {@link io.vertx.amqp.AmqpClientOptions} as well as the
   * potential credential required.
   * @return a future notified with the result, giving either the connection or failure cause. Must not be <code>null</code>.
   */
  public io.vertx.core.Future<io.vertx.reactivex.amqp.AmqpConnection> connect() { 
    io.vertx.core.Future<io.vertx.reactivex.amqp.AmqpConnection> ret = delegate.connect().map(val -> io.vertx.reactivex.amqp.AmqpConnection.newInstance((io.vertx.amqp.AmqpConnection)val));
    return ret;
  }

  /**
   * Connects to the AMQP broker or router. The location is specified in the {@link io.vertx.amqp.AmqpClientOptions} as well as the
   * potential credential required.
   * @return a future notified with the result, giving either the connection or failure cause. Must not be <code>null</code>.
   */
  public io.reactivex.Single<io.vertx.reactivex.amqp.AmqpConnection> rxConnect() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.connect().onComplete($handler);
    });
  }

  /**
   * Closes the client.
   * The client must always be closed once not needed anymore.
   * @return a future notified when the operation completes
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Closes the client.
   * The client must always be closed once not needed anymore.
   * @return a future notified when the operation completes
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * Creates a receiver used to consume messages from the given address. The receiver has no handler and won't
   * start receiving messages until a handler is explicitly configured. This method avoids having to connect explicitly.
   * You can retrieve the connection using {@link io.vertx.reactivex.amqp.AmqpReceiver#connection}.
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @return a future notified with the receiver. The receiver has been opened.
   */
  public io.vertx.core.Future<io.vertx.reactivex.amqp.AmqpReceiver> createReceiver(java.lang.String address) { 
    io.vertx.core.Future<io.vertx.reactivex.amqp.AmqpReceiver> ret = delegate.createReceiver(address).map(val -> io.vertx.reactivex.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)val));
    return ret;
  }

  /**
   * Creates a receiver used to consume messages from the given address. The receiver has no handler and won't
   * start receiving messages until a handler is explicitly configured. This method avoids having to connect explicitly.
   * You can retrieve the connection using {@link io.vertx.reactivex.amqp.AmqpReceiver#connection}.
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @return a future notified with the receiver. The receiver has been opened.
   */
  public io.reactivex.Single<io.vertx.reactivex.amqp.AmqpReceiver> rxCreateReceiver(java.lang.String address) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.createReceiver(address).onComplete($handler);
    });
  }

  /**
   * Creates a receiver used to consumer messages from the given address.  This method avoids having to connect
   * explicitly. You can retrieve the connection using {@link io.vertx.reactivex.amqp.AmqpReceiver#connection}.
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @return a future notified with the receiver, once opened. Note that the <code>messageHandler</code> can be called before the <code>completionHandler</code> if messages are awaiting delivery.
   */
  public io.vertx.core.Future<io.vertx.reactivex.amqp.AmqpReceiver> createReceiver(java.lang.String address, io.vertx.amqp.AmqpReceiverOptions receiverOptions) { 
    io.vertx.core.Future<io.vertx.reactivex.amqp.AmqpReceiver> ret = delegate.createReceiver(address, receiverOptions).map(val -> io.vertx.reactivex.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)val));
    return ret;
  }

  /**
   * Creates a receiver used to consumer messages from the given address.  This method avoids having to connect
   * explicitly. You can retrieve the connection using {@link io.vertx.reactivex.amqp.AmqpReceiver#connection}.
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @return a future notified with the receiver, once opened. Note that the <code>messageHandler</code> can be called before the <code>completionHandler</code> if messages are awaiting delivery.
   */
  public io.reactivex.Single<io.vertx.reactivex.amqp.AmqpReceiver> rxCreateReceiver(java.lang.String address, io.vertx.amqp.AmqpReceiverOptions receiverOptions) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.createReceiver(address, receiverOptions).onComplete($handler);
    });
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * @param address The target address to attach to, must not be <code>null</code>
   * @return a future notified with the sender, once opened
   */
  public io.vertx.core.Future<io.vertx.reactivex.amqp.AmqpSender> createSender(java.lang.String address) { 
    io.vertx.core.Future<io.vertx.reactivex.amqp.AmqpSender> ret = delegate.createSender(address).map(val -> io.vertx.reactivex.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)val));
    return ret;
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * @param address The target address to attach to, must not be <code>null</code>
   * @return a future notified with the sender, once opened
   */
  public io.reactivex.Single<io.vertx.reactivex.amqp.AmqpSender> rxCreateSender(java.lang.String address) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.createSender(address).onComplete($handler);
    });
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * @param address The target address to attach to, must not be <code>null</code>
   * @param options The options for this sender.
   * @return a future notified with the sender, once opened
   */
  public io.vertx.core.Future<io.vertx.reactivex.amqp.AmqpSender> createSender(java.lang.String address, io.vertx.amqp.AmqpSenderOptions options) { 
    io.vertx.core.Future<io.vertx.reactivex.amqp.AmqpSender> ret = delegate.createSender(address, options).map(val -> io.vertx.reactivex.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)val));
    return ret;
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * @param address The target address to attach to, must not be <code>null</code>
   * @param options The options for this sender.
   * @return a future notified with the sender, once opened
   */
  public io.reactivex.Single<io.vertx.reactivex.amqp.AmqpSender> rxCreateSender(java.lang.String address, io.vertx.amqp.AmqpSenderOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.createSender(address, options).onComplete($handler);
    });
  }

  public static AmqpClient newInstance(io.vertx.amqp.AmqpClient arg) {
    return arg != null ? new AmqpClient(arg) : null;
  }

}
