/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.net;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import io.vertx.reactivex.core.streams.Pipe;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import javax.net.ssl.SSLSession;

@RxGen(value=io.vertx.core.net.NetSocket.class)
public class NetSocket
implements RxDelegate,
io.vertx.reactivex.core.streams.ReadStream<Buffer>,
io.vertx.reactivex.core.streams.WriteStream<Buffer> {
    public static final TypeArg<NetSocket> __TYPE_ARG = new TypeArg(obj -> new NetSocket((io.vertx.core.net.NetSocket)obj), NetSocket::getDelegate);
    private final io.vertx.core.net.NetSocket delegate;
    private Observable<Buffer> observable;
    private Flowable<Buffer> flowable;
    private WriteStreamObserver<Buffer> observer;
    private WriteStreamSubscriber<Buffer> subscriber;
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetSocket that = (NetSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public NetSocket(io.vertx.core.net.NetSocket delegate) {
        this.delegate = delegate;
    }

    public NetSocket(Object delegate) {
        this.delegate = (io.vertx.core.net.NetSocket)delegate;
    }

    public io.vertx.core.net.NetSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Buffer> toObservable() {
        if (this.observable == null) {
            this.observable = ObservableHelper.toObservable((ReadStream)this.getDelegate());
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<Buffer> toFlowable() {
        if (this.flowable == null) {
            this.flowable = FlowableHelper.toFlowable((ReadStream)this.getDelegate());
        }
        return this.flowable;
    }

    @Override
    public synchronized WriteStreamObserver<Buffer> toObserver() {
        if (this.observer == null) {
            this.observer = RxHelper.toObserver((WriteStream)this.getDelegate());
        }
        return this.observer;
    }

    @Override
    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            this.subscriber = RxHelper.toSubscriber((WriteStream)this.getDelegate());
        }
        return this.subscriber;
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TypeArg.unknown());
        return ret;
    }

    @Override
    public Future<Void> pipeTo(io.vertx.reactivex.core.streams.WriteStream<Buffer> dst) {
        Future ret = this.delegate.pipeTo(dst.getDelegate()).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<Buffer> dst) {
        return AsyncResultCompletable.toCompletable($handler -> this.pipeTo(dst).onComplete($handler));
    }

    @Override
    public Future<Void> write(Buffer data) {
        Future ret = this.delegate.write((Object)data).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxWrite(Buffer data) {
        return AsyncResultCompletable.toCompletable($handler -> this.write(data).onComplete($handler));
    }

    @Override
    public Future<Void> end(Buffer data) {
        Future ret = this.delegate.end((Object)data).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxEnd(Buffer data) {
        return AsyncResultCompletable.toCompletable($handler -> this.end(data).onComplete($handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public NetSocket exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public NetSocket handler(Handler<Buffer> handler) {
        this.delegate.handler(handler);
        return this;
    }

    public NetSocket pause() {
        this.delegate.pause();
        return this;
    }

    public NetSocket resume() {
        this.delegate.resume();
        return this;
    }

    public NetSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public NetSocket endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public NetSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public NetSocket drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public String writeHandlerID() {
        String ret = this.delegate.writeHandlerID();
        return ret;
    }

    @Override
    public Future<Void> write(String str) {
        Future ret = this.delegate.write(str).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxWrite(String str) {
        return AsyncResultCompletable.toCompletable($handler -> this.write(str).onComplete($handler));
    }

    public Future<Void> write(String str, String enc) {
        Future ret = this.delegate.write(str, enc).map(val -> val);
        return ret;
    }

    public Completable rxWrite(String str, String enc) {
        return AsyncResultCompletable.toCompletable($handler -> this.write(str, enc).onComplete($handler));
    }

    public Future<Void> sendFile(String filename) {
        Future ret = this.delegate.sendFile(filename).map(val -> val);
        return ret;
    }

    public Completable rxSendFile(String filename) {
        return AsyncResultCompletable.toCompletable($handler -> this.sendFile(filename).onComplete($handler));
    }

    public Future<Void> sendFile(String filename, long offset) {
        Future ret = this.delegate.sendFile(filename, offset).map(val -> val);
        return ret;
    }

    public Completable rxSendFile(String filename, long offset) {
        return AsyncResultCompletable.toCompletable($handler -> this.sendFile(filename, offset).onComplete($handler));
    }

    public Future<Void> sendFile(String filename, long offset, long length) {
        Future ret = this.delegate.sendFile(filename, offset, length).map(val -> val);
        return ret;
    }

    public Completable rxSendFile(String filename, long offset, long length) {
        return AsyncResultCompletable.toCompletable($handler -> this.sendFile(filename, offset, length).onComplete($handler));
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = this.delegate.remoteAddress();
        return ret;
    }

    public SocketAddress remoteAddress(boolean real) {
        SocketAddress ret = this.delegate.remoteAddress(real);
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = this.delegate.localAddress();
        return ret;
    }

    public SocketAddress localAddress(boolean real) {
        SocketAddress ret = this.delegate.localAddress(real);
        return ret;
    }

    @Override
    public Future<Void> end() {
        Future ret = this.delegate.end().map(val -> val);
        return ret;
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable($handler -> this.end().onComplete($handler));
    }

    public Future<Void> close() {
        Future ret = this.delegate.close().map(val -> val);
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close().onComplete($handler));
    }

    public NetSocket closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public NetSocket shutdownHandler(Handler<Void> handler) {
        this.delegate.shutdownHandler(handler);
        return this;
    }

    public Future<Void> upgradeToSsl() {
        Future ret = this.delegate.upgradeToSsl().map(val -> val);
        return ret;
    }

    public Completable rxUpgradeToSsl() {
        return AsyncResultCompletable.toCompletable($handler -> this.upgradeToSsl().onComplete($handler));
    }

    public Future<Void> upgradeToSsl(Buffer msg) {
        Future ret = this.delegate.upgradeToSsl(msg).map(val -> val);
        return ret;
    }

    public Completable rxUpgradeToSsl(Buffer msg) {
        return AsyncResultCompletable.toCompletable($handler -> this.upgradeToSsl(msg).onComplete($handler));
    }

    public Future<Void> upgradeToSsl(String serverName) {
        Future ret = this.delegate.upgradeToSsl(serverName).map(val -> val);
        return ret;
    }

    public Completable rxUpgradeToSsl(String serverName) {
        return AsyncResultCompletable.toCompletable($handler -> this.upgradeToSsl(serverName).onComplete($handler));
    }

    public Future<Void> upgradeToSsl(String serverName, Buffer msg) {
        Future ret = this.delegate.upgradeToSsl(serverName, msg).map(val -> val);
        return ret;
    }

    public Completable rxUpgradeToSsl(String serverName, Buffer msg) {
        return AsyncResultCompletable.toCompletable($handler -> this.upgradeToSsl(serverName, msg).onComplete($handler));
    }

    public Future<Void> upgradeToSsl(SSLOptions sslOptions, String serverName) {
        Future ret = this.delegate.upgradeToSsl(sslOptions, serverName).map(val -> val);
        return ret;
    }

    public Completable rxUpgradeToSsl(SSLOptions sslOptions, String serverName) {
        return AsyncResultCompletable.toCompletable($handler -> this.upgradeToSsl(sslOptions, serverName).onComplete($handler));
    }

    public Future<Void> upgradeToSsl(SSLOptions sslOptions, Buffer msg) {
        Future ret = this.delegate.upgradeToSsl(sslOptions, msg).map(val -> val);
        return ret;
    }

    public Completable rxUpgradeToSsl(SSLOptions sslOptions, Buffer msg) {
        return AsyncResultCompletable.toCompletable($handler -> this.upgradeToSsl(sslOptions, msg).onComplete($handler));
    }

    public Future<Void> upgradeToSsl(SSLOptions sslOptions, String serverName, Buffer upgrade) {
        Future ret = this.delegate.upgradeToSsl(sslOptions, serverName, upgrade).map(val -> val);
        return ret;
    }

    public Completable rxUpgradeToSsl(SSLOptions sslOptions, String serverName, Buffer upgrade) {
        return AsyncResultCompletable.toCompletable($handler -> this.upgradeToSsl(sslOptions, serverName, upgrade).onComplete($handler));
    }

    public Future<Void> upgradeToSsl(SSLOptions sslOptions) {
        Future ret = this.delegate.upgradeToSsl(sslOptions).map(val -> val);
        return ret;
    }

    public Completable rxUpgradeToSsl(SSLOptions sslOptions) {
        return AsyncResultCompletable.toCompletable($handler -> this.upgradeToSsl(sslOptions).onComplete($handler));
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public String indicatedServerName() {
        String ret = this.delegate.indicatedServerName();
        return ret;
    }

    public String applicationLayerProtocol() {
        String ret = this.delegate.applicationLayerProtocol();
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public static NetSocket newInstance(io.vertx.core.net.NetSocket arg) {
        return arg != null ? new NetSocket(arg) : null;
    }
}

