/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.grpc.examples.reactivex.helloworld;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * <p>A client for invoking the Greeter gRPC service.</p>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.grpc.examples.helloworld.GreeterClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.grpc.examples.helloworld.GreeterClient.class)
public class GreeterClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GreeterClient that = (GreeterClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GreeterClient> __TYPE_ARG = new TypeArg<>(    obj -> new GreeterClient((io.grpc.examples.helloworld.GreeterClient) obj),
    GreeterClient::getDelegate
  );

  private final io.grpc.examples.helloworld.GreeterClient delegate;
  
  public GreeterClient(io.grpc.examples.helloworld.GreeterClient delegate) {
    this.delegate = delegate;
  }

  public GreeterClient(Object delegate) {
    this.delegate = (io.grpc.examples.helloworld.GreeterClient)delegate;
  }

  @Override 
  public io.grpc.examples.helloworld.GreeterClient getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.core.streams.ReadStream<io.grpc.examples.helloworld.HelloReply>> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.streams.ReadStream<io.grpc.examples.helloworld.HelloReply>>(o1 -> io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)o1, TypeArg.unknown()), o1 -> o1.getDelegate());

  /**
   * Calls the SayHello RPC service method.
   * @param request the io.grpc.examples.helloworld.HelloRequest request message
   * @return a future of the io.grpc.examples.helloworld.HelloReply response message
   */
  public io.vertx.core.Future<io.grpc.examples.helloworld.HelloReply> sayHello(io.grpc.examples.helloworld.HelloRequest request) { 
    io.vertx.core.Future<io.grpc.examples.helloworld.HelloReply> ret = delegate.sayHello(request).map(val -> val);
    return ret;
  }

  /**
   * Calls the SayHello RPC service method.
   * @param request the io.grpc.examples.helloworld.HelloRequest request message
   * @return a future of the io.grpc.examples.helloworld.HelloReply response message
   */
  public io.reactivex.Single<io.grpc.examples.helloworld.HelloReply> rxSayHello(io.grpc.examples.helloworld.HelloRequest request) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.sayHello(request).onComplete($handler);
    });
  }

  /**
   * Calls the SayHelloStreaming RPC service method.
   * @param streamOfMessages a stream of messages to be sent to the service
   * @return a future of the io.grpc.examples.helloworld.HelloReply response messages
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.streams.ReadStream<io.grpc.examples.helloworld.HelloReply>> sayHelloStreaming(io.vertx.reactivex.core.streams.ReadStream<io.grpc.examples.helloworld.HelloRequest> streamOfMessages) { 
    io.vertx.core.Future<io.vertx.reactivex.core.streams.ReadStream<io.grpc.examples.helloworld.HelloReply>> ret = delegate.sayHelloStreaming(streamOfMessages.getDelegate()).map(val -> io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)val, TypeArg.unknown()));
    return ret;
  }

  /**
   * Calls the SayHelloStreaming RPC service method.
   * @param streamOfMessages a stream of messages to be sent to the service
   * @return a future of the io.grpc.examples.helloworld.HelloReply response messages
   */
  public io.reactivex.Flowable<io.grpc.examples.helloworld.HelloReply> rxSayHelloStreaming(io.vertx.reactivex.core.streams.ReadStream<io.grpc.examples.helloworld.HelloRequest> streamOfMessages) { 
    return AsyncResultFlowable.toFlowable($handler -> {
      this.sayHelloStreaming(streamOfMessages).map(stream_ -> (io.vertx.core.streams.ReadStream<io.grpc.examples.helloworld.HelloReply>)stream_.getDelegate()).onComplete($handler);
    });
  }

  /**
   * Calls the SayHelloStreaming RPC service method.
   * @param streamOfMessages a stream of messages to be sent to the service
   * @return a future of the io.grpc.examples.helloworld.HelloReply response messages
   */
  public io.vertx.core.Future<io.vertx.reactivex.core.streams.ReadStream<io.grpc.examples.helloworld.HelloReply>> sayHelloStreaming(io.reactivex.Flowable<io.grpc.examples.helloworld.HelloRequest> streamOfMessages) { 
    io.vertx.core.Future<io.vertx.reactivex.core.streams.ReadStream<io.grpc.examples.helloworld.HelloReply>> ret = delegate.sayHelloStreaming(io.vertx.reactivex.impl.ReadStreamSubscriber.asReadStream(streamOfMessages, obj -> obj).resume()).map(val -> io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)val, TypeArg.unknown()));
    return ret;
  }

  /**
   * Calls the SayHelloStreaming RPC service method.
   * @param streamOfMessages a stream of messages to be sent to the service
   * @return a future of the io.grpc.examples.helloworld.HelloReply response messages
   */
  public io.reactivex.Flowable<io.grpc.examples.helloworld.HelloReply> rxSayHelloStreaming(io.reactivex.Flowable<io.grpc.examples.helloworld.HelloRequest> streamOfMessages) { 
    return AsyncResultFlowable.toFlowable($handler -> {
      this.sayHelloStreaming(streamOfMessages).map(stream_ -> (io.vertx.core.streams.ReadStream<io.grpc.examples.helloworld.HelloReply>)stream_.getDelegate()).onComplete($handler);
    });
  }

  public static GreeterClient newInstance(io.grpc.examples.helloworld.GreeterClient arg) {
    return arg != null ? new GreeterClient(arg) : null;
  }

}
