package io.grpc.examples.helloworld;

import io.vertx.core.Future;
import io.vertx.core.Completable;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.common.ServiceMethod;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.server.GrpcServerRequest;
import io.vertx.grpc.server.GrpcServer;
import io.vertx.grpc.server.Service;
import io.vertx.grpc.server.ServiceBuilder;

import com.google.protobuf.Descriptors;

import java.util.LinkedList;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>Provides support for RPC methods implementations of the Greeter gRPC service.</p>
 *
 * <p>The following methods of this class should be overridden to provide an implementation of the service:</p>
 * <ul>
 *   <li>SayHello</li>
 *   <li>SayHelloStreaming</li>
 * </ul>
 */
public class GreeterService implements Greeter {

  /**
   * Override this method to implement the SayHello RPC.
   */
  public Future<io.grpc.examples.helloworld.HelloReply> sayHello(io.grpc.examples.helloworld.HelloRequest request) {
    throw new UnsupportedOperationException("Not implemented");
  }

  protected void sayHello(io.grpc.examples.helloworld.HelloRequest request, Completable<io.grpc.examples.helloworld.HelloReply> response) {
    sayHello(request).onComplete(response);
  }

  /**
   * Override this method to implement the SayHelloStreaming RPC.
   */
  public Future<ReadStream<io.grpc.examples.helloworld.HelloReply>> sayHelloStreaming(ReadStream<io.grpc.examples.helloworld.HelloRequest> request) {
    throw new UnsupportedOperationException("Not implemented");
  }

  protected void sayHelloStreaming(ReadStream<io.grpc.examples.helloworld.HelloRequest> request, WriteStream<io.grpc.examples.helloworld.HelloReply> response) {
    sayHelloStreaming(request)
      .onComplete(ar -> {
        if (ar.succeeded()) {
          ReadStream<io.grpc.examples.helloworld.HelloReply> stream = ar.result();
          stream.pipeTo(response);
        } else {
          // Todo
        }
      });
  }
}
