/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.routematcher.test;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.routematcher.RouteMatcher;
import io.vertx.test.core.HttpTestBase;
import java.util.HashMap;
import java.util.Map;
import org.junit.Test;

public class RouteMatcherTest
extends HttpTestBase {
    @Test
    public void testRouteWithPattern1GET() {
        this.testRouteWithPattern1(HttpMethod.GET);
    }

    @Test
    public void testRouteWithPattern2GET() {
        this.testRouteWithPattern2(HttpMethod.GET);
    }

    @Test
    public void testRouteWithPattern3GET() {
        this.testRouteWithPattern3(HttpMethod.GET);
    }

    @Test
    public void testRouteWithPattern4GET() {
        this.testRouteWithPattern4(HttpMethod.GET);
    }

    @Test
    public void testRouteWithPattern5GET() {
        this.testRouteWithPattern5(HttpMethod.GET);
    }

    @Test
    public void testRouteWithPattern6GET() {
        this.testRouteWithPattern6(HttpMethod.GET);
    }

    @Test
    public void testRouteWithPattern7GET() {
        this.testRouteWithPattern6(HttpMethod.GET);
    }

    @Test
    public void testRouteWithPatternPUT() {
        this.testRouteWithPattern1(HttpMethod.PUT);
    }

    @Test
    public void testRouteWithPatternPOST() {
        this.testRouteWithPattern1(HttpMethod.POST);
    }

    @Test
    public void testRouteWithPatternDELETE() {
        this.testRouteWithPattern1(HttpMethod.DELETE);
    }

    @Test
    public void testRouteWithPatternHEAD() {
        this.testRouteWithPattern1(HttpMethod.HEAD);
    }

    @Test
    public void testRouteWithPatternOPTIONS() {
        this.testRouteWithPattern1(HttpMethod.OPTIONS);
    }

    @Test
    public void testRouteWithPatternTRACE() {
        this.testRouteWithPattern1(HttpMethod.TRACE);
    }

    @Test
    public void testRouteWithPatternCONNECT() {
        this.testRouteWithPattern1(HttpMethod.CONNECT);
    }

    @Test
    public void testRouteWithPatternPATCH() {
        this.testRouteWithPattern1(HttpMethod.PATCH);
    }

    @Test
    public void testRouteWithRegexGET() {
        this.testRouteWithRegex(HttpMethod.GET);
    }

    @Test
    public void testRouteWithRegexPUT() {
        this.testRouteWithRegex(HttpMethod.PUT);
    }

    @Test
    public void testRouteWithRegexPOST() {
        this.testRouteWithRegex(HttpMethod.POST);
    }

    @Test
    public void testRouteWithRegexDELETE() {
        this.testRouteWithRegex(HttpMethod.DELETE);
    }

    @Test
    public void testRouteWithRegexHEAD() {
        this.testRouteWithRegex(HttpMethod.HEAD);
    }

    @Test
    public void testRouteWithRegexOPTIONS() {
        this.testRouteWithRegex(HttpMethod.OPTIONS);
    }

    @Test
    public void testRouteWithRegexTRACE() {
        this.testRouteWithRegex(HttpMethod.TRACE);
    }

    @Test
    public void testRouteWithRegexCONNECT() {
        this.testRouteWithRegex(HttpMethod.CONNECT);
    }

    @Test
    public void testRouteWithRegexPATCH() {
        this.testRouteWithRegex(HttpMethod.PATCH);
    }

    @Test
    public void testRouteNoMatchPattern() {
        HashMap<String, String> params = new HashMap<String, String>();
        this.testRoute(false, "foo", params, HttpMethod.GET, "bar", false, false);
    }

    @Test
    public void testRouteNoMatchRegex() {
        HashMap<String, String> params = new HashMap<String, String>();
        this.testRoute(true, "foo", params, HttpMethod.GET, "bar", false, false);
    }

    @Test
    public void testRouteNoMatchHandlerPattern() {
        HashMap<String, String> params = new HashMap<String, String>();
        this.testRoute(false, "foo", params, HttpMethod.GET, "bar", false, true);
    }

    @Test
    public void testRouteNoMatchHandlerRegex() {
        HashMap<String, String> params = new HashMap<String, String>();
        this.testRoute(true, "foo", params, HttpMethod.GET, "bar", false, true);
    }

    private void testRouteWithPattern1(HttpMethod method) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "foo");
        params.put("version", "v0.1");
        this.testRoute(false, "/:name/:version", params, method, "/foo/v0.1");
    }

    private void testRouteWithPattern2(HttpMethod method) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "foo");
        params.put("version", "v0.1");
        this.testRoute(false, "modules/:name/:version", params, method, "modules/foo/v0.1");
    }

    private void testRouteWithPattern3(HttpMethod method) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "foo");
        params.put("version", "v0.1");
        this.testRoute(false, "modules/:name/:version/", params, method, "modules/foo/v0.1/");
    }

    private void testRouteWithPattern4(HttpMethod method) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "foo");
        params.put("version", "v0.1");
        this.testRoute(false, "modules/:name/:version/whatever", params, method, "modules/foo/v0.1/whatever");
    }

    private void testRouteWithPattern5(HttpMethod method) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "foo");
        params.put("version", "v0.1");
        this.testRoute(false, "modules/:name/blah/:version/whatever", params, method, "modules/foo/blah/v0.1/whatever");
    }

    private void testRouteWithPattern6(HttpMethod method) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "foo");
        this.testRoute(false, "/:name/", params, method, "/foo/");
    }

    private void testRouteWithRegex(HttpMethod method) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("param0", "foo");
        params.put("param1", "v0.1");
        String regex = "\\/([^\\/]+)\\/([^\\/]+)";
        this.testRoute(true, regex, params, method, "/foo/v0.1");
    }

    private void testRoute(boolean regex, String pattern, Map<String, String> params, HttpMethod method, String uri) {
        this.testRoute(regex, pattern, params, method, uri, true, false);
    }

    private void testRoute(boolean regex, String pattern, Map<String, String> params, HttpMethod method, String uri, boolean shouldPass, boolean noMatchHandler) {
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        this.client = this.vertx.createHttpClient(new HttpClientOptions());
        RouteMatcher matcher = RouteMatcher.routeMatcher();
        Handler handler = req -> {
            this.assertEquals(params.size(), req.params().size());
            for (Map.Entry entry : params.entrySet()) {
                this.assertEquals(entry.getValue(), req.params().get((String)entry.getKey()));
            }
            req.response().end();
        };
        if (regex) {
            matcher.matchMethodWithRegEx(method, pattern, handler);
        } else {
            matcher.matchMethod(method, pattern, handler);
        }
        String noMatchResponseBody = "oranges";
        if (noMatchHandler) {
            matcher.noMatch(req -> req.response().end("oranges"));
        }
        this.server.requestHandler(arg_0 -> ((RouteMatcher)matcher).accept(arg_0)).listen(this.onSuccess(s -> {
            Handler respHandler = resp -> {
                if (shouldPass) {
                    this.assertEquals(200L, resp.statusCode());
                    this.testComplete();
                } else if (noMatchHandler) {
                    this.assertEquals(200L, resp.statusCode());
                    resp.bodyHandler(body -> {
                        this.assertEquals("oranges", body.toString());
                        this.testComplete();
                    });
                } else {
                    this.assertEquals(404L, resp.statusCode());
                    this.testComplete();
                }
            };
            this.client.request(method, 8080, "localhost", uri, respHandler).end();
        }));
        this.await();
    }
}

