/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl.java;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.platform.impl.java.JavaSourceContext;
import org.vertx.java.platform.impl.java.MemoryFileManager;

public class CompilingClassLoader
extends ClassLoader {
    private static final Logger log = LoggerFactory.getLogger(CompilingClassLoader.class);
    private final JavaSourceContext javaSourceContext;
    private final MemoryFileManager fileManager;

    public CompilingClassLoader(ClassLoader loader, String sourceName) {
        block10: {
            File sourceFile;
            super(loader);
            URL resource = this.getResource(sourceName);
            if (resource == null) {
                throw new RuntimeException("Resource not found: " + sourceName);
            }
            try {
                sourceFile = new File(URLDecoder.decode(resource.getFile(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Failed to decode " + e.getMessage());
            }
            if (!sourceFile.canRead()) {
                throw new RuntimeException("File not found: " + sourceFile.getAbsolutePath() + " current dir is: " + new File(".").getAbsolutePath());
            }
            this.javaSourceContext = new JavaSourceContext(sourceFile);
            try {
                DiagnosticCollector diagnostics = new DiagnosticCollector();
                JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
                if (javaCompiler == null) {
                    throw new RuntimeException("Unable to detect java compiler, make sure you're using a JDK not a JRE!");
                }
                StandardJavaFileManager standardFileManager = javaCompiler.getStandardFileManager(null, null, null);
                standardFileManager.setLocation(StandardLocation.SOURCE_PATH, Collections.singleton(this.javaSourceContext.getSourceRoot()));
                this.fileManager = new MemoryFileManager(loader, standardFileManager);
                JavaFileObject javaFile = standardFileManager.getJavaFileForInput(StandardLocation.SOURCE_PATH, this.resolveMainClassName(), JavaFileObject.Kind.SOURCE);
                JavaCompiler.CompilationTask task = javaCompiler.getTask(null, this.fileManager, diagnostics, null, null, Collections.singleton(javaFile));
                boolean valid = task.call();
                if (valid) {
                    for (Diagnostic d : diagnostics.getDiagnostics()) {
                        log.info(d);
                    }
                    break block10;
                }
                for (Diagnostic d : diagnostics.getDiagnostics()) {
                    log.warn(d);
                }
                throw new RuntimeException("Compilation failed!");
            }
            catch (Exception e) {
                throw new RuntimeException("Compilation failed", e);
            }
        }
    }

    public String resolveMainClassName() {
        return this.javaSourceContext.getClassName();
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytecode = this.fileManager.getCompiledClass(name);
        if (bytecode == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, bytecode, 0, bytecode.length);
    }
}

