/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.platform.impl.Deployment;
import org.vertx.java.platform.impl.ModuleReloader;

public class Redeployer {
    private static final Logger log = LoggerFactory.getLogger(Redeployer.class);
    private static final long GRACE_PERIOD = 600L;
    private static final long CHECK_PERIOD = 200L;
    private final File modRoot;
    private final ModuleReloader reloader;
    private final Map<Path, Set<Deployment>> watchedDeployments = new HashMap<Path, Set<Deployment>>();
    private final Map<WatchKey, Path> watchKeys = new HashMap<WatchKey, Path>();
    private final Map<Path, Path> moduleDirs = new HashMap<Path, Path>();
    private final WatchService watchService;
    private final Vertx vertx;
    private final Map<Path, Long> changing = new HashMap<Path, Long>();
    private final long timerID;
    private final Queue<Deployment> toDeploy = new ConcurrentLinkedQueue<Deployment>();
    private final Queue<Deployment> toUndeploy = new ConcurrentLinkedQueue<Deployment>();
    private Thread thread;
    private boolean closed;

    public Redeployer(Vertx vertx, File modRoot, ModuleReloader reloader) {
        this.modRoot = modRoot;
        this.reloader = reloader;
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            log.error((Object)"Failed to create redeployer", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        this.vertx = vertx;
        this.timerID = vertx.setPeriodic(200L, (Handler)new Handler<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Long id) {
                Redeployer redeployer = Redeployer.this;
                synchronized (redeployer) {
                    if (!Redeployer.this.closed) {
                        Redeployer.this.checkThread();
                        try {
                            Redeployer.this.checkEvents();
                        }
                        catch (Exception e) {
                            log.error((Object)"Failed to check events", (Throwable)e);
                        }
                    }
                }
            }
        });
    }

    public synchronized void close() {
        this.vertx.cancelTimer(this.timerID);
        HashSet deps = new HashSet();
        for (Map.Entry<Path, Set<Deployment>> entry : this.watchedDeployments.entrySet()) {
            deps.addAll(entry.getValue());
        }
        this.toUndeploy.addAll(deps);
        this.processUndeployments();
        try {
            this.watchService.close();
        }
        catch (IOException ex) {
            log.warn((Object)("Error while shutting down watch service: " + ex.getMessage()), (Throwable)ex);
        }
        this.closed = true;
    }

    public void moduleDeployed(Deployment deployment) {
        this.toDeploy.add(deployment);
    }

    public void moduleUndeployed(Deployment deployment) {
        this.toUndeploy.add(deployment);
    }

    private void processDeployments() {
        Deployment dep;
        while ((dep = this.toDeploy.poll()) != null) {
            File fmodDir = new File(this.modRoot, dep.modID.toString());
            Path modDir = fmodDir.toPath();
            Set<Deployment> deps = this.watchedDeployments.get(modDir);
            if (deps == null) {
                deps = new HashSet<Deployment>();
                this.watchedDeployments.put(modDir, deps);
                try {
                    this.registerAll(modDir, modDir);
                }
                catch (IOException e) {
                    log.error((Object)"Failed to register", (Throwable)e);
                    throw new IllegalStateException(e.getMessage());
                }
            }
            deps.add(dep);
        }
    }

    private void processUndeployments() {
        Deployment dep;
        while ((dep = this.toUndeploy.poll()) != null) {
            File modDir = new File(this.modRoot, dep.modID.toString());
            Path pModDir = modDir.toPath();
            Set<Deployment> deps = this.watchedDeployments.get(pModDir);
            deps.remove(dep);
            if (!deps.isEmpty()) continue;
            this.watchedDeployments.remove(pModDir);
            HashSet<Path> modPaths = new HashSet<Path>();
            for (Map.Entry<Path, Path> entry : this.moduleDirs.entrySet()) {
                if (!entry.getValue().equals(pModDir)) continue;
                modPaths.add(entry.getKey());
            }
            for (Path p : modPaths) {
                this.moduleDirs.remove(p);
                this.changing.remove(p);
            }
            HashSet<WatchKey> keys = new HashSet<WatchKey>();
            for (Map.Entry<WatchKey, Path> entry : this.watchKeys.entrySet()) {
                if (!modPaths.contains(entry.getValue())) continue;
                keys.add(entry.getKey());
            }
            for (WatchKey key : keys) {
                key.cancel();
                this.watchKeys.remove(key);
            }
        }
    }

    void checkEvents() {
        WatchKey key;
        this.processUndeployments();
        this.processDeployments();
        HashSet<Path> changed = new HashSet<Path>();
        while ((key = this.watchService.poll()) != null) {
            this.handleEvent(key, changed);
        }
        long now = System.currentTimeMillis();
        for (Path modulePath : changed) {
            this.changing.put(modulePath, now);
        }
        HashSet<Path> toRedeploy = new HashSet<Path>();
        for (Map.Entry<Path, Long> entry : this.changing.entrySet()) {
            if (now - entry.getValue() <= 600L) continue;
            toRedeploy.add(entry.getKey());
        }
        if (!toRedeploy.isEmpty()) {
            HashSet<Deployment> deployments = new HashSet<Deployment>();
            for (Path moduleDir : toRedeploy) {
                log.info((Object)("moduleDir is " + moduleDir));
                log.info((Object)("Module has changed - redeploying module from directory " + moduleDir.toString()));
                this.changing.remove(moduleDir);
                deployments.addAll((Collection<Deployment>)this.watchedDeployments.get(moduleDir));
            }
            this.reloader.reloadModules(deployments);
        }
    }

    private void handleEvent(WatchKey key, Set<Path> changed) {
        Path dir = this.watchKeys.get(key);
        if (dir == null) {
            throw new IllegalStateException("Unrecognised watch key " + dir);
        }
        for (WatchEvent<?> event : key.pollEvents()) {
            WatchEvent.Kind<?> kind = event.kind();
            if (kind == StandardWatchEventKinds.OVERFLOW) {
                log.warn((Object)"Overflow event on watched directory");
                continue;
            }
            Path moduleDir = this.moduleDirs.get(dir);
            if (moduleDir == null) continue;
            WatchEvent<?> ev = event;
            Path name = (Path)ev.context();
            Path child = dir.resolve(name);
            if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                if (Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) {
                    try {
                        this.registerAll(moduleDir, child);
                    }
                    catch (IOException e) {
                        log.error((Object)"Failed to register child", (Throwable)e);
                        throw new IllegalStateException(e.getMessage());
                    }
                }
            } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                this.moduleDirs.remove(child);
            }
            changed.add(moduleDir);
        }
        boolean valid = key.reset();
        if (!valid) {
            this.watchKeys.remove(key);
        }
    }

    private void register(Path modDir, Path dir) throws IOException {
        WatchKey key = dir.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        this.watchKeys.put(key, dir);
        this.moduleDirs.put(dir, modDir);
    }

    private void registerAll(final Path modDir, Path dir) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Redeployer.this.register(modDir, dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void checkThread() {
        Thread curr = Thread.currentThread();
        if (this.thread == null) {
            this.thread = curr;
        } else if (curr != this.thread) {
            throw new IllegalStateException("Wrong thread: " + curr + " expected " + this.thread);
        }
    }
}

