/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl.resolver;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpClientRequest;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.platform.impl.ModuleIdentifier;

public abstract class HttpResolution {
    private static final Logger log = LoggerFactory.getLogger(HttpResolution.class);
    private static final String HTTP_PROXY_HOST_PROP_NAME = "http.proxyHost";
    private static final String HTTP_PROXY_PORT_PROP_NAME = "http.proxyPort";
    public static boolean suppressDownloadCounter = true;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final Vertx vertx;
    protected final String repoHost;
    protected final int repoPort;
    protected final ModuleIdentifier modID;
    protected final String filename;
    protected final String proxyHost = this.getProxyHost();
    protected final int proxyPort = this.getProxyPort();
    private final Map<Integer, Handler<HttpClientResponse>> handlers = new HashMap<Integer, Handler<HttpClientResponse>>();
    protected HttpClient client;
    private boolean result;

    public boolean waitResult() {
        while (true) {
            try {
                if (!this.latch.await(300L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Timed out waiting to download module");
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return this.result;
    }

    public HttpResolution(Vertx vertx, String repoHost, int repoPort, ModuleIdentifier modID, String filename) {
        this.vertx = vertx;
        this.repoHost = repoHost;
        this.repoPort = repoPort;
        this.modID = modID;
        this.filename = filename;
    }

    protected HttpClient createClient(String host, int port) {
        if (this.client != null) {
            throw new IllegalStateException("Client already created");
        }
        this.client = this.vertx.createHttpClient();
        if (this.proxyHost != null) {
            this.client.setHost(this.proxyHost);
            if (this.proxyPort != 80) {
                this.client.setPort(this.proxyPort);
            } else {
                this.client.setPort(80);
            }
        } else {
            this.client.setHost(host);
            this.client.setPort(port);
        }
        this.client.exceptionHandler((Handler)new Handler<Throwable>(){

            public void handle(Throwable t) {
                HttpResolution.this.end(false);
            }
        });
        return this.client;
    }

    protected void sendRequest(String host, int port, String uri, Handler<HttpClientResponse> respHandler) {
        String proxyHost = this.getProxyHost();
        if (proxyHost != null) {
            uri = "http://" + host + ":" + port + uri;
        }
        HttpClientRequest req = this.client.get(uri, respHandler);
        if (proxyHost != null) {
            req.putHeader("host", proxyHost);
        } else {
            req.putHeader("host", host);
        }
        req.putHeader("user-agent", "Vert.x Module Installer");
        req.end();
    }

    protected abstract void getModule();

    protected void makeRequest(String host, int port, String uri) {
        this.sendRequest(host, port, uri, new Handler<HttpClientResponse>(){

            public void handle(HttpClientResponse resp) {
                Handler handler = (Handler)HttpResolution.this.handlers.get(resp.statusCode());
                if (handler != null) {
                    handler.handle((Object)resp);
                } else {
                    HttpResolution.this.end(false);
                }
            }
        });
    }

    protected void end(boolean ok) {
        this.client.close();
        this.result = ok;
        this.latch.countDown();
    }

    protected void addHandler(int statusCode, Handler<HttpClientResponse> handler) {
        this.handlers.put(statusCode, handler);
    }

    protected void downloadToFile(String file, HttpClientResponse resp) {
        BufferedOutputStream os;
        log.info((Object)("Downloading " + this.modID + ". Please wait..."));
        try {
            os = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (IOException e) {
            log.error((Object)"Failed to open file", (Throwable)e);
            this.end(false);
            return;
        }
        final AtomicInteger written = new AtomicInteger();
        final int contentLength = Integer.valueOf(resp.headers().get("content-length"));
        resp.dataHandler((Handler)new Handler<Buffer>(){
            long lastPercent = 0L;

            public void handle(Buffer data) {
                int bytesWritten = written.get();
                try {
                    os.write(data.getBytes());
                }
                catch (IOException e) {
                    log.error((Object)"Failed to write to file", (Throwable)e);
                    HttpResolution.this.end(false);
                    return;
                }
                if (!suppressDownloadCounter) {
                    written.addAndGet(data.length());
                    long percent = Math.round(100.0 * (double)bytesWritten / (double)contentLength);
                    if (percent > this.lastPercent) {
                        System.out.print("\rDownloading " + percent + "%");
                        this.lastPercent = percent;
                    }
                }
            }
        });
        resp.endHandler((Handler)new VoidHandler(){

            protected void handle() {
                if (!suppressDownloadCounter) {
                    System.out.println("\rDownloading 100%");
                }
                try {
                    os.close();
                    HttpResolution.this.end(true);
                }
                catch (IOException e) {
                    log.error((Object)"Failed to flush file", (Throwable)e);
                    HttpResolution.this.end(false);
                }
            }
        });
    }

    private String getProxyHost() {
        return System.getProperty(HTTP_PROXY_HOST_PROP_NAME);
    }

    private int getProxyPort() {
        return Integer.valueOf(System.getProperty(HTTP_PROXY_PORT_PROP_NAME, "80"));
    }
}

