/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl;

public class ModuleIdentifier {
    private static final String SEPARATOR = "~";
    private static final String SPLIT_REGEX = "\\~";
    private final String owner;
    private final String name;
    private final String version;
    private final String stringForm;
    private static final String LEGAL = "[A-Za-z0-9!\u00a3$()-_+=@~;,]+";

    public ModuleIdentifier(String stringForm) {
        if (stringForm == null) {
            throw new NullPointerException("Module identifier cannot be null");
        }
        this.stringForm = stringForm;
        String[] parts = stringForm.split(SPLIT_REGEX);
        if (parts.length != 3) {
            throw this.createException("Should be of form owner~name~version");
        }
        if (parts[0].isEmpty()) {
            throw this.createException("owner should not be empty");
        }
        if (parts[1].isEmpty()) {
            throw this.createException("name should not be empty");
        }
        if (parts[2].isEmpty()) {
            throw this.createException("version should not be empty");
        }
        this.owner = parts[0];
        this.checkIllegalChars(this.owner);
        this.name = parts[1];
        this.checkIllegalChars(this.name);
        this.version = parts[2];
        this.checkIllegalChars(this.version);
    }

    private void checkIllegalChars(String str) {
        if (!str.matches(LEGAL)) {
            throw new IllegalArgumentException("Module identifier: " + str + " contains illegal characters");
        }
    }

    private IllegalArgumentException createException(String msg) {
        return new IllegalArgumentException("Invalid module identifier: " + this.stringForm + ". " + msg);
    }

    public String toString() {
        return this.stringForm;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public static ModuleIdentifier createInternalModIDForVerticle(String depName) {
        return new ModuleIdentifier("__vertx~" + depName + SEPARATOR + "__vertx");
    }
}

