/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.vertx.java.core.impl.ConcurrentHashSet;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.platform.impl.ModuleReference;

public class ModuleClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(ModuleClassLoader.class);
    private static boolean loadWithPlatformCL;
    private static ThreadLocal<Set<ModuleClassLoader>> circDepTL;
    private static ThreadLocal<Integer> recurseDepth;
    private final Set<ModuleReference> parents = new ConcurrentHashSet();
    private final ClassLoader platformClassLoader;

    public ModuleClassLoader(ClassLoader platformClassLoader, URL[] classpath) {
        super(classpath);
        this.platformClassLoader = platformClassLoader;
    }

    public void addParent(ModuleReference parent) {
        this.parents.add(parent);
    }

    @Override
    public void close() {
        this.clearParents();
    }

    private void clearParents() {
        for (ModuleReference parent : this.parents) {
            parent.decRef();
        }
        this.parents.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        block16: {
            c = this.findLoadedClass(name);
            if (c == null) {
                if (loadWithPlatformCL) {
                    try {
                        c = this.platformClassLoader.loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                if (c == null) {
                    try {
                        c = this.findClass(name);
                        if (resolve) {
                            this.resolveClass(c);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        try {
                            this.incRecurseDepth();
                            Set<ModuleClassLoader> walked = this.getWalked();
                            walked.add(this);
                            for (ModuleReference parent : this.parents) {
                                this.checkAlreadyWalked(walked, parent);
                                try {
                                    c = parent.mcl.loadClass(name);
                                    break;
                                }
                                catch (ClassNotFoundException e1) {
                                }
                            }
                            walked.remove(this);
                        }
                        finally {
                            this.checkClearTLs();
                        }
                        if (c != null) break block16;
                        if (loadWithPlatformCL) {
                            throw e;
                        }
                        c = this.platformClassLoader.loadClass(name);
                    }
                }
            }
        }
        return c;
    }

    private Set<ModuleClassLoader> getWalked() {
        Set<ModuleClassLoader> walked = circDepTL.get();
        if (walked == null) {
            walked = new HashSet<ModuleClassLoader>();
            circDepTL.set(walked);
        }
        return walked;
    }

    private void checkAlreadyWalked(Set<ModuleClassLoader> walked, ModuleReference mr) {
        if (walked.contains(mr.mcl)) {
            this.clearParents();
            throw new IllegalStateException("Circular dependency in module includes. " + mr.moduleKey);
        }
    }

    private void incRecurseDepth() {
        Integer depth = recurseDepth.get();
        recurseDepth.set(depth == null ? 1 : depth + 1);
    }

    private int decRecurseDepth() {
        Integer depth = recurseDepth.get();
        depth = depth - 1;
        recurseDepth.set(depth);
        return depth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        this.incRecurseDepth();
        try {
            URL url = this.findResource(name);
            if (url == null) {
                Set<ModuleClassLoader> walked = this.getWalked();
                walked.add(this);
                for (ModuleReference parent : this.parents) {
                    this.checkAlreadyWalked(walked, parent);
                    url = parent.mcl.getResource(name);
                    if (url == null) continue;
                    URL uRL = url;
                    return uRL;
                }
                walked.remove(this);
                url = this.platformClassLoader.getResource(name);
            }
            URL uRL = url;
            return uRL;
        }
        finally {
            this.checkClearTLs();
        }
    }

    private void checkClearTLs() {
        if (this.decRecurseDepth() == 0) {
            circDepTL.remove();
            recurseDepth.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        final ArrayList<URL> totURLs = new ArrayList<URL>();
        this.addURLs(totURLs, this.findResources(name));
        try {
            this.incRecurseDepth();
            Set<ModuleClassLoader> walked = this.getWalked();
            walked.add(this);
            for (ModuleReference parent : this.parents) {
                this.checkAlreadyWalked(walked, parent);
                Enumeration<URL> urls = parent.mcl.getResources(name);
                this.addURLs(totURLs, urls);
            }
            walked.remove(this);
        }
        finally {
            this.checkClearTLs();
        }
        this.addURLs(totURLs, this.platformClassLoader.getResources(name));
        return new Enumeration<URL>(){
            Iterator<URL> iter;
            {
                this.iter = totURLs.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iter.next();
            }
        };
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void addURLs(List<URL> urls, Enumeration<URL> toAdd) {
        if (toAdd != null) {
            while (toAdd.hasMoreElements()) {
                urls.add(toAdd.nextElement());
            }
        }
    }

    static {
        String val = System.getProperty("vertx.loadWithPlatformCL");
        loadWithPlatformCL = val == null || Boolean.valueOf(val) != false;
        circDepTL = new ThreadLocal();
        recurseDepth = new ThreadLocal();
    }
}

