/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.tck;

import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgException;
import io.vertx.pgclient.PgPool;
import io.vertx.pgclient.junit.ContainerPgRule;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.tck.TransactionTestBase;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class PgTransactionTest
extends TransactionTestBase {
    @ClassRule
    public static ContainerPgRule rule = new ContainerPgRule();

    protected Pool createPool() {
        return PgPool.pool((Vertx)this.vertx, (PgConnectOptions)new PgConnectOptions(rule.options()), (PoolOptions)new PoolOptions().setMaxSize(1));
    }

    protected Pool nonTxPool() {
        return PgPool.pool((Vertx)this.vertx, (PgConnectOptions)new PgConnectOptions(rule.options()), (PoolOptions)new PoolOptions().setMaxSize(1));
    }

    protected String statement(String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                sb.append("$").append(i);
            }
            sb.append(parts[i]);
        }
        return sb.toString();
    }

    @Test
    public void testFailureWithPendingQueries(TestContext ctx) {
        Async async = ctx.async();
        this.connector.accept(ctx.asyncAssertSuccess(res -> {
            res.client.query("SELECT whatever from DOES_NOT_EXIST").execute(ctx.asyncAssertFailure(v -> {}));
            res.client.query("SELECT id, val FROM mutable").execute(ctx.asyncAssertFailure(err -> res.tx.rollback(ctx.asyncAssertSuccess(v -> async.complete()))));
        }));
    }

    @Test
    public void testDeferredConstraintTriggersRollbackOnCommit(TestContext ctx) {
        this.connector.accept(ctx.asyncAssertSuccess(res -> res.client.query("INSERT INTO deferred_constraints (name, parent) values ('john', 'mike')").execute().compose(ok -> res.tx.commit()).onComplete(ctx.asyncAssertFailure(failure -> {
            PgException pgEx = (PgException)failure;
            ctx.assertEquals((Object)"23503", (Object)pgEx.getCode());
        }))));
    }

    @Test
    public void testLongTransaction(TestContext ctx) {
        Async async = ctx.async(2);
        this.connector.accept(ctx.asyncAssertSuccess(res -> res.client.query("set idle_in_transaction_session_timeout = 500").execute().onComplete(ctx.asyncAssertSuccess(v -> {
            res.client.exceptionHandler(err -> {
                PgException pgErr = (PgException)err;
                ctx.assertEquals((Object)"25P03", (Object)pgErr.getCode());
                async.countDown();
            });
            res.client.closeHandler(v2 -> async.countDown());
        }))));
    }
}

