/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.tck;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.PgPool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.tck.Connector;

public enum ClientConfig {
    CONNECT{

        Connector<PgConnection> connect(final Vertx vertx, final SqlConnectOptions options) {
            return new Connector<PgConnection>(){

                public void connect(Handler<AsyncResult<PgConnection>> handler) {
                    PgConnection.connect((Vertx)vertx, (PgConnectOptions)new PgConnectOptions(options), ar -> {
                        if (ar.succeeded()) {
                            handler.handle((Object)Future.succeededFuture((Object)ar.result()));
                        } else {
                            handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                        }
                    });
                }

                public void close() {
                }
            };
        }
    }
    ,
    POOLED{

        Connector<SqlClient> connect(Vertx vertx, SqlConnectOptions options) {
            final PgPool pool = PgPool.pool((Vertx)vertx, (PgConnectOptions)new PgConnectOptions(options), (PoolOptions)new PoolOptions().setMaxSize(1));
            return new Connector<SqlClient>(){

                public void connect(Handler<AsyncResult<SqlClient>> handler) {
                    pool.getConnection(ar -> {
                        if (ar.succeeded()) {
                            handler.handle((Object)Future.succeededFuture((Object)ar.result()));
                        } else {
                            handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                        }
                    });
                }

                public void close() {
                    pool.close();
                }
            };
        }
    };


    abstract <C extends SqlClient> Connector<C> connect(Vertx var1, SqlConnectOptions var2);
}

