/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.junit;

import io.vertx.pgclient.PgConnectOptions;
import io.vertx.sqlclient.PoolOptions;
import org.junit.rules.ExternalResource;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.InternetProtocol;
import org.testcontainers.containers.PostgreSQLContainer;

public class ContainerPgRule
extends ExternalResource {
    private static final String connectionUri = System.getProperty("connection.uri");
    private static final String tlsConnectionUri = System.getProperty("tls.connection.uri");
    private ServerContainer<?> server;
    private PgConnectOptions options;
    private String databaseVersion;
    private boolean ssl;
    private String user = "postgres";

    public ContainerPgRule ssl(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public PgConnectOptions options() {
        return new PgConnectOptions(this.options);
    }

    public PoolOptions poolOptions() {
        return new PoolOptions();
    }

    public ContainerPgRule user(String user) {
        if (user == null) {
            throw new NullPointerException();
        }
        this.user = user;
        return this;
    }

    private void initServer(String version) throws Exception {
        this.server = (ServerContainer)((ServerContainer)((ServerContainer)((ServerContainer)new ServerContainer("postgres:" + version).withDatabaseName("postgres")).withUsername(this.user)).withPassword("postgres")).withClasspathResourceMapping("create-postgres.sql", "/docker-entrypoint-initdb.d/create-postgres.sql", BindMode.READ_ONLY);
        if (this.ssl) {
            ((ServerContainer)((ServerContainer)this.server.withClasspathResourceMapping("tls/server.crt", "/server.crt", BindMode.READ_ONLY)).withClasspathResourceMapping("tls/server.key", "/server.key", BindMode.READ_ONLY)).withClasspathResourceMapping("tls/ssl.sh", "/docker-entrypoint-initdb.d/ssl.sh", BindMode.READ_ONLY);
        }
        if (System.getProperties().containsKey("containerFixedPort")) {
            this.server.withFixedExposedPort(PostgreSQLContainer.POSTGRESQL_PORT, PostgreSQLContainer.POSTGRESQL_PORT);
        } else {
            this.server.withExposedPorts(new Integer[]{PostgreSQLContainer.POSTGRESQL_PORT});
        }
    }

    public static boolean isTestingWithExternalDatabase() {
        return ContainerPgRule.isSystemPropertyValid(connectionUri) || ContainerPgRule.isSystemPropertyValid(tlsConnectionUri);
    }

    private static boolean isSystemPropertyValid(String systemProperty) {
        return systemProperty != null && !systemProperty.isEmpty();
    }

    public synchronized PgConnectOptions startServer(String databaseVersion) throws Exception {
        this.initServer(databaseVersion);
        this.server.start();
        return new PgConnectOptions().setPort(this.server.getMappedPort(PostgreSQLContainer.POSTGRESQL_PORT).intValue()).setHost(this.server.getContainerIpAddress()).setDatabase("postgres").setUser(this.user).setPassword("postgres");
    }

    private static String getPostgresVersion() {
        String specifiedVersion = System.getProperty("embedded.postgres.version");
        String version = specifiedVersion == null || specifiedVersion.isEmpty() ? "10.10" : specifiedVersion;
        return version;
    }

    public synchronized void stopServer() throws Exception {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            finally {
                this.server = null;
            }
        }
    }

    protected void before() throws Throwable {
        if (ContainerPgRule.isTestingWithExternalDatabase()) {
            this.options = this.ssl ? PgConnectOptions.fromUri((String)tlsConnectionUri) : PgConnectOptions.fromUri((String)connectionUri);
            return;
        }
        if (this.server != null) {
            return;
        }
        this.databaseVersion = ContainerPgRule.getPostgresVersion();
        this.options = this.startServer(this.databaseVersion);
    }

    public static boolean isAtLeastPg10() {
        return !ContainerPgRule.getPostgresVersion().startsWith("9.");
    }

    protected void after() {
        if (!ContainerPgRule.isTestingWithExternalDatabase()) {
            try {
                this.stopServer();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class ServerContainer<SELF extends ServerContainer<SELF>>
    extends PostgreSQLContainer<SELF> {
        public ServerContainer(String dockerImageName) {
            super(dockerImageName);
        }

        public SELF withFixedExposedPort(int hostPort, int containerPort) {
            super.addFixedExposedPort(hostPort, containerPort, InternetProtocol.TCP);
            return (SELF)((Object)((ServerContainer)this.self()));
        }
    }
}

