/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.data.ExtendedQueryDataTypeCodecTestBase;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.util.UUID;
import org.junit.Test;

public class UUIDTypeExtendedCodecTest
extends ExtendedQueryDataTypeCodecTestBase {
    @Test
    public void testDecodeUUID(TestContext ctx) {
        this.testDecode(ctx, "SELECT '" + uuid + "'::UUID", Tuple::getUUID, uuid);
    }

    @Test
    public void testEncodeUUID(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"CharacterDataType\" SET \"uuid\" = $1 WHERE \"id\" = $2 RETURNING \"uuid\"", ctx.asyncAssertSuccess(p -> {
            UUID uuid = UUID.fromString("92b53cf1-2ad0-49f9-be9d-ca48966e43ee");
            p.query().execute(Tuple.tuple().addUUID(uuid).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)1, (Object)result.size());
                ctx.assertEquals((Object)1, (Object)result.rowCount());
                Row row = (Row)result.iterator().next();
                ColumnChecker.checkColumn((int)0, (String)"uuid").returns(Tuple::getValue, Row::getValue, (Object)uuid).returns(Tuple::getUUID, Row::getUUID, (Object)uuid).forRow(row);
                async.complete();
            }));
        }))));
    }

    @Test
    public void testDecodeUUIDArray(TestContext ctx) {
        this.testDecode(ctx, "SELECT '{ " + uuid + " }'::UUID[]", Tuple::getArrayOfUUIDs, new Object[]{new UUID[]{uuid}});
    }

    @Test
    public void testEncodeUUIDArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"UUID\" = $1  WHERE \"id\" = $2 RETURNING \"UUID\"", ctx.asyncAssertSuccess(p -> {
            UUID uuid = UUID.fromString("6f790482-b5bd-438b-a8b7-4a0bed747011");
            p.query().execute(Tuple.tuple().addArrayOfUUID(new UUID[]{uuid}).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
                ColumnChecker.checkColumn((int)0, (String)"UUID").returns(Tuple::getValue, Row::getValue, (Object[])new UUID[]{uuid}).returns(Tuple::getArrayOfUUIDs, Row::getArrayOfUUIDs, (Object[])new UUID[]{uuid}).forRow((Row)result.iterator().next());
                async.complete();
            }));
        }))));
    }
}

