/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.data.SimpleQueryDataTypeCodecTestBase;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;

public class JsonTypesSimpleCodecTest
extends SimpleQueryDataTypeCodecTestBase {
    private Object[] expected = new Object[]{new JsonObject("{\"str\":\"blah\",\"int\":1,\"float\":3.5,\"object\":{},\"array\":[]}"), new JsonArray("[1,true,null,9.5,\"Hi\"]"), 4, "Hello World", true, false, Tuple.JSON_NULL};

    @Test
    public void testJSONB(TestContext ctx) {
        this.testJson(ctx, "JSONB");
    }

    @Test
    public void testJSON(TestContext ctx) {
        this.testJson(ctx, "JSON");
    }

    private void testJson(TestContext ctx, String type) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT '  {\"str\":\"blah\", \"int\" : 1, \"float\" : 3.5, \"object\": {}, \"array\" : []   }'::" + type + " \"JsonObject\",'  [1,true,null,9.5,\"Hi\" ] '::" + type + " \"JsonArray\",' true '::" + type + " \"TrueValue\",' false '::" + type + " \"FalseValue\",' null '::" + type + " \"NullValue\",' 7.502 '::" + type + " \"Number1\",' 8 '::" + type + " \"Number2\",'\" Really Awesome! \"'::" + type + " \"Text\",NULL::" + type + " \"Null\"").execute(ctx.asyncAssertSuccess(result -> {
            JsonObject object = new JsonObject("{\"str\":\"blah\", \"int\" : 1, \"float\" : 3.5, \"object\": {}, \"array\" : []}");
            JsonArray array = new JsonArray("[1,true,null,9.5,\"Hi\"]");
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"JsonObject").returns(Tuple::getValue, Row::getValue, (Object)object).returns(Tuple::getJsonObject, Row::getJsonObject, (Object)object).returns(Tuple::getJson, Row::getJson, (Object)object).forRow(row);
            ColumnChecker.checkColumn((int)1, (String)"JsonArray").returns(Tuple::getValue, Row::getValue, (Object)array).returns(Tuple::getJsonArray, Row::getJsonArray, (Object)array).returns(Tuple::getJson, Row::getJson, (Object)array).forRow(row);
            ColumnChecker.checkColumn((int)2, (String)"TrueValue").returns(Tuple::getValue, Row::getValue, (Object)true).returns(Tuple::getBoolean, Row::getBoolean, (Object)true).returns(Tuple::getJson, Row::getJson, (Object)true).returns(Object.class, (Object)true).forRow(row);
            ColumnChecker.checkColumn((int)3, (String)"FalseValue").returns(Tuple::getValue, Row::getValue, (Object)false).returns(Tuple::getBoolean, Row::getBoolean, (Object)false).returns(Tuple::getJson, Row::getJson, (Object)false).returns(Object.class, (Object)false).forRow(row);
            ColumnChecker.checkColumn((int)4, (String)"NullValue").returns(Tuple::getValue, Row::getValue, Tuple.JSON_NULL).returns(Tuple::getJson, Row::getJson, Tuple.JSON_NULL).forRow(row);
            ColumnChecker.checkColumn((int)5, (String)"Number1").returns(Tuple::getValue, Row::getValue, (Object)7.502).returns(Tuple::getJson, Row::getJson, (Object)7.502).returns(Tuple::getShort, Row::getShort, (Object)7).returns(Tuple::getInteger, Row::getInteger, (Object)7).returns(Tuple::getLong, Row::getLong, (Object)7L).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(7.502f)).returns(Tuple::getDouble, Row::getDouble, (Object)7.502).returns(Tuple::getBigDecimal, Row::getBigDecimal, val -> Assert.assertEquals((double)val.doubleValue(), (double)7.502, (double)0.1)).returns(Object.class, (Object)7.502).forRow(row);
            ColumnChecker.checkColumn((int)6, (String)"Number2").returns(Tuple::getValue, Row::getValue, (Object)8).returns(Tuple::getJson, Row::getJson, (Object)8).returns(Tuple::getShort, Row::getShort, (Object)8).returns(Tuple::getInteger, Row::getInteger, (Object)8).returns(Tuple::getLong, Row::getLong, (Object)8L).returns(Tuple::getFloat, Row::getFloat, (Object)Float.valueOf(8.0f)).returns(Tuple::getDouble, Row::getDouble, (Object)8.0).returns(Tuple::getBigDecimal, Row::getBigDecimal, (Object)new BigDecimal(8)).returns(Object.class, (Object)8).forRow(row);
            ColumnChecker.checkColumn((int)7, (String)"Text").returns(Tuple::getValue, Row::getValue, (Object)" Really Awesome! ").returns(Tuple::getJson, Row::getJson, (Object)" Really Awesome! ").returns(Tuple::getString, Row::getString, (Object)" Really Awesome! ").returns(Object.class, (Object)" Really Awesome! ").forRow(row);
            ColumnChecker.checkColumn((int)8, (String)"Null").returnsNull().forRow(row);
            async.complete();
        }))));
    }

    @Test
    public void testDecodeJSONArray(TestContext ctx) {
        ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"JSON").returns(Tuple::getValue, Row::getValue, this.expected).skip(Tuple::getArrayOfBooleans, Row::getArrayOfBooleans).skip(Tuple::getArrayOfShorts, Row::getArrayOfShorts).skip(Tuple::getArrayOfIntegers, Row::getArrayOfIntegers).skip(Tuple::getArrayOfLongs, Row::getArrayOfLongs).skip(Tuple::getArrayOfFloats, Row::getArrayOfFloats).skip(Tuple::getArrayOfDoubles, Row::getArrayOfDoubles).skip(Tuple::getArrayOfStrings, Row::getArrayOfStrings).skip(Tuple::getArrayOfJsonObjects, Row::getArrayOfJsonObjects).skip(Tuple::getArrayOfJsonArrays, Row::getArrayOfJsonArrays).skip(Tuple::getArrayOfJsons, Row::getArrayOfJsons);
        this.testDecodeGenericArray(ctx, "ARRAY ['  {\"str\":\"blah\", \"int\" : 1, \"float\" : 3.5, \"object\": {}, \"array\" : []   }' :: JSON, '[1,true,null,9.5,\"Hi\"]' :: JSON, '4' :: JSON, '\"Hello World\"' :: JSON, 'true' :: JSON, 'false' :: JSON, 'null' :: JSON]", "JSON", checker);
    }

    @Test
    public void testDecodeJSONBArray(TestContext ctx) {
        ColumnChecker checker = ColumnChecker.checkColumn((int)0, (String)"JSONB").returns(Tuple::getValue, Row::getValue, this.expected).skip(Tuple::getArrayOfBooleans, Row::getArrayOfBooleans).skip(Tuple::getArrayOfShorts, Row::getArrayOfShorts).skip(Tuple::getArrayOfIntegers, Row::getArrayOfIntegers).skip(Tuple::getArrayOfLongs, Row::getArrayOfLongs).skip(Tuple::getArrayOfFloats, Row::getArrayOfFloats).skip(Tuple::getArrayOfDoubles, Row::getArrayOfDoubles).skip(Tuple::getArrayOfStrings, Row::getArrayOfStrings).skip(Tuple::getArrayOfJsonObjects, Row::getArrayOfJsonObjects).skip(Tuple::getArrayOfJsonArrays, Row::getArrayOfJsonArrays).skip(Tuple::getArrayOfJsons, Row::getArrayOfJsons);
        this.testDecodeGenericArray(ctx, "ARRAY ['  {\"str\":\"blah\", \"int\" : 1, \"float\" : 3.5, \"object\": {}, \"array\" : []   }' :: JSON, '[1,true,null,9.5,\"Hi\"]' :: JSON, '4' :: JSON, '\"Hello World\"' :: JSON, 'true' :: JSON, 'false' :: JSON, 'null' :: JSON]", "JSONB", checker);
    }
}

