/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.data.DataTypeTestBase;
import io.vertx.pgclient.data.Inet;
import io.vertx.sqlclient.Query;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.Tuple;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.function.BiFunction;
import org.junit.Test;

public class InetCodecTest
extends DataTypeTestBase {
    @Test
    public void testBinaryDecodeINET(TestContext ctx) throws Exception {
        this.testDecodeINET(ctx, SqlClient::preparedQuery);
    }

    @Test
    public void testTextDecodeINET(TestContext ctx) throws Exception {
        this.testDecodeINET(ctx, SqlClient::query);
    }

    private void testDecodeINET(TestContext ctx, BiFunction<SqlClient, String, Query<RowSet<Row>>> a) throws Exception {
        InetAddress addr1 = Inet4Address.getByName("0.1.2.3");
        InetAddress addr2 = Inet6Address.getByName("2001:0db8:0a0b:12f0:0000:0000:0000:0001");
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> ((Query)a.apply((SqlClient)conn, "SELECT '0.1.2.3'::INET,'0.1.2.3/4'::INET,'2001:0db8:0a0b:12f0:0000:0000:0000:0001'::INET,'2001:0db8:0a0b:12f0:0000:0000:0000:0001/4'::INET")).execute(ctx.asyncAssertSuccess(rows -> {
            ctx.assertEquals((Object)1, (Object)rows.size());
            Row row = (Row)rows.iterator().next();
            Inet v1 = (Inet)row.getValue(0);
            Inet v2 = (Inet)row.getValue(1);
            Inet v3 = (Inet)row.getValue(2);
            Inet v4 = (Inet)row.getValue(3);
            ctx.assertEquals((Object)addr1, (Object)v1.getAddress());
            ctx.assertNull((Object)v1.getNetmask());
            ctx.assertEquals((Object)addr1, (Object)v2.getAddress());
            ctx.assertEquals((Object)4, (Object)v2.getNetmask());
            ctx.assertEquals((Object)addr2, (Object)v3.getAddress());
            ctx.assertNull((Object)v3.getNetmask());
            ctx.assertEquals((Object)addr2, (Object)v4.getAddress());
            ctx.assertEquals((Object)4, (Object)v4.getNetmask());
        }))));
    }

    @Test
    public void testBinaryEncodeINET(TestContext ctx) throws Exception {
        InetAddress addr1 = Inet4Address.getByName("0.1.2.3");
        InetAddress addr2 = Inet6Address.getByName("2001:0db8:0a0b:12f0:0000:0000:0000:0001");
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT ($1::INET)::VARCHAR, ($2::INET)::VARCHAR, ($3::INET)::VARCHAR, ($4::INET)::VARCHAR").execute(Tuple.of((Object)new Inet().setAddress(addr1), (Object)new Inet().setAddress(addr1).setNetmask(Integer.valueOf(4)), (Object)new Inet().setAddress(addr2), (Object)new Inet().setAddress(addr2).setNetmask(Integer.valueOf(4))), ctx.asyncAssertSuccess(rows -> {
            ctx.assertEquals((Object)1, (Object)rows.size());
            Row row = (Row)rows.iterator().next();
            String v1 = row.getString(0);
            String v2 = row.getString(1);
            String v3 = row.getString(2);
            String v4 = row.getString(3);
            ctx.assertEquals((Object)"0.1.2.3/32", (Object)v1);
            ctx.assertEquals((Object)"0.1.2.3/4", (Object)v2);
            ctx.assertEquals((Object)"2001:db8:a0b:12f0::1/128", (Object)v3);
            ctx.assertEquals((Object)"2001:db8:a0b:12f0::1/4", (Object)v4);
        }))));
    }

    @Test
    public void testBinaryDecodeINETArray(TestContext ctx) throws Exception {
        InetAddress addr1 = Inet4Address.getByName("0.1.2.3");
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT ARRAY['0.1.2.3'::INET,'0.1.2.3/4'::INET]").execute(ctx.asyncAssertSuccess(rows -> {
            ctx.assertEquals((Object)1, (Object)rows.size());
            Row row = (Row)rows.iterator().next();
            Inet[] array = (Inet[])row.getValue(0);
            Inet v1 = array[0];
            Inet v2 = array[1];
            ctx.assertEquals((Object)addr1, (Object)v1.getAddress());
            ctx.assertNull((Object)v1.getNetmask());
            ctx.assertEquals((Object)addr1, (Object)v2.getAddress());
            ctx.assertEquals((Object)4, (Object)v2.getNetmask());
        }))));
    }

    @Test
    public void testBinaryEncodeINETArray(TestContext ctx) throws Exception {
        InetAddress addr1 = Inet4Address.getByName("0.1.2.3");
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT ($1::INET[])::VARCHAR[]").execute(Tuple.of((Object)new Inet[]{new Inet().setAddress(addr1), new Inet().setAddress(addr1).setNetmask(Integer.valueOf(4))}), ctx.asyncAssertSuccess(rows -> {
            ctx.assertEquals((Object)1, (Object)rows.size());
            Row row = (Row)rows.iterator().next();
            String[] array = row.getArrayOfStrings(0);
            String v1 = array[0];
            String v2 = array[1];
            ctx.assertEquals((Object)"0.1.2.3/32", (Object)v1);
            ctx.assertEquals((Object)"0.1.2.3/4", (Object)v2);
        }))));
    }
}

