/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.data.ExtendedQueryDataTypeCodecTestBase;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import org.junit.Test;

public class EnumeratedTypesExtendedCodecTest
extends ExtendedQueryDataTypeCodecTestBase {
    @Test
    public void testDecodeEnum(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT \"currentMood\" FROM \"EnumDataType\" WHERE \"id\" = $1", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addInteger(Integer.valueOf(1)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"currentMood").returns(Tuple::getValue, Row::getValue, (Object)"ok").returns(Tuple::getString, Row::getString, (Object)"ok").forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeEnum(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"EnumDataType\" SET \"currentMood\" = $1  WHERE \"id\" = $2 RETURNING \"currentMood\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addString("happy").addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            Row row = (Row)result.iterator().next();
            ColumnChecker.checkColumn((int)0, (String)"currentMood").returns(Tuple::getValue, Row::getValue, (Object)"happy").returns(Tuple::getString, Row::getString, (Object)"happy").forRow(row);
            async.complete();
        }))))));
    }

    @Test
    public void testDecodeEnumArray(TestContext ctx) {
        String[] expected = new String[]{"ok", "unhappy", "happy"};
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT \"Enum\" FROM \"ArrayDataType\" WHERE \"id\" = $1", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addInteger(Integer.valueOf(1)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Enum").returns(Tuple::getValue, Row::getValue, (Object[])expected).returns(Tuple::getArrayOfStrings, Row::getArrayOfStrings, (Object[])expected).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeEnumArray(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"Enum\" = $1 WHERE \"id\" = $2 RETURNING \"Enum\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addArrayOfString(new String[]{"unhappy"}).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Enum").returns(Tuple::getValue, Row::getValue, (Object[])new String[]{"unhappy"}).returns(Tuple::getArrayOfStrings, Row::getArrayOfStrings, (Object[])new String[]{"unhappy"}).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeEnumArrayMultipleValues(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"Enum\" = $1 WHERE \"id\" = $2 RETURNING \"Enum\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addArrayOfString(new String[]{"unhappy", "ok"}).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Enum").returns(Tuple::getValue, Row::getValue, (Object[])new String[]{"unhappy", "ok"}).returns(Tuple::getArrayOfStrings, Row::getArrayOfStrings, (Object[])new String[]{"unhappy", "ok"}).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }

    @Test
    public void testEncodeEnumArrayEmptyValues(TestContext ctx) {
        Async async = ctx.async();
        PgConnection.connect((Vertx)this.vertx, (PgConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("UPDATE \"ArrayDataType\" SET \"Enum\" = $1 WHERE \"id\" = $2 RETURNING \"Enum\", \"Boolean\"", ctx.asyncAssertSuccess(p -> p.query().execute(Tuple.tuple().addArrayOfString(new String[0]).addInteger(Integer.valueOf(2)), ctx.asyncAssertSuccess(result -> {
            ColumnChecker.checkColumn((int)0, (String)"Enum").returns(Tuple::getValue, Row::getValue, (Object[])new String[0]).returns(Tuple::getArrayOfStrings, Row::getArrayOfStrings, (Object[])new String[0]).forRow((Row)result.iterator().next());
            ColumnChecker.checkColumn((int)1, (String)"Boolean").returns(Tuple::getValue, Row::getValue, (Object[])new Boolean[]{true}).returns(Tuple::getArrayOfBooleans, Row::getArrayOfBooleans, (Object[])new Boolean[]{true}).forRow((Row)result.iterator().next());
            async.complete();
        }))))));
    }
}

